﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using nft.framework.drawing;

namespace nft.core.game {
    public class PointerEventArgs : EventArgs{
        protected MouseEventArgs eventOrg;
        protected IGame game;
        protected ISurface surface;

        public PointerEventArgs(IGame gm, ISurface surf) {
            this.game = gm;
            this.surface = surf;
        }

        public IGame Game {
            get {
                return game;
            }
        }

        public ISurface Surface {
            get {
                return surface;
            }
        }

        public MouseEventArgs OriginalEventArgs {
            get {
                return eventOrg;
            }
        }
    }
}
