﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.impl.view;
using nft.core.geometry;

namespace nft.core.view {
    public delegate void ViewEventHandler(ViewEventArgs ea);
    public delegate void ViewQueryEventHandler(ViewQueryEventArgs ea);
    public interface IView {
        event ViewEventHandler OnClose;
        event ViewQueryEventHandler QueryClose;

        SceneBuilder SceneBuilder {
            get;
        }

        InterCardinalDirection UpperDirection {
            get;
            set;
        }

        void Close();
    }

    public class ViewEventArgs : EventArgs {
        public readonly IView View;
        public ViewEventArgs(IView v) {
            View = v;
        }
    }

    public class ViewQueryEventArgs : ViewEventArgs {
        public bool Cancel;
        public ViewQueryEventArgs(IView v): base(v) {
            Cancel = false;
        }
    }
}
