using System;
using System.Xml;
using nft.framework;
using nft.framework.plugin;
using nft.util;
using nft.ui.mainframe;
using nft.framework.drawing;

namespace nft.contributions.ui
{
	/// <summary>
	/// CtbMenuItem ̊Tv̐łB
	/// </summary>
	public class CtbCommandUIGroup : Contribution
	{
		
		public readonly string location;
		protected readonly string after = null;
		protected readonly string before = null;

		/// <summary>
		/// Contributes a menu and submenu items to mainmenu.
		/// 
		/// This contribution can add several items at once.
		/// </summary>
        public CtbCommandUIGroup(Plugin p, ParamsReader e)
            : base(p, e) 
		{
            string cap = e["caption"].InnerText;
            string scap = e["short-caption"].InnerTextOr(cap);
            string lcap = e["long-caption"].InnerTextOr(cap);
            string desc = e["description"].InnerTextOr(lcap);
            string iconpath = e["icon"].InnerTextOr(cap);
            ImageRef imgref = PluginImageManager.GetBundledImageRef(this, e, iconpath);
		}

	}
}
