using System;
using System.Collections;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;
using System.Xml;
//using Microsoft.Win32;
using nft.util;
using nft.ui;
using nft.ui.mainframe;
using nft.framework.plugin;
using System.Drawing;
using System.Runtime;
using nft.framework.drawing;
using System.Reflection;

namespace nft.framework
{

	/// <summary>
	/// Entry point to other static instances in the NeoFreeTrain framework.
	/// </summary>
	public sealed class Main
	{
		// no instantiation
		private Main() {}		

		/// <summary> the main window frame </summary>
		private static MainFrame theFrame;
		public static IBarHostFrame mainFrame
		{	get{ return theFrame; } 	}

		/// <summary> Main resources. </summary>
        //public static readonly NftProperties resources = NftProperties.LoadFromFile(Directories.AppBaseDir + "nftfw.resource.xml", false);

		/// <summary> Plug-ins. </summary>
		public static readonly PluginManager pluginManager = new PluginManager();

		#region sound and BGM
/*		
		/// <summary>
		/// Handles BGM playback.
		/// Should be instanciated by attaching the main window.
		/// </summary>
		public static BGMManager bgmManager { get { return _bgmManager; } }

		/// <summary>
		/// Handles SFX.
		/// Should be instanciated by attaching the main window.
		/// </summary>
		public static SoundEffectManager soundEffectManager { get { return _soundEffectManager; } }
		

		private static SoundEffectManager _soundEffectManager;
		private static BGMManager _bgmManager;
*/
		#endregion

		/// <summary>
		/// Initializes the framework.
		/// Should be called once and only once.
		/// </summary>
		/// <param name="additionalPluginDirs">
		/// additional directories from which plug-ins are loaded.
		/// </param>
		/// <param name="owner">application's main window.</param>
		/// <param name="bgmMenuItem">"BGM" sub-menu</param>
		/// <param name="progressHandler">
		/// Receives initializtion progress report. Can be null.
		/// </param>
		public static void init( string[] args, MainFrame frame ) 
		{
            I18n.LoadFile(Directories.AppBaseDir + "nftfw.resource.xml");
			Hashtable h_args = paresArgs(args);
            InitializeAssemblies();
            Directories.Initialize(h_args);

            //InformationService service = new InformationService();
			theFrame = frame;
			// To avoid ReBar trouble, we need to show MainFrame
			// before Splash window created.

			using(Splash s = new Splash()) 
			{
				s.Show();
                new FiberSample().Test();
				ProgressMonitor monitor = new ProgressMonitor(2);
				monitor.SetMaximum(1,5);
				monitor.OnProgress += new ProgressHandler(s.updateMessage);
				Application.DoEvents();
				// load global modules;
				GlobalModules.Initialize();
				// load plug-ins
				Main.pluginManager.init(new string[]{Directories.PluginDir}, monitor);
			}

			//new PluginListDialog().ShowDialog();

			
//			_soundEffectManager = new SoundEffectManager(owner);
//			_bgmManager = new BGMManager(bgmMenuItem);
		}

        private static Hashtable paresArgs(string[] args)
		{
			Hashtable table = new Hashtable();
			for(int i=0;i<args.Length;i++)
			{
				string[] v = args[i].Split(new char[]{'='},2);
				if(v.Length==2)
					table.Add(v[0].ToUpper(),v[1]);
				else
					table.Add(v[0].ToUpper(),string.Empty);
			}
			return table;
		}

        private static void InitializeAssemblies() {
            AppDomain.CurrentDomain.AssemblyLoad += new AssemblyLoadEventHandler(AssemblyInitializer);
            Assembly[] asms = AppDomain.CurrentDomain.GetAssemblies();
            foreach (Assembly asm in asms) {
                AssemblyInitializer(null, new AssemblyLoadEventArgs(asm));
            }
        }

        private static void AssemblyInitializer(object sender, AssemblyLoadEventArgs args) {
            Assembly asm = args.LoadedAssembly;
            if (asm.GlobalAssemblyCache) 
                return;
            // force static constructors in types specified by InitializeOnLoad
            object[] attributes = asm.GetCustomAttributes(typeof(InitializeOnLoadAttribute), false);
            foreach (InitializeOnLoadAttribute attr in attributes) {
                System.Runtime.CompilerServices.RuntimeHelpers.RunClassConstructor(attr.Type.TypeHandle);
                Debug.WriteLine("Init class on load assembly: class="+attr.Type.FullName+ ", module="+ Path.GetFileName(asm.CodeBase));
            }
        }
	}
}
