﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace nft.framework
{
    [AttributeUsage(AttributeTargets.Method, AllowMultiple=true)]
    public class TestEntryAttribute: Attribute
    {
        protected object[] _arguments = null;
        protected string _caps;

        public TestEntryAttribute()
            : this(null, null) {
        }
        public TestEntryAttribute(String caption)
            : this(caption, null) {
        }
        public TestEntryAttribute(object[] args)
            : this(null, args) {
        }
        public TestEntryAttribute(String caption, object[] args) {
            this._arguments = args;
            this._caps = caption;
        }

        public String Caption {
            get { return _caps; }
            set { _caps = value; }
        }

        public object[] Arguments {
            get { return _arguments; }
            set { _arguments = value; }
        }
    }
}
