using System;
using System.Collections;
using nft.util;
using nft.framework;

namespace nft.ui.command
{
	/// <summary>
	/// the interface that the module you want to be called should be implement.
	/// </summary>
	public interface ICommandEntity_Old
	{
		void CommandExecuted( CommandUI_Old cmdUI,object sender );
	}

	/// <summary>
	/// CommandUI manages state of all related GUI controls.
	/// Set EventHandler of related controls to call ICommandEntity.
	/// </summary>
	public class CommandUI_Old
	{
		static private Hashtable table = new Hashtable();
		static public CommandUI_Old GetCommandUI(string id)
		{
			return (CommandUI_Old)table[id];
		}

		public readonly string ID;
		protected bool _checked;
		protected bool enabled;
		protected object optionState = null;
		protected ICommandEntity_Old entity;
		protected ArrayList triggers = new ArrayList();

		public CommandUI_Old(string id, ICommandEntity_Old _entity, bool _checked, bool _enabled )
		{
			if(table.ContainsKey(id))
				throw new InvalidOperationException("Duplicate command ID");
			this.ID = id;
			this.entity = _entity;
			this._checked = _checked;
			enabled = _enabled;
			table.Add(id,this);
		}

		public CommandUI_Old(string id, ICommandEntity_Old _entity)
			: this( id, _entity, false, true )
		{
		}

		
		#region getters / setters
		public bool Checked
		{
			get{ return _checked; }
			set
			{
				_checked = value;
				foreach(ICommandTrigger trigger in triggers )
					trigger.Checked = _checked;
			}
		}
		public bool Enabled
		{
			get{ return enabled; }
			set
			{
				enabled = value;
				foreach(ICommandTrigger trigger in triggers )
					trigger.Enabled = enabled;
			}
		}
		public object OptionState
		{
			get{ return optionState; }
			set
			{
				optionState = value;
				foreach(ICommandTrigger trigger in triggers )
					trigger.OptionStateChanged(optionState);
			}
		}
		#endregion

		internal protected void Update()
		{
			foreach(ICommandTrigger trigger in triggers )
			{
				trigger.Checked = _checked;
				trigger.Enabled = enabled;
			}
		}
		
		internal protected void AddTrigger( ICommandTrigger trigger )
		{
			if( triggers.Contains( trigger ) ) return;
			triggers.Add(trigger);
			trigger.AddEventHandler(new EventHandler(TriggerEventHandler));
		}

		internal protected void RemoveTrigger( ICommandTrigger trigger )
		{
			trigger.RemoveEventHandler(new EventHandler(TriggerEventHandler));
			triggers.Remove(trigger);
		}

		protected void TriggerEventHandler(object sender, EventArgs args)
		{
            try
			{
                entity.CommandExecuted(this, sender);
            }
			catch(Exception e)
			{
                string msg = I18n.T("Exception raised while executing the command[ID={0}].",ID);
				if(UIUtil.ShowException(msg,e,UIInformLevel.normal))
                    throw;
			}
		}
	}


}
