using System;
using System.Windows.Forms;
using System.Xml;
using nft.framework;
using nft.contributions.ui;
using WeifenLuo.WinFormsUI.Docking;
using nft.ui.mainframe;
using nft.framework.plugin;

namespace nft.ui.command {
    /// <summary>
    /// 
    /// </summary>
    public class SubformCommand : ICommandEntity_Old {
        static SubformCommand() {
            ((MainFrame)Main.mainFrame).DockingManager.RegisterResolver(ResolveDockContent);
        }

        public static DockContent ResolveDockContent(string persist) {
            int n = persist.IndexOf(CtbSubform.SepalatorPersist);
            string id = persist.Substring(0, n);
            string nam = persist.Substring(n + CtbSubform.SepalatorPersist.Length);
            CtbCommandEntity ctb = PluginManager.theInstance.GetContribution(id) as CtbCommandEntity;
            if (ctb != null) {
                SubformCommand sc = ctb.CommandEntity as SubformCommand;
                if (sc != null) {
                    return sc.innerCtb.GetContent(nam, true).Parent as DockContent;
                }
            }
            return null;
        }

        readonly CtbSubform innerCtb;

        public SubformCommand(ParamsReader e) {
            innerCtb = new CtbSubform(null, e);
        }

        public void CommandExecuted(CommandUI_Old cmdUI, object sender) {
            innerCtb.Show("");
        }
    }
}
