﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace nft.framework.drawing {
    public class ColorUtil {
        public static Color GetDarker(Color src, double ratio){
            ratio = 1 - ratio;
            double r = ratio * src.R;
            double g = ratio * src.G;
            double b = ratio * src.B;
            return Color.FromArgb(src.A, (int)r, (int)g, (int)b);
        }

        public static Color GetDarker(Color src, int brightness255) {
            int R = (src.R * brightness255) >> 8;
            int G = (src.G * brightness255) >> 8;
            int B = (src.B * brightness255) >> 8;
            return Color.FromArgb(R, G, B);
        }

        public static Color GetBlighter(Color src, double ratio) {
            double r = src.R + ratio * (255 - src.R);
            double g = src.G + ratio * (255 - src.G);
            double b = src.B + ratio * (255 - src.B);
            return Color.FromArgb(src.A, (int)r, (int)g, (int)b);
        }

        public static Color To12BitColor(Color org) {
            long rgb = org.ToArgb();
            rgb = (((rgb & 0x101010) * 0xf) >> 4) | (rgb & 0xfff0f0f0);
            return Color.FromArgb((int)rgb);
        }
    }
}
