﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using nft.util;
using System.Diagnostics;

namespace nft.framework.plugin {
    /// <summary>
    /// Instantiate a Contribution class by custom method (maybe according to the description of XML element)
    /// The Contribution should be an instance of specified baseType.
    /// <seealso cref="CustomContributionFactory"/>
    /// </summary>
    [PrimitiveContribution]
    public abstract class CtbCustomCtbFactory : Contribution, IContributionFactory {
        public CtbCustomCtbFactory(Plugin p, ParamsReader e)
            : base(p, e) {
            baseType = PluginUtil.loadTypeFromManifest(e["class"]);
        }

        #region IContributionFactory メンバ
        private readonly Type baseType;
        public Type OutputType { get { return baseType; } }

        public Contribution load(Plugin owner, ParamsReader e) {
            Contribution contrib = Create(owner, e);
            Debug.Assert(baseType.IsInstanceOfType(contrib));
            return contrib;
        }
        #endregion

        protected abstract Contribution Create(Plugin owner, ParamsReader e);

    }
}
