﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.framework.drawing;
using System.IO;
using System.Runtime.Serialization;
using System.Drawing;
using System.Diagnostics;

namespace nft.framework.plugin {
    class PluginImageManager {
        /// <summary>
        /// load image from the plugin directory.
        /// </summary>
        /// <param name="pr">used to specify the owner plugin</param>
        /// <param name="relativePath">relative path for image, under the plugin dir</param>
        /// <returns></returns>
        public static ImageRef GetBundledImageRef(Contribution ctb, ParamsReader pr, string relativePath) {
            IFileSource src = pr.GetFileSource(relativePath);
            if (src == null) {
                Debug.WriteLine("Bundle image not found for path="+relativePath);
                return null;
            }
            return ImageRef.FromFile(src);
        }

        /// <summary>
        /// load image from data directory.
        /// files in the data directory should be created at the first boot.
        /// </summary>
        /// <param name="ctb">used to specify the data directroy</param>
        /// <param name="relativePath">relative path for image, under the contribution data dir</param>
        /// <returns></returns>
        [Obsolete]
        public static ImageRef GetCachedImageRef(Contribution ctb, string relativePath) {
            string path = Path.Combine(ctb.DataDirectory, relativePath);
            return ImageRef.FromFile(path);
        }
    }
}
