﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.framework.drawing;
using System.Windows.Forms;
using System.Drawing;

namespace nft.ui {
    public delegate void ViewEventHandler(ViewEventArgs ea);
    public delegate void ViewQueryEventHandler(ViewQueryEventArgs ea);
    public delegate void ViewPointEventHandler(ViewPointEventArgs ea);
    public interface IView {
        event ViewEventHandler OnClose;
        event ViewQueryEventHandler QueryClose;
        event ViewEventHandler Activated;
        event ViewPointEventHandler ViewPointChanged;
        event MouseEventHandler MouseCursorMove;
        event MouseEventHandler MouseButtonDown;
        event MouseEventHandler MouseButtonUp;
        event EventHandler SurfacePrepared;

        ISurface Surface {
            get;
        }

        void SetScrollParams(Size contentSize);

        void Refresh();

        void Close();
    }

    public class ViewEventArgs : EventArgs {
        public readonly IView View;
        public ViewEventArgs(IView v) {
            View = v;
        }
    }

    public class ViewQueryEventArgs : ViewEventArgs {
        public bool Cancel;
        public ViewQueryEventArgs(IView v): base(v) {
            Cancel = false;
        }
    }

    public class ViewPointEventArgs : EventArgs {
        public readonly IView View;
        private readonly int X, Y;
        public ViewPointEventArgs(IView v, int x, int y) {
            View = v;
            X = x;
            Y = y;
        }

        public Point Position { get { return new Point(X, Y); } }
    }
}
