﻿using System;
using System.Collections.Generic;
using System.Text;

namespace nft.ui.controller
{
    public delegate void ObjectChooserEventHandler(ObjectChooserEventArgs e);
    public interface IObjectChooser
    {
        Type PhaseEnum { get; }
        object CurrentPhase { get; }
        object CurrentChoice { get; }
        event ObjectChooserEventHandler PhaseChanging;
        event ObjectChooserEventHandler PhaseChanged;
    }

    public class ObjectChooserEventArgs : EventArgs
    {
        public enum EventTypes { NEXT_PHASE, PREV_PHASE, RESET_PHASE, COMPLETE };

        public ObjectChooserEventArgs() {
        }

        private IObjectChooser _chooser;
        public IObjectChooser Sender { get { return _chooser; } }
        private EventTypes _type;
        public EventTypes EventType { get { return _type; } }
    }
}
