﻿using nft.framework.plugin;
using System;
using System.Collections.Generic;
using System.Text;

namespace nft.ui.mainframe_old {

    public interface IToolWindowsManager {
        void RegisterFactiory(string name, object factory);

        IToolWindow GetOrCreate(string name);

        event EventHandler<ToolWindowActivateEventArgs> ToolWindowActivate;

        IToolWindow ActiveTool { get; } 
    }

    public class ToolWindowActivateEventArgs : EventArgs {
        readonly IToolWindowsManager source;
        readonly String name;
        
        public ToolWindowActivateEventArgs(IToolWindowsManager manager, string activatedName) {
            this.source = manager;
            this.name = activatedName;
        }

        public IToolWindowsManager Soruce {
            get { return source; }
        }

        public string ActivatedWindowName {
            get { return name; }
        }

    }


    public class DefaultToolWindowsManager: IToolWindowsManager {

        public void RegisterFactiory(string name, object factory) {
            throw new NotImplementedException();
        }

        public IToolWindow GetOrCreate(string name) {
            throw new NotImplementedException();
        }

        public event EventHandler<ToolWindowActivateEventArgs> ToolWindowActivate;

        public IToolWindow ActiveTool {
            get { throw new NotImplementedException(); }
        }
    }
}
