﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace nft.util {
    public class RectObjectMap<T> {

        protected List<RectObjectEntry<T>> oblist;
        protected List<RectObjectEntry<RectObjectMap<T>>> divisions;
        protected Rectangle bounds;
        public Rectangle Bounds {
            get { return bounds; }
        }

        public Size MapSize {
            get { return bounds.Size; }
        }

        public IEnumerator<T> GetContainedIn(Rectangle area) {
            IEnumerator<RectObjectEntry<T>> en = oblist.GetEnumerator();
            while (en.MoveNext()) {
                RectObjectEntry<T> entry = en.Current;
                RectObjectMap<T> sublist = entry.obj as RectObjectMap<T>;
                if (sublist != null) {
                    IEnumerator<T> en2 = sublist.GetContainedIn(area);
                    while (en2.MoveNext()) {
                        yield return en2.Current;
                    }
                } else {
                    yield return (T)entry.obj;
                }
            }
            yield break;
        }

        public void Add(Rectangle bounds, T o) {
            RectObjectEntry<T> entry = new RectObjectEntry<T>(bounds, o);
        }

    }

    public class RectObjectEntry<T> {
        public RectObjectEntry(Rectangle bounds, T o) {
            this.Bounds = bounds;
            this.obj = o;
        }

        public readonly Rectangle Bounds;
        public T obj;
        public override bool Equals(object other) {
            RectObjectEntry<T> e = other as RectObjectEntry<T>;
            if (e != null) {
                return this.obj.Equals(e.obj);
            } else {
                return false;
            }
        }
        public override int GetHashCode() {
            return obj.GetHashCode();
        }
    }
}
