using System;
using System.Windows.Forms;
using nft.framework;

namespace nft.ui.command
{
	/// <summary>
	/// 
	/// </summary>
    public class ModalFormCommand : ITriggerCommandProcedure
	{
		const string FormFullName = "System.Windows.Forms.Form";
		readonly Type formClass;

		public ModalFormCommand(Type FormClass)
		{
			formClass = FormClass;
		}
		
        public void Execute() {
            Form f = Activator.CreateInstance(formClass) as Form;
            f.ShowDialog(Main.mainFrame as IWin32Window);
        }

        public bool Enable {
            get { return true; }
        }

        public event EventHandler EnableChanged;
    }
}
