﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.framework;
using nft.ui.form;
using System.Xml;
using System.Windows.Forms;

namespace nft.ui
{
    public class WinFormManager : IFormManager
    {

        public WinFormManager(ParamsReader node) {
        }

        public void Register(string name, Type win_form_class) {
            if (win_form_class==null || typeof(Form).IsSubclassOf(win_form_class)) {
                throw new ArgumentException("Requires subclass of System.Window.Froms","win_form_class");
            }
            WinFormWrapper wrap = new WinFormWrapper(win_form_class);
        }

        #region IGlobalModule implementation
        public Type RegistType {
            get { return typeof(IFormManager); }
        }

        public string Name {
            get { return "WinFormManager"; }
        }

        public string Description {
            get { return "A Manager for Fomrs based on Windows.Forms class"; }
        }
        #endregion
    }
}
