//-----------------------------------------------------------------------------
// Common.fxh
//
// Microsoft XNA Community Game Platform
// Copyright (C) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------


float ComputeFogFactor(float4 position)
{
    return saturate(dot(position, FogVector));
}


void ApplyFog(inout float4 color, float fogFactor)
{
    color.rgb = lerp(color.rgb, FogColor * color.a, fogFactor);
}


void AddSpecular(inout float4 color, float3 specular)
{
    color.rgb += specular * color.a;
}


struct CommonVSOutput
{
    float4 Pos_ps;
    float4 Diffuse;
    float3 Specular;
    float  FogFactor;
};


CommonVSOutput ComputeCommonVSOutput(float4 position)
{
    CommonVSOutput vout;
    
    vout.Pos_ps = mul(position, WorldViewProj);
    vout.Diffuse = DiffuseColor;
    vout.Specular = 0;
    vout.FogFactor = ComputeFogFactor(position);
    
    return vout;
}

//#define SetCommonVSOutputParams \
//    vout.PositionPS = cout.Pos_ps; \
//    vout.Diffuse = cout.Diffuse; \
//    vout.Specular = float4(cout.Specular, cout.FogFactor);

//#define SetCommonVSOutputParamsNoFog \
//    vout.PositionPS = cout.Pos_ps; \
//    vout.Diffuse = cout.Diffuse;

#define SetCommonVSOutputParams \
    vout.PositionPS = mul(vin.Position, WorldViewProj); \
	vout.PositionW = mul(vin.Position, World); \
    vout.Diffuse = DiffuseColor; \
	float3 sp = 0; \
	float ff = ComputeFogFactor(vin.Position); \
    vout.Specular = float4(sp, ff);

#define SetCommonVSOutputParamsNoFog \
    vout.PositionPS = mul(vin.Position, WorldViewProj); \
	vout.PositionW = mul(vin.Position, World); \
    vout.Diffuse = DiffuseColor; \
	vout.Specular = 0;

#define AdjustTextureRegion \
    vout.TexCoord = vin.TexCoord * TextureScale + TextureOffset;

#define CalcDepthParam (vout.PositionPS.z / vout.PositionPS.w)

#define SetCommonPSOutputTx \
    float4 color = SAMPLE_TEXTURE(Texture, pin.TexCoord) * pin.Diffuse; \
    clip((color.a < AlphaTest.x) ? AlphaTest.z : AlphaTest.w); \

#define SetCommonPSOutputVc \
	float4 color = pin.Diffuse; \

#define SetPS_MRT_OutputTx2 \
    float4 color = SAMPLE_TEXTURE(Texture, pin.TexCoord) * pin.Diffuse; \
    clip((color.a < AlphaTest.x) ? AlphaTest.z : AlphaTest.w); \
	result.RgbColor = color; \
	result.EffectColor = pin.Specular; \
	result.IndexColor = IdxColor; \
	result.NightColor = SAMPLE_TEXTURE(Texture_Night, pin.TexCoord) * pin.Diffuse; \

#define SetPS_MRT_OutputTx \
    float4 color = SAMPLE_TEXTURE(Texture, pin.TexCoord) * pin.Diffuse; \
    clip((color.a < AlphaTest.x) ? AlphaTest.z : AlphaTest.w); \
	result.RgbColor = color; \
	result.EffectColor = pin.Specular; \
	result.IndexColor = IdxColor; \
	result.NightColor = float4(color.rgb*0.25, 1);

#define SetPS_MRT_OutputVc \
	result.RgbColor = pin.Diffuse; \
	result.EffectColor = pin.Specular; \
	result.IndexColor = IdxColor; \
	result.NightColor = float4(pin.Diffuse.rgb*0.25, 1);
