//-----------------------------------------------------------------------------
// AlphaTestEffect.fx
//
// Microsoft XNA Community Game Platform
// Copyright (C) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------

#include "Macros.fxh"


DECLARE_TEXTURE(Texture, 0);


BEGIN_CONSTANTS

    float4 DiffuseColor     _vs(c0) _cb(c0);
    float4 AlphaTest        _ps(c0) _cb(c1);
    float3 FogColor         _ps(c1) _cb(c2);
    float4 FogVector        _vs(c5) _cb(c3);
	//Texture offset
	float2 TextureOffset;
	float2 TextureScale;
MATRIX_CONSTANTS

    float4x4 WorldViewProj  _vs(c1) _cb(c0);
    float4x4 World          _vs(c6) _cb(c1);

END_CONSTANTS


#include "Structures.fxh"
#include "Common.fxh"


// Vertex shader: basic.
VSOutputTx VSAlphaTest(VSInputTx vin)
{
    VSOutputTx vout;
    
    SetCommonVSOutputParams;
    AdjustTextureRegion;

    return vout;
}

// Vertex shader: no fog.
VSOutputTx VSAlphaTestNoFog(VSInputTx vin)
{
    VSOutputTx vout;
    
    SetCommonVSOutputParamsNoFog;
	AdjustTextureRegion;
    
    return vout;
}

// Vertex shader: vertex color, no fog.
VSOutput VSBasicVc(VSInputVc vin)
{
    VSOutput vout;
    
    SetCommonVSOutputParams;
    vout.Diffuse *= vin.Color;

	return vout;
}

// Vertex shader: vertex color, no fog.
VSOutput VSBasicVcNoFog(VSInputVc vin)
{
    VSOutput vout;
    
    SetCommonVSOutputParamsNoFog;    
    vout.Diffuse *= vin.Color;

	return vout;
}

// Pixel shader: less/greater compare function.
float4 PSAlphaTest(PSInputTx pin) : SV_Target0
{
    float4 color = SAMPLE_TEXTURE(Texture, pin.TexCoord) * pin.Diffuse;

    clip((color.a < AlphaTest.x) ? AlphaTest.z : AlphaTest.w);

    ApplyFog(color, pin.Specular.w);

    return color;
}

// Pixel shader: less/greater compare function, no fog.
float4 PSAlphaTestNoFog(PSInputTxNoFog pin) : SV_Target0
{
    float4 color = SAMPLE_TEXTURE(Texture, pin.TexCoord) * pin.Diffuse;
    
    clip((color.a < AlphaTest.x) ? AlphaTest.z : AlphaTest.w);

    return color;
}

// Pixel shader: basic.
float4 PSBasic(PSInput pin) : SV_Target0
{
    float4 color = pin.Diffuse;
    
    ApplyFog(color, pin.Specular.w);
    
    return color;
}

// Pixel shader: no texture, no fog.
float4 PSBasicNoFog(PSInputNoFog pin) : SV_Target0
{
    return pin.Diffuse;
}

VertexShader VSArray[4] =
{
    compile vs_2_0 VSAlphaTest(),
    compile vs_2_0 VSAlphaTestNoFog(),
    compile vs_2_0 VSBasicVc(),
    compile vs_2_0 VSBasicVcNoFog(),
};


int VSIndices[4] =
{
    0,      // lt/gt
    1,      // lt/gt, no fog
    2,      // lt/gt, vertex color
    3,      // lt/gt, vertex color, no fog
};


PixelShader PSArray[4] =
{
    compile ps_2_0 PSAlphaTest(),
    compile ps_2_0 PSAlphaTestNoFog(),
    compile ps_2_0 PSBasic(),
    compile ps_2_0 PSBasicNoFog(),
};


int PSIndices[4] =
{
    0,      // lt/gt
    1,      // lt/gt, no fog
    2,      // lt/gt, vertex color
    3,      // lt/gt, vertex color, no fog
};


int ShaderIndex = 0;


Technique CustomEffect
{
    Pass
    {
        VertexShader = (VSArray[VSIndices[ShaderIndex]]);
        PixelShader  = (PSArray[PSIndices[ShaderIndex]]);
    }
}
