﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using nft.framework.plugin;

namespace nft.framework.drawing
{
    /// <summary>
    /// This class is designed for determining name of Cached files, managed by the GraphicManager.
    /// Some functions of GraphicsManager are called with a ResourceKey.
    /// It is identical for each resource, and be available as a hash key.
    /// </summary>
    public class ResourceKey
    {
        static protected string DataDirRoot;

        static ResourceKey() {
            IGraphicManager gm = (IGraphicManager)GlobalModules.GetModule(typeof(IGraphicManager));
            DataDirRoot = Path.Combine(Directories.DataDir, "gm\\"+gm.GetType().Name);
            Directory.CreateDirectory(DataDirRoot);
        }

        public readonly String MainID;
        public readonly String SubID;

        protected ResourceKey(String mainId, String subId) {
            this.MainID = mainId;
            this.SubID = subId;
        }

        public virtual String AbsoluteID {
            get { return MainID + Path.DirectorySeparatorChar + SubID; }
        }

        public virtual String DataDirectory {
            get {
                string path = Path.Combine(DataDirRoot, MainID);
                Directory.CreateDirectory(path);
                return path;
            }
        }

        public virtual String CreateDataFileName(String ext_or_suffix) {
            String fname = SubID + ext_or_suffix;
            return Path.Combine(DataDirectory, fname);
        }

        public static ResourceKey CreateKey(Contribution c, UInt16 local_id) {
            return new ResourceKey(c.ID.AsString, local_id.ToString("X4"));
        }

        public static ResourceKey CreateKey(Contribution c, UInt32 local_id) {
            return new ResourceKey(c.ID.AsString, local_id.ToString("X8"));
        }

        public static ResourceKey CreateKey(Contribution c, String local_id) {
            return new ResourceKey(c.ID.AsString, local_id);
        }

        public static ResourceKey CreateKey(Plugin p, String local_id) {
            return new ResourceKey(p.ID.AsString, local_id);
        }

        public override bool Equals(object obj) {
            ResourceKey other = obj as ResourceKey;
            if (other!=null) {
                return SubID.Equals(other.SubID) && MainID.Equals(other.MainID);
            }
            return false;
        }

        public override int GetHashCode() {
            return MainID.GetHashCode()^SubID.GetHashCode();
        }
    }
}
