﻿using nft.contributions.ui;
using nft.framework.plugin;
using nft.ui.ui.docking;
using System;
using System.Collections.Generic;
using System.Text;
using WeifenLuo.WinFormsUI.Docking;

namespace nft.ui.docking {
    public interface IDockContentFactory {
        DockContent CreateDockContent(string subkey);
    }

    public class DockContentContributionResolver {
        public static DockContent ResolveDockContent(string persist) {
            VDockContentId contentId = VDockContentId.RestoreFromString(persist);
            Contribution ctb = PluginManager.theInstance.GetContribution(contentId.ContributionID);
            String innerName = contentId.Name;
            IDockContentFactory fct = ctb as IDockContentFactory;
            if (fct != null) {
                return fct.CreateDockContent(innerName);
            }
            CtbCommand cmd = ctb as CtbCommand;
            if (cmd != null && cmd.Commandprocedure is IDockContentFactory) {
                fct = cmd.Commandprocedure as IDockContentFactory;
                return fct.CreateDockContent(innerName);
            }
            return null;
        }
    }
}
