/*
 * JHPdf Free PDF Library : HPdfProxy.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encrypt.HPdfEncrypt;
import net.sf.jhpdf.io.HPdfWriteStream;

/**
 * Class represents PDF Proxy.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfProxy extends HPdfObject {

    private static final Logger logger = LoggerFactory.getLogger(HPdfProxy.class);
    
    private HPdfObject obj;
    
    /**
     * ctor. this is package-private.
     */
    HPdfProxy(HPdfObject obj) {
        super();
        logger.trace("HPdfProxy#ctor");
        setContent(obj);
    }
    
    public HPdfObject getContent() {
        return this.obj;
    }
    
    private void setContent(HPdfObject obj) {
        this.obj = obj;
    }

    @Override
    protected void writeValue(HPdfWriteStream stream, HPdfEncrypt e) {
        StringBuffer buf = new StringBuffer();
        HPdfObject obj = this.getContent();
        buf.append(obj.getObjId());
        buf.append(' ');
        buf.append(obj.getGenNo());
        buf.append(" R");
        stream.writeStr(buf.toString());
    }
}
