package net.sf.jhpdf.pdfobject

import org.junit.Test
import static org.junit.Assert.assertThat
import static net.sf.jhpdf.test.matcher.Matchers.closeTo


class HPdfPageTest {
    @Test
    void checkInit() {
        def p = new HPdfPage();
        assertThat p.height, closeTo(0.0F, 0.0F)
        assertThat p.width, closeTo(0.0F, 0.0F)
        assertThat p.lineWidth, closeTo(0.0F, 0.0F)
    }
    @Test
    void checkHeight() {
        def p = new HPdfPage();
        p.height = 0.5F
        assertThat p.height, closeTo(0.5F, 0.0F)
        assertThat p.width, closeTo(0.0F, 0.0F)
        assertThat p.lineWidth, closeTo(0.0F, 0.0F)
    }
    @Test
    void checkWidth() {
        def p = new HPdfPage();
        p.width = 0.5F
        assertThat p.height, closeTo(0.0F, 0.0F)
        assertThat p.width, closeTo(0.5F, 0.0F)
        assertThat p.lineWidth, closeTo(0.0F, 0.0F)
    }
    @Test
    void checkLineWidth() {
        def p = new HPdfPage();
        p.lineWidth = 0.5F
        assertThat p.height, closeTo(0.0F, 0.0F)
        assertThat p.width, closeTo(0.0F, 0.0F)
        assertThat p.lineWidth, closeTo(0.5F, 0.0F)
    }
}
