package game.net.player2;

import static game.constant.GameConstant.DOWN_CNT;
import static game.constant.GameConstant.NEXT_MAX;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;

import com.haru.component.GameField;
import com.haru.component.Mino;
import com.haru.component.NextNextField;
import com.haru.component.TetraMino;
import com.haru.component.gui.MainPanel;
import com.haru.net.NetConstant;
import com.haru.net.OutData2;
import com.haru.player.Player;
import com.haru.util.ArrayRandom;



public class GameServer implements NetConstant{

	//--------------------------------------------------------------------------//
	// \Pbg̏
	//--------------------------------------------------------------------------//

	// g̃\Pbg
	private ObjectOutputStream out;
	private BufferedReader in;


	public ServerSocket create(int port) {
		ServerSocket svsock;
		try {
			svsock = new ServerSocket(port);
		} catch (IOException e1) {
			e1.printStackTrace();
			System.out.println("|[gdH");
			return null;
		}

		return svsock;
	}

	/**
	 * NCAgƐڑAXg[̎擾
	 * @param svsock
	 * @return 擾Socket́Aclose
	 */
	public Socket listen(ServerSocket svsock) {
		Socket sock;
		try {
			sock = svsock.accept();
		} catch (IOException e) {
			e.printStackTrace();
			System.out.println("NCAgւ̐ڑs");
			return null;
		}

		try {
			in = new BufferedReader(new InputStreamReader(
					sock.getInputStream()
					));
			out = new ObjectOutputStream(sock.getOutputStream());

		} catch (IOException e) {
			e.printStackTrace();
			System.out.println("Xg[쐬s");
			return null;
		}

		return sock;
	}

	// ̃\Pbg̘Ag
	private int playerNo;
	private GameServer other;
	private OutData2 otherData;	 // ʂ̃XbhnĂ炤

	public void setOther(GameServer s) {
		this.other = s;
	}
	public void setOutData(OutData2 data) {
		this.otherData = data;
	}



	//--------------------------------------------------------------------------//
	//--------------------------------------------------------------------------//


	private MainPanel mainPanel;

	public GameServer(MainPanel mainPanel, int playerNo) {
		this.mainPanel = mainPanel;
		this.playerNo = playerNo;
	}

	public MainPanel getMainPanel() {
		return mainPanel;
	}



	//--------------------------------------------------------------------------//
	//--------------------------------------------------------------------------//
	//--------------------------------------------------------------------------//
	// Q[
	//--------------------------------------------------------------------------//
	//--------------------------------------------------------------------------//
	//--------------------------------------------------------------------------//


	private Player player;
	private GameField gameField;		// mainPanelɉBĂ邯ǁAget()`ĂȂ
	private NextNextField nextField;

	private int next[] = new int[NEXT_MAX];
	private ArrayRandom r =new ArrayRandom( new int[] {
				Mino.T_I,
				Mino.T_O,
				Mino.T_S,
				Mino.T_Z,
				Mino.T_L,
				Mino.T_J,
				Mino.T_T
			}
		);


	private void next(NextNextField nextField) {

		// Omap̏
		for (int i = 0; i < next.length; i++)
			nextField.putBlock(i, Mino.T_EMPTY, TetraMino.getBlock(next[i]));

		// lNXgVɎ擾
		for (int i = 0; i < next.length - 1; i++)
			next[i] = next[i+1];
		next[next.length - 1] = r.getNext();

		// zu
		for (int i = 0; i < next.length; i++)
			nextField.putBlock(i, next[i], TetraMino.getBlock(next[i]));
	}


	//--------------------------------------------------------------------------//

	void gameinit() {
		// tB[h̏
		gameField = new GameField();
		nextField = new NextNextField();
		getMainPanel().init(gameField, nextField);

		// vC[̒`
		player = new Player(gameField);

		// lNXg̏
		for (int i = 0; i < next.length; i++) {
			next[i] = r.getNext();
		}
		// ubN̏o
		player.setCur( TetraMino.getBlock(next[0]) );
		next(nextField);

	}

	boolean gameloop(int loop) {

		// NCAg IN + OUT + OUT

		//--------------------------------------------------------------------------//
		// IN : socket
		//--------------------------------------------------------------------------//
		try {
			int length;
			int[] ret;


			length = Integer.parseInt(in.readLine());
			ret = new int[length];

			for (int i = 0; i < length; i ++) {
				ret[i] = Integer.parseInt(in.readLine());
			}


			//--------------------------------------------------------------------------//

			// ubN̈ʒuXV
			boolean isUpdate = player.update(ret, (loop % DOWN_CNT == 0));		// int[]̎󂯓nł͂ȂĂ
			// ʒum肵ꍇ
			if (!isUpdate) {

				// ̃ubN
				player.setCur( TetraMino.getBlock( next[0] ) );
				next(nextField);
				loop = 0;
			}


		} catch (NumberFormatException e1) {
			e1.printStackTrace();
			System.out.println("readsiłȂj");
			return false;
		} catch (IOException e1) {
			e1.printStackTrace();
			System.out.println("readsiXg[ȂȂHj");
			return false;
		}


		// DRAW : IN̊mF
		getMainPanel().repaint();



		//--------------------------------------------------------------------------//
		// OUT : socket֏o
		//--------------------------------------------------------------------------//
		try {

			OutData2 data = new OutData2(playerNo, gameField, nextField);
			out.writeObject(data);
			out.flush();
//			System.out.println(playerNo + ":OutData (" + data.getNo() + ")");
		} catch (IOException e) {
			e.printStackTrace();
			System.out.println("writes(Xg[ȂH)");
			return false;
		}

		//other֏o͗\
		if (other != null) {
			OutData2 data = new OutData2(playerNo, gameField, nextField);
			other.setOutData(data);
		}

		//--------------------------------------------------------------------------//
		// OUT2: ΐ푊̏socket֑
		//--------------------------------------------------------------------------//
		if (otherData == null) { // ŏɂsXbh(Е̃Xbĥ)

			// _~[̏NCAgɑ
			try {
				out.writeObject(new OutData2(0, new GameField(), new NextNextField()));
				out.flush();
//				System.out.println(playerNo + ":_~[𑗂");
			} catch (IOException e) {
				e.printStackTrace();

				return false;

			}


		} else if (otherData.isReady()) {
			try {
				out.writeObject(otherData);
				out.flush();
//				System.out.println(playerNo + ":OutData (" + otherData.getNo() + ")");
			} catch (IOException e) {
				e.printStackTrace();

				return false;
			}

			otherData.init();
		}

		return true;
	}

	// ̃Q[̂߂̏
	void gameend() {

		try {
			out.writeInt(M_GAME_END);
			out.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}



	boolean ready() {
		try {
			out.write(M_READY);
			out.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}



		//in.readInt();
		try {
			int m = in.read();

			if (m == M_START) {
				return true;
			}


		} catch (IOException e) {
			e.printStackTrace();
		}

		return false;
	}


}
