// PS/2 Keyboard test program for PIC32MX150F128B / PIC32MX250F128B by K.Tanaka
// ps2demo.c

// pVXe
// ps2keyboard.c : PS/2L[{[hVXe
// colortext32.c : J[rfIMo̓VXei30~27eLXgŁj
// testlib.c     : eLXg\Cu

#include <plib.h>
#include "colortext32.h"
#include "ps2keyboard.h"

//OtNX^ with PLL (16{)
#pragma config PMDL1WAY = OFF, IOL1WAY = OFF
#pragma config FPLLIDIV = DIV_1, FPLLMUL = MUL_16, FPLLODIV = DIV_1
#pragma config FNOSC = PRIPLL, FSOSCEN = OFF, POSCMOD = XT, OSCIOFNC = OFF
#pragma config FPBDIV = DIV_1, FWDTEN = OFF, JTAGEN = OFF, ICESEL = ICS_PGx1

#define BLINKTIME 15 //J[\_Ŏԁi60nbƂɓ_Łj
#define CURSORCHAR 0x87 //J[\LN^[
#define CURSORCOLOR 7 //J[\F

int cx,cy; //J[\W
unsigned char blinkchar,blinkcolor; //J[\ʒueLXgۑp
int blinktimer; //J[\_ŃJE^[

void printhex(unsigned char n){
// 16i2\
	int a;
	a=(n>>4)+'0';
	if(a>'9') a+='A'-'0'-10;
	printchar(a);
	a=(n&15)+'0';
	if(a>'9') a+='A'-'0'-10;
	printchar(a);
}
void getcursorchar(){
// J[\W̕ƐF擾
	blinkchar=TVRAM[cy*WIDTH_X+cx];
	blinkcolor=TVRAM[cy*WIDTH_X+cx+ATTROFFSET];
}
void setcursorchar(){
// J[\_ŃJE^[`FbNAJ[\ƌ̕\؂ւ
	blinktimer++;
	if(blinktimer>=BLINKTIME*2) blinktimer=0;
	if(blinktimer<BLINKTIME){
		TVRAM[cy*WIDTH_X+cx]=CURSORCHAR;
		TVRAM[cy*WIDTH_X+cx+ATTROFFSET]=CURSORCOLOR;
	}
	else{
		TVRAM[cy*WIDTH_X+cx]=blinkchar;
		TVRAM[cy*WIDTH_X+cx+ATTROFFSET]=blinkcolor;
	}
}
void resetcursorchar(){
	TVRAM[cy*WIDTH_X+cx]=blinkchar;
	TVRAM[cy*WIDTH_X+cx+ATTROFFSET]=blinkcolor;
}
unsigned short keystatus=0,keystatus2=0,oldkey=0; //ŐṼ{^ԂƑÕ{^
void keycheck(void){
//{^ԓǂݎ
//keystatus :݉Ă{^ɑΉrbg1ɂ
//keystatus2:O񉟂ĂȂāA񉟂ꂽ{^ɑΉrbg1ɂ
	oldkey=keystatus;
	keystatus=~KEYPORT & (KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT | KEYSTART | KEYFIRE);
	keystatus2=keystatus & ~oldkey; //{^𗣂`FbN
}
int main(void){
	unsigned char k,sh;
	int keymode;

	/* |[g̏ݒ */
	TRISA = 0x0000; // PORTASďo
	TRISB = KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// {^ڑ|[g͐ݒ
	ANSELB = 0x0000; // SăfW^
	CNPUBSET=KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// vAbvݒ
	ODCB = 0x0300;	//RB8,RB9̓I[vhC

	init_composite(); // rfINAA荞ݏAJ[rfIo͊Jn

	keymode=1;//PS/2L[{[hL[h
	LATASET=2;//RA1IiPS/2[hj
	// PS/2VXe
	if(ps2init()==0){
		printstr("PS/2 Keyboard Test\n");
	}
	else{
		printstr("PS/2 Keyboard Not Found\n");
	}
	cx=0;
	cy=1;
	blinktimer=0;
	getcursorchar();

	while(1){
		//f\ԏI҂
		while(drawcount==0) asm("wait");
		drawcount=0;

		keycheck(); //{^ǂݏo
		k=ps2readkey(); //L[R[hobt@1L[ǂݍ
extern unsigned char volatile ps2status;//MAM̃tF[Y
extern unsigned char receivecount;//MrbgJE^
		if(((keystatus2 & KEYFIRE)||((vkey&0xff)==VK_ESCAPE)) && ps2status==0 && receivecount==0){
			//FIRE{^܂ESCL[AL[{[hƃ{^̃[hύX
			if(keymode){
				// PS/2{^Ƀ[hύX
				keymode=0;
				LATACLR=2;//RA1Iti{^[hj
				CNENBCLR=0x200; //PS2CLKBIT; //CLK̊荞ݒ~
				T5CONCLR=0x8000; //Timer5 Stop
				setcursor(0,WIDTH_Y-2,4);
				printstr("BUTTON Mode ");
			}
			else{
				// {^PS/2Ƀ[hύX
				keymode=1;
				LATASET=2;//RA1IiPS/2[hj
				ps2init();
				setcursor(0,WIDTH_Y-2,5);
				printstr("PS/2 KB Mode ");
			}
		}
//		if(keymode==0){
			setcursor(13,WIDTH_Y-2,1);
			if(keystatus & KEYLEFT) setcursorcolor(4);
			printstr("LEFT ");
			if(keystatus & KEYRIGHT) setcursorcolor(4);
			else setcursorcolor(1);
			printstr("RIGHT");
//		}
		setcursorchar();
		if(vkey!=0){
			// L[R[hobt@ɉꍇ
			// L[R[hʍŉsɕ\
			setcursor(0,WIDTH_Y-1,7);
			printchar('[');
			printhex((unsigned char)vkey);
			printchar(']');
		}
		if(k){
			// pLꍇ
			setcursor(cx,cy,7);
			printchar(k);
			cx++;
			if(cx>=WIDTH_X){
				cx=0;
				cy++;
				if(cy>=WIDTH_Y-1) cy=0;
			}
			getcursorchar();
		}
		else if(vkey!=0){
			k=(unsigned char)vkey; //8rbgoiʂ̓Vtg֘AL[ԁj
			switch(k){
			// e@\L[̏L[R[hƂɂɋLq
				case VK_LEFT:
					resetcursorchar();
					cx--;
					if(cx<0) cx=WIDTH_X-1;
					getcursorchar();
					break;
				case VK_RIGHT:
					resetcursorchar();
					cx++;
					if(cx>=WIDTH_X) cx=0;
					getcursorchar();
					break;
				case VK_UP:
					resetcursorchar();
					cy--;
					if(cy<0) cy=WIDTH_Y-2;
					getcursorchar();
					break;
				case VK_DOWN:
					resetcursorchar();
					cy++;
					if(cy>=WIDTH_Y-1) cy=0;
					getcursorchar();
					break;
				case VK_RETURN:
				case VK_SEPARATOR: //eL[Enter
					resetcursorchar();
					cx=0;
					cy++;
					if(cy>=WIDTH_Y-1) cy=0;
					getcursorchar();
					break;
			}
		}
		setcursor(4,WIDTH_Y-1,4);

		//Vtg֘AL[̏Ԃʍŉsɕ\
		sh=shiftkeys();
		if(sh & CHK_CAPSLK) setcursorcolor(4);
		else setcursorcolor(1);
		printstr("CAP ");
		if(sh & CHK_NUMLK) setcursorcolor(4);
		else setcursorcolor(1);
		printstr("NUM ");
		if(sh & CHK_SCRLK) setcursorcolor(4);
		else setcursorcolor(1);
		printstr("SCR ");
		if(sh & CHK_WIN) setcursorcolor(4);
		else setcursorcolor(1);
		printstr("WIN ");
		if(sh & CHK_ALT) setcursorcolor(4);
		else setcursorcolor(1);
		printstr("ALT ");
		if(sh & CHK_CTRL) setcursorcolor(4);
		else setcursorcolor(1);
		printstr("CTR ");
		if(sh & CHK_SHIFT) setcursorcolor(4);
		else setcursorcolor(1);
		printstr("S");
	}

}
