package org.pulpdust.unnetbrowser;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnKeyListener;
import android.view.View.OnLongClickListener;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.MimeTypeMap;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
//import android.util.DisplayMetrics;
//import android.view.ContextMenu;
//import android.view.ContextMenu.ContextMenuInfo;
//import android.view.SubMenu;
//import android.view.WindowManager.LayoutParams;
//import android.view.MotionEvent;
//import android.view.View.OnTouchListener;
//import android.widget.AdapterView.AdapterContextMenuInfo;

public class UnnetBrowserActivity extends FragmentActivity {
	final static String TAG = "UnnetBrowserActivity";
	public static final String PREFS = "prefs";
	static WebView webview;
	TextView textview1;
	static Button button1;
	Button button2;
	Button button3;
	static Button button4;
	EditText edittext1;
	Button button5;
	Uri dir;
	static String dir_s = "";
	String dir_prev;
	static String htmls[];
	String sort = "asc";
	String fsbj = "";
	String exts = "^.+\\.x?html?$";
	AlertDialog alrt;
	EditText findtext;
	Button gofind;
	static int newidx = 0;
	int newidx_prev;
	static int pnom = 0;
	static int index_of = -1;
	int volkey = 0;
	int matchs = -1;
	int match = 0;
	int iscale;
	float fscale = -1;
	static boolean after_back_key = false;
	boolean will_load = true;
	static boolean hide_title = false;
	boolean hide_title_default;
	boolean hide_title_p;
	boolean del_cache = true;
	boolean mode_find = false;
	boolean hide_buttons = false;
	boolean full_screen = false;
	static final int MENU_0 = 9;
	static final int MENU_TOP = 1;
	static final int MENU_BTM = 2;
	static final int MENU_SRT = 3;
	static final int MENU_PRF = 4;
	static final int MENU_CLS = 5;
//	private static final int CTXT_CPY = 6;
	static final int MENU_CPY = 7;
	static final int MENU_FND = 8;
	static final int MENU_BTN = 10;
	static final int MENU_FSC = 11;
	static final int MENU_NXT = 12;
	static final int MENU_PRV = 13;
	static final int MENU_IDX = 14;
	static final int MENU_FWD = 15;
	static final int MENU_BCK = 16;
	Menu omenu;
//	DisplayMetrics dmtrcs;
	Pattern accept = Pattern.compile(exts, 
			Pattern.CASE_INSENSITIVE|Pattern.UNICODE_CASE);

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d(TAG, "onCreate");
//        dmtrcs = new DisplayMetrics();
//        getWindowManager().getDefaultDisplay().getMetrics(dmtrcs);
        SharedPreferences settings = getSharedPreferences(PREFS, 0);
        pnom = settings.getInt("last_pnom", 0);
        dir_s = settings.getString("last_dir", "");
        sort = settings.getString("last_sort", sort);
//        hide_title = settings.getBoolean("hide_title", false);
        fsbj = settings.getString("last_fsbj", fsbj);
        mode_find = settings.getBoolean("last_mfind", false);
        iscale = settings.getInt("last_iscale", 100);
        hide_buttons = settings.getBoolean("last_buttons", false);
        hide_title_p = hide_title;
        full_screen = settings.getBoolean("last_screen", false);
        requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
        	setTitlebar();
        setContentView(R.layout.main);
        setWebView(this);
//        registerForContextMenu(webview);
        button1 = (Button)findViewById(R.id.button1);
        button2 = (Button)findViewById(R.id.button2);
        button2.setOnClickListener(new OnClickListener(){
			public void onClick(View v) {
				webview.pageUp(false);
			}
        });
        button3 = (Button)findViewById(R.id.button3);
        button3.setOnClickListener(new OnClickListener(){
        	public void onClick(View v){
        		webview.pageDown(false);
        	}
        });
        button4 = (Button)findViewById(R.id.button4);
        if (savedInstanceState != null){
        	webview.restoreState(savedInstanceState);
        }
        if (Build.VERSION.SDK_INT >= 11){
        	button2.setOnLongClickListener(new OnLongClickListener(){
        		public boolean onLongClick(View v){
        			if (hide_title){
        				return false;
        			} else {
        				toHideActionBar();
        				hide_title = true;
        		    	if (omenu != null) variMenu(omenu);
        		    	toUpdateOptionsMenu();
        				return true;
        			}
        		}
        	});
        	button3.setOnLongClickListener(new OnLongClickListener(){
        		public boolean onLongClick(View v){
        			if (hide_title){
        				toShowActionBar();
        				hide_title = false;
        		    	if (omenu != null) variMenu(omenu);
        		    	toUpdateOptionsMenu();
        				return true;
        			} else {
        				return false;
        			}
        		}
        	});
        }

        setFinder();
        varView(0);
//        webview.setInitialScale(iscale);

        if (Intent.ACTION_VIEW.equals(getIntent().getAction())){
        	String url = getIntent().getDataString();
        	File cur = new File(url);
        	Matcher typem = accept.matcher(url);
        	if (typem.matches()){
        		String cdir = cur.getParent();
        		String cfil = cur.getName();
        		if (cdir == null){
        			cdir = "/";
        		}
        		if (cdir.startsWith("file:")){
        			cdir = cdir.substring(5);
        		}
        		if (dir_s != null && !cdir.equals(dir_s)){
        			dir_prev = dir_s;
        		}
        		dir_s = cdir;
        		if (exDir()){
        			pnom = curIndex(cfil);
        			loadFiles(true, getApplication(), getSupportFragmentManager());
        		} else {
        			doDefault();
        		}
        	} else {
        		throwIntent(url);
        	}
        } else if (dir_s != ""){
        	if (exDir()){
        		loadFiles(true, getApplication(), getSupportFragmentManager());
        	} else {
        		doDefault();
        	}
        } else {
        	doDefault();
        }
    }
    public void doDefault(){
    	String where = getLocale();
    	webview.loadUrl("file:///android_asset/index_"+where+".html");
    }
    @Override
    public void onStart(){
    	super.onStart();
    	
    }
    public String getLocale(){
    	Locale lc = Locale.getDefault();
    	String ls;
    	if (lc.equals(Locale.JAPAN)){
    		ls = "ja";
    	} else {
    		ls = "c";
    	}
    	return ls;
    }
    public void toHideActionBar(){
    	forHoneycomb.hideActionBar(this);
    }
    public void toShowActionBar(){
    	forHoneycomb.showActionBar(this);
//    	if (omenu != null) forHoneycomb.prepareOptionsMenu(omenu, 0);
    }
    public void toUpdateOptionsMenu(){
    	if (Build.VERSION.SDK_INT >= 11) forHoneycomb.updateOptionsMenu(this);
    }
    public void setFinder(){
    	textview1 = (TextView) findViewById(R.id.textView1);
  		textview1.setVisibility(View.GONE);
    	edittext1 = (EditText) findViewById(R.id.editText1);
//    	edittext1.setSaveEnabled(true);
    	edittext1.setText(fsbj);
    	edittext1.addTextChangedListener(new TextWatcher(){
			public void afterTextChanged(Editable arg0) {
	    		webview.clearMatches();
	    		matchs = -1;
	    		match = 0;
			}
			public void beforeTextChanged(CharSequence arg0, int arg1,
					int arg2, int arg3) {
			}
			public void onTextChanged(CharSequence arg0, int arg1, int arg2,
					int arg3) {
			}
    	});
    	edittext1.setOnKeyListener(new OnKeyListener(){
    		public boolean onKey(View v, int kcd, KeyEvent kev){
//    			if (kev.getAction() == KeyEvent.ACTION_DOWN){
//    				return true;
//    			}
    			if (kev.getAction() == KeyEvent.ACTION_UP &&
    					 kcd == KeyEvent.KEYCODE_ENTER){
    				textFind(edittext1.getText().toString());
    				return true;
    			}
    			return false;
    		}
    	});
    	button5 = (Button) findViewById(R.id.button5);
    	button5.setOnClickListener(new OnClickListener(){
    		public void onClick(View v){
    			textFind(edittext1.getText().toString());
    		}
    	});
    }
    @Override
    public void onConfigurationChanged(Configuration nc){
    	super.onConfigurationChanged(nc);
//    	webview.setInitialScale(iscale);
    }
    public void setWebView(final Context c){
        webview = (WebView)findViewById(R.id.webview1);
        webview.setScrollBarStyle(WebView.SCROLLBARS_INSIDE_OVERLAY);
//        int dscale = dmtrcs.widthPixels / 10;
//        if (iscale == -1) iscale = 100;
        webview.setInitialScale(iscale);
        webview.setOnKeyListener(new OnKeyListener(){
        	public boolean onKey(View v, int kcd, KeyEvent kev){
            	if (kev.getAction() == KeyEvent.ACTION_DOWN){
        		switch (kev.getKeyCode()){
        		case KeyEvent.KEYCODE_SPACE:
        			if (kev.isShiftPressed()){
        				webview.pageUp(false);
        			} else {
        				webview.pageDown(false);
        			}
        			return true;
        		case KeyEvent.KEYCODE_F:
        			if (!kev.isAltPressed()){
            			if (webview.canGoForward()){
            				after_back_key = true;
            				webview.goForward();
            				return true;
            			} else {
            				return true;
            			}    				
        			} else {
        				return false;
        			}
        		case KeyEvent.KEYCODE_B:
            		if (webview.canGoBack() == true){
            			after_back_key = true;
            			webview.goBack();
            			return true;
            		} else {
            			return true;
            		}
        		case KeyEvent.KEYCODE_I:
        			if (!kev.isAltPressed() && htmls != null){
            			if (index_of > -1){
            				pnom = index_of;
            				loadFiles(true, c, getSupportFragmentManager());
            				return true;
            			} else {
            				echoIndex(c, getSupportFragmentManager());
            				return true;
            			}
        			} else {
        				return false;
        			}
        		case KeyEvent.KEYCODE_N:
        			if (!kev.isAltPressed()){
        				goNext(getApplication());
        				return true;
        			} else {
        				return false;
        			}
        		case KeyEvent.KEYCODE_P:
        			if (!kev.isAltPressed()){
        				goPrev(getApplication());
        				return true;
        			} else {
        				return false;
        			}
        			

        		default:
        			return false;
        		}
            	} else {
            		return false;
            	}
        	}
        });
//        webview.setOnLongClickListener(new OnLongClickListener(){
//			public boolean onLongClick(View v){
//				openContextMenu(v);
//				return true;
//			}
//        });
//        webview.setOnTouchListener(new OnTouchListener(){
//			public boolean onTouch(View v, MotionEvent mv) {
//				Log.d(TAG, "onTouch");
//				if (mv.getAction() == MotionEvent.ACTION_DOWN){
//					if (mv.getDownTime() == 2000){
//						openContextMenu(v);
//						return true;
//					}
//				}
//				return false;
//			}
//        });
        webview.setWebViewClient(new WebViewClient(){
        	@Override
        	public void onScaleChanged(WebView v, float oldsc, float newsc){
        		iscale = Math.round(newsc * 100);
        		webview.setInitialScale(iscale);
//                SharedPreferences settings = getSharedPreferences(PREFS, 0);
//                SharedPreferences.Editor editor = settings.edit();
//                editor.putInt("last_iscale", iscale);
//                editor.commit();
        	}
        	@Override
        	public boolean shouldOverrideUrlLoading(WebView view, String url){
//        		url = url.replaceAll("^(.+\\.x?html?)(\\?.*)$", "$1");
//        		fscale = webview.getScale();
        		
        		Pattern pttrn = Pattern.compile("^(.+\\.x?html?)(\\?.*)$", 
        				Pattern.CASE_INSENSITIVE|Pattern.UNICODE_CASE);
        		Matcher mtchr = pttrn.matcher(url);
        		if (mtchr.matches()){
        			url = mtchr.group(1);
        		}
        		File cur = new File(url);
        		String cdir = cur.getParent();
        		String cfil = cur.getName();
        		Matcher typem = accept.matcher(url);
    			if (cdir.startsWith("file:") && typem.matches()){
    				cdir = cdir.substring(5);
            		if (dir_s != null && dir_s.equals(cdir)){
            			if (cfil == null){
            				pnom = 0;
            			} else {
            				pnom = curIndex(cfil);
            			}
        			    return super.shouldOverrideUrlLoading(view, url);
            		} else {
            			dir_prev = dir_s;
        				dir_s = cdir;
        				
        				if (exDir() == false){
        					dir_s = dir_prev;
        					return true;
        				} else {
        				if (cfil == null){
        					pnom = 0;
        				} else {
        					pnom = curIndex(cfil);
        				}
        				loadFiles(true, c, getSupportFragmentManager());
                		return true;
        				}
            		}
    			} else {
    				throwIntent(url);
    				return true;
    			}
        		
        	}
        	@Override
        	public void onPageStarted(WebView v, String url, Bitmap fvcn){
        		super.onPageStarted(v, url, fvcn);
        		setProgressBarIndeterminateVisibility(true);
//                webview.setInitialScale(iscale);
        	}
        	@Override
        	public void onPageFinished(WebView view, String url){
        		super.onPageFinished(view, url);
        		setProgressBarIndeterminateVisibility(false);
        		File cur = new File(url);
        		String cdir = cur.getParent();
        		String cfil = cur.getName();
    			if (cdir.startsWith("file:")){
    				cdir = cdir.substring(5);
    			}
    			if (after_back_key == true){
    				boolean asis;
            		if (dir_s != null && dir_s.equals(cdir)){
            			asis = true;
            		} else {
            			dir_prev = dir_s;
        				dir_s = cdir;
        				asis = exDir();
//        				loadFiles(true);
               		}
            		if (asis){
            		if (cfil == null){
            			pnom = 0;
            		} else {
            			pnom = curIndex(cfil);
            		}
            		}
    				after_back_key = false;
    			}
        		  changeTitle();
  	    		webview.clearMatches();
  	    		matchs = -1;
  	    		match = 0;
        	}
        });
    }
    public int curIndex(String file){
    	try {
			file = URLDecoder.decode(file, "UTF-8");
			for (int index = 0; index < htmls.length; index++){
				if (file.equals(htmls[index])){
					return index;
				}
			}
				return -1;
		} catch (UnsupportedEncodingException e) {
			Log.e(TAG, e.getMessage());
			return -1;
		}
    }
    @Override
    public void onStop(){
    	super.onStop();
    	Log.d(TAG, "onStop");
        SharedPreferences settings = getSharedPreferences(PREFS, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString("last_dir", dir_s);
        editor.putInt("last_pnom", pnom);
        editor.putString("last_sort", sort);
//        editor.putBoolean("hide_title", hide_title);
        editor.putString("last_fsbj", edittext1.getText().toString());
        editor.putBoolean("last_mfind", mode_find);
        editor.putInt("last_iscale", iscale);
        editor.putBoolean("last_buttons", hide_buttons);
        editor.putBoolean("last_screen", full_screen);
        editor.commit();
        webview.clearCache(false);
    }
    @Override
    public void onDestroy(){
    	super.onDestroy();
    	Log.d(TAG, "onDestroy");
    	if (del_cache){
    		webview.clearFormData();
    		webview.clearHistory();
    		CookieManager.getInstance().removeAllCookie();
    		webview.clearCache(true);
    	}
    }
    @Override
    protected void onSaveInstanceState(Bundle outState) {
    	webview.saveState(outState);
    }
//    @Override
//    public void onCreateContextMenu(ContextMenu menu, View v,
//    		ContextMenuInfo menuinfo){
//    	Log.d(TAG, "onCreateContextMenu");
//    	super.onCreateContextMenu(menu, v, menuinfo);
//    	menu.add(0, CTXT_CPY, 0, R.string.select);
//    }
//    @Override
//    public boolean onContextItemSelected(MenuItem item){
////    	AdapterContextMenuInfo info = (AdapterContextMenuInfo) item.getMenuInfo();
//    	switch (item.getItemId()){
//    	case CTXT_CPY:
//    		shiftDown();
//    		return true;
//    	default:
//    		return super.onContextItemSelected(item);
//    	}
//    }
    public boolean variMenu(Menu menu){
		MenuItem prpr0 = (MenuItem) menu.findItem(MENU_PRV);
		MenuItem prpr1 = (MenuItem) menu.findItem(MENU_NXT);
		MenuItem prpr2 = (MenuItem) menu.findItem(MENU_IDX);
		MenuItem prpr3 = (MenuItem) menu.findItem(MENU_FWD);
    	if (hide_buttons && volkey == 5){
    		prpr0.setVisible(true);
    		prpr1.setVisible(true);
    		prpr2.setVisible(false);
    		prpr3.setVisible(false);
    		if (Build.VERSION.SDK_INT >= 11 && !hide_title) forHoneycomb.prepareOptionsMenu(menu, 1);
    		else if (Build.VERSION.SDK_INT >= 11 && hide_title) forHoneycomb.prepareOptionsMenu(menu, 2);
    	} else if (hide_buttons && volkey == 2){
    		prpr0.setVisible(false);
    		prpr1.setVisible(false);
    		prpr2.setVisible(true);
    		prpr3.setVisible(true);
    		if (Build.VERSION.SDK_INT >= 11 && !hide_title) forHoneycomb.prepareOptionsMenu(menu, 0);
    		else if (Build.VERSION.SDK_INT >= 11 && hide_title) forHoneycomb.prepareOptionsMenu(menu, 2);
    	} else if (hide_buttons){
    		prpr0.setVisible(true);
    		prpr1.setVisible(true);
    		prpr2.setVisible(true);
    		prpr3.setVisible(true);
    		if (Build.VERSION.SDK_INT >= 11 && !hide_title) forHoneycomb.prepareOptionsMenu(menu, 1);
    		else if (Build.VERSION.SDK_INT >= 11 && hide_title) forHoneycomb.prepareOptionsMenu(menu, 2);
    	} else {
    		prpr0.setVisible(false);
    		prpr1.setVisible(false);
    		prpr2.setVisible(false);
    		prpr3.setVisible(false);
    		if (Build.VERSION.SDK_INT >= 11 && !hide_title) forHoneycomb.prepareOptionsMenu(menu, 0);
    		else if (Build.VERSION.SDK_INT >= 11 && hide_title) forHoneycomb.prepareOptionsMenu(menu, 2);
    	}
    	return true;
    }
    @Override
    public boolean onPrepareOptionsMenu(Menu menu){
    	super.onPrepareOptionsMenu(menu);
//    	if (Build.VERSION.SDK_INT >= 11){
//    		forHoneycomb.prepareOptionsMenu(menu, 0);
//    	}
    	return variMenu(menu);
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu){
    	super.onCreateOptionsMenu(menu);
    	MenuItem mnitm0 = menu.add(0, MENU_0, 0, R.string.open);
    	mnitm0.setIcon(android.R.drawable.ic_menu_set_as);
    	mnitm0.setAlphabeticShortcut('o');
    	MenuItem mnitm9 = menu.add(0, MENU_CLS, 0, R.string.close);
    	mnitm9.setIcon(android.R.drawable.ic_menu_close_clear_cancel);
    	mnitm9.setAlphabeticShortcut('w');
    	MenuItem mnitm3 = menu.add(0, MENU_SRT, 0, R.string.sort);
    	mnitm3.setIcon(android.R.drawable.ic_menu_sort_alphabetically);
    	mnitm3.setAlphabeticShortcut('s');
    	//
		MenuItem mnitm11 = menu.add(0, MENU_PRV, 0, R.string.m_prev);
		mnitm11.setIcon(android.R.drawable.ic_media_rew);
		MenuItem mnitm12 = menu.add(0, MENU_NXT, 0, R.string.m_next);
		mnitm12.setIcon(android.R.drawable.ic_media_ff);
		//
    	MenuItem mnitm1 = menu.add(0, MENU_TOP, 0, R.string.top);
    	mnitm1.setIcon(android.R.drawable.ic_media_previous);
    	mnitm1.setAlphabeticShortcut('a');
    	MenuItem mnitm2 = menu.add(0, MENU_BTM, 0, R.string.bottom);
    	mnitm2.setIcon(android.R.drawable.ic_media_next);
    	mnitm2.setAlphabeticShortcut('e');
    	//
    	MenuItem mnitm13 = menu.add(0, MENU_IDX, 0, R.string.index);
    	mnitm13.setIcon(android.R.drawable.ic_menu_directions);
    	mnitm13.setAlphabeticShortcut('i');
    	MenuItem mnitm14 = menu.add(0, MENU_FWD, 0, R.string.forward);
    	mnitm14.setIcon(android.R.drawable.ic_media_play);
//    	mnitm14.setAlphabeticShortcut('d');
    	MenuItem mnitm15 = menu.add(0, MENU_BCK, 0, R.string.back);
//    	mnitm15.setAlphabeticShortcut('k');
    	mnitm15.setVisible(false);
    	//
//    	SubMenu sbmn1 = menu.addSubMenu(R.string.etc);
//    	sbmn1.setIcon(android.R.drawable.ic_menu_more);
//    	sbmn1.clearHeader();
//    	sbmn1.setQwertyMode(true);
    	if (Build.VERSION.SDK_INT <= 10){
        	MenuItem mnitm4 = menu.add(0, MENU_CPY, 0, R.string.select);
        	mnitm4.setAlphabeticShortcut('c');
    	}
    	MenuItem mnitm5 = menu.add(0, MENU_FND, 0, R.string.find);
    	mnitm5.setAlphabeticShortcut('f');
    	if (Build.VERSION.SDK_INT <= 10 || Build.VERSION.SDK_INT >= 14){
    		MenuItem mnitm7 = menu.add(0, MENU_FSC, 0, R.string.fullscreen);
    		mnitm7.setAlphabeticShortcut('1');
    	}
    	MenuItem mnitm6 = menu.add(0, MENU_BTN, 0, R.string.buttons);
    	mnitm6.setAlphabeticShortcut('b');
    	MenuItem mnitm8 = menu.add(0, MENU_PRF, 0, R.string.prefs);
//    	mnitm8.setIcon(android.R.drawable.ic_menu_preferences);
    	mnitm8.setAlphabeticShortcut('p');
    	if (Build.VERSION.SDK_INT >= 11){
    		omenu = menu;
    	}
    	
    	return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem mnitm){
    	switch (mnitm.getItemId()){
    	case MENU_0:
    		pickDirectory();
    		return true;
    	case MENU_TOP:
    		if (dir_s != ""){
    			pnom = 0;
    			loadFiles(true, getApplication(), getSupportFragmentManager());
    		}
    		return true;
    	case MENU_BTM:
    		if (dir_s != ""){
    			pnom = newidx - 1;
    			loadFiles(true, getApplication(), getSupportFragmentManager());
    		}
    		return true;
    	case MENU_SRT:
    		if (dir_s != "" && htmls != null){
    		if (sort.equals("desc")){
    			ascHtmls();
    	    	sort = "asc";
    	    	loadFiles(true, getApplication(), getSupportFragmentManager());
    			return true;
    		} else {
    			descHtmls();
    	    	sort = "desc";
    	    	loadFiles(true, getApplication(), getSupportFragmentManager());
    			return true;
    		}
    		}
    		return true;
    	case MENU_PRF:
    		hide_title_p = hide_title;
    		Intent intnt = new Intent();
    		intnt.setClassName("org.pulpdust.unnetbrowser", "org.pulpdust.unnetbrowser.UnnetBrowserPrefs");
    		startActivityForResult(intnt, 2);
    		return true;
    	case MENU_CLS:
    		finish();
    		return true;
    	case MENU_CPY:
    		shiftDown();
    		return true;
    	case MENU_FND:
//	    	edittext1.selectAll();
    		showFinder();
			mode_find = true;
			return true;
    	case MENU_BTN:
    		if (hide_buttons){
    			hide_buttons = false;
    			showButtons();
    		} else {
    			hide_buttons = true;
    			hideButtons();
    		}
    		return true;
    	case MENU_FSC:
    		if (full_screen){
    			getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
    			full_screen = false;
    		} else {
    			getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
    			full_screen = true;
    		}
    		return true;
    	case MENU_PRV:
    		goPrev(getApplication());
    		return true;
    	case MENU_NXT:
    		goNext(getApplication());
    		return true;
    	case MENU_IDX:
    		if (htmls != null){
			if (index_of > -1){
				pnom = index_of;
				loadFiles(true, getApplication(), getSupportFragmentManager());
				return true;
			} else {
				echoIndex(getApplication(), getSupportFragmentManager());
				return true;
			}
    		} else {
    			return true;
    		}
    	case MENU_FWD:
    		if (webview.canGoForward()){
				after_back_key = true;
				webview.goForward();
				return true;
			} else {
				return true;
			}
    	case MENU_BCK:
    		if (webview.canGoBack() == true){
    			after_back_key = true;
    			webview.goBack();
    			return true;
    		} else {
    			return true;
    		}

    	}
    	return true;
    }
    @Override
    public boolean dispatchKeyEvent(KeyEvent kev){
    	if (kev.getAction() == KeyEvent.ACTION_DOWN){
    		switch (kev.getKeyCode()){
    		case KeyEvent.KEYCODE_BACK:
    			if (mode_find){
    				hideFinder();
      	    		webview.clearMatches();
      	    		matchs = -1;
      	    		match = 0;
      	    		textview1.setText("");
      	    		textview1.setVisibility(View.GONE);
    				mode_find = false;
    				return true;
    			}
    			else if (webview.canGoBack() == true){
        			webview.goBack();
        			after_back_key = true;
        			return true;
    			} else {
    				return super.dispatchKeyEvent(kev);
    			}
//    		case KeyEvent.KEYCODE_SEARCH:
////    			echoFinder(this);
////    	    	edittext1.selectAll();
//    			showFinder();
//    			mode_find = true;
//    			return true;
    		case KeyEvent.KEYCODE_VOLUME_UP:
    			if (volkey == 1){
    				webview.pageUp(false);
    				return true;
    			} else if (volkey == 2){
    				goPrev(getApplication());
    				return true;
    			} else if (volkey == 3){
    				webview.zoomIn();
    				return true;
    			} else if (volkey == 4){
        	    	edittext1.selectAll();
        			showFinder();
        			mode_find = true;
    				return true;
    			} else if (volkey == 5) {
        			if (htmls != null){
            			if (index_of > -1){
            				pnom = index_of;
            				loadFiles(true, getApplication(), getSupportFragmentManager());
            				return true;
            			} else {
            				echoIndex(getApplication(), getSupportFragmentManager());
            				return true;
            			}
        			} else {
        				return true;
        			}
    			} else {
    				return super.dispatchKeyEvent(kev);
    			}
    		case KeyEvent.KEYCODE_VOLUME_DOWN:
    			if (volkey == 1){
    				webview.pageDown(false);
    				return true;
    			} else if (volkey == 2){
    				goNext(getApplication());
    				return true;
    			} else if (volkey == 3){
    				webview.zoomOut();
    				return true;
    			} else if (volkey == 4){
    		    	if (Build.VERSION.SDK_INT <= 10){
    		    		shiftDown();
    		    	} else {
            	    	edittext1.selectAll();
            			showFinder();
            			mode_find = true;
    		    	}
    				return true;
    			} else if (volkey == 5){
        			if (webview.canGoForward()){
        				after_back_key = true;
        				webview.goForward();
        				return true;
        			} else {
        				return true;
        			}    				
    			} else {
    				return super.dispatchKeyEvent(kev);
    			}
    		default:
    			return super.dispatchKeyEvent(kev);
    		    
    		}
    		
    	}
    	else if (kev.getAction() == KeyEvent.ACTION_UP){
    		switch(kev.getKeyCode()){
    		case KeyEvent.KEYCODE_SEARCH:
    			showFinder();
    			mode_find = true;
    			return true;
    			
//    		case KeyEvent.KEYCODE_VOLUME_UP:
//    			if (volkey == 4){
//    				shiftUp();
//    				return true;
//    			} else {
//    				return super.dispatchKeyEvent(kev);
//    			}
//    		case KeyEvent.KEYCODE_VOLUME_DOWN:
//    			if (volkey == 4){
//    				shiftUp();
//    				return true;
//    			} else {
//    				return super.dispatchKeyEvent(kev);
//    			}
    		default:
    			return super.dispatchKeyEvent(kev);
    		}
    	}
		return super.dispatchKeyEvent(kev);
    }
    
    public static class IndexDialog extends DialogFragment {
    	static Context cx;
    	static FragmentManager fm;
    	public static IndexDialog newInstance(Context c, String[] items, FragmentManager f){
    		cx = c;
    		fm = f;
    		IndexDialog id = new IndexDialog();
    		Bundle args = new Bundle();
    		args.putStringArray("htmls", items);
    		id.setArguments(args);
    		return id;
    	}
    	public Dialog onCreateDialog(Bundle savedInstaceState){
    		String[] htmls = getArguments().getStringArray("htmls");
    		return new AlertDialog.Builder(getActivity())
    		.setTitle(R.string.index)
    		.setItems(htmls, new DialogInterface.OnClickListener(){
    			public void onClick(DialogInterface df, int which){
    				pnom = which;
    				loadFiles(true, cx, fm);
    			}
    		})
    		.create();
    	}
    }
    public static void echoIndex(Context c, FragmentManager fm){
    	DialogFragment dd = IndexDialog.newInstance(c, htmls, fm);
    	dd.show(fm, "hoge");
    }
//    public void echoIndex(){
//    	AlertDialog.Builder bldr = new AlertDialog.Builder(this);
//    	bldr.setTitle(R.string.index);
//    	bldr.setItems(htmls, new DialogInterface.OnClickListener() {
//			public void onClick(DialogInterface dialog, int which) {
//				pnom = which;
//				loadFiles(true);
//			}
//		});
//    	bldr.show();
//
//    }
//    public void echoFinder(Context cntxt){
//		AlertDialog.Builder adbldr = new AlertDialog.Builder(cntxt);
//		LayoutInflater ifltr = (LayoutInflater) cntxt.getSystemService(LAYOUT_INFLATER_SERVICE);
//		View layout = ifltr.inflate(R.layout.find, (ViewGroup) findViewById(R.id.layout_root));
//		findtext = (EditText) layout.findViewById(R.id.find_sbj);
//		findtext.setText(fsbj);
//		gofind = (Button) layout.findViewById(R.id.bt_go_find);
//		gofind.setOnClickListener(new OnClickListener(){
//			public void onClick(View v){
//				textFind(findtext.getText().toString());
////				alrt.dismiss();
//			}
//		});
//		adbldr.setTitle(R.string.find);
//		adbldr.setCancelable(true);
//		adbldr.setView(layout);
//		alrt = adbldr.create();
//		alrt.show();
//    }
    public void textFind(String subject){
    	fsbj = subject;
    	textview1.setVisibility(View.VISIBLE);
    	if (matchs == -1){
    		webview.clearMatches();
    	matchs = webview.findAll(subject);
//    	webview.findNext(true);
//    	match++;
    	} else {}
    	if (match == 0){
//    		webview.findNext(false);
    		match++;
    	}
    	else if (matchs > match){
//       webview.findAll(subject);
    	webview.findNext(true);
    	match++;
    	} else {}
    	if (matchs > 0){
    		textview1.setText(getString(R.string.match)+" "+String.valueOf(match)+"/"+String.valueOf(matchs));
//    		Toast tst = Toast.makeText(this,
//    			getString(R.string.match)+" "+String.valueOf(match)+"/"+String.valueOf(matchs),
//    			Toast.LENGTH_SHORT);
//    		tst.setGravity(Gravity.BOTTOM, 0, 0);
//    		tst.cancel();
//    		tst.show();
    	} else {
    		textview1.setText(getString(R.string.match)+" "+String.valueOf(matchs));
//    		Toast tst = Toast.makeText(this,
//        			getString(R.string.match)+" "+String.valueOf(matchs),
//        			Toast.LENGTH_SHORT);
//        	tst.setGravity(Gravity.BOTTOM, 0, 0);
//        	tst.cancel();
//        	tst.show();
        	match = 0;
    	}
    	if (matchs == match){
    		matchs = -1;
    		match = 0;
//        	matchs = webview.findAll(subject);
//        	webview.findNext(true);
//        	match++;
    	}
    }
    public void shiftDown(){
    	KeyEvent shifton = new KeyEvent(0, 0, KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_SHIFT_LEFT, 0, 0);
    	shifton.dispatch(webview);
    	Toast.makeText(getApplication(), R.string.shift_on, Toast.LENGTH_SHORT).show();
    }
    public void shiftUp(){
    	KeyEvent shiftoff = new KeyEvent(0, 0, KeyEvent.ACTION_UP, KeyEvent.KEYCODE_SHIFT_LEFT, 0, 0);
    	shiftoff.dispatch(webview);
    	Toast.makeText(getApplication(), R.string.shift_off, Toast.LENGTH_SHORT).show();
    }
    private void pickDirectory(){
//    	Intent intent = new Intent("org.openintents.action.PICK_DIRECTORY");
    	Intent intent = new Intent("org.openintents.action.PICK_FILE");
    	String path = "file://";
    	if (dir_s != ""){
    		path = "file://" + dir_s;
    	} else if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState())){
    		path = "file://" + Environment.getExternalStorageDirectory();
    	}
    	intent.putExtra("org.openintents.extra.TITLE",
    			getString(R.string.open) + " - " + getString(R.string.app_name));
    	intent.setData(Uri.parse(path));
    	try {
    		startActivityForResult(intent, 1);
    	} catch (ActivityNotFoundException e){
    		Toast.makeText(getApplication(), R.string.first, Toast.LENGTH_LONG).show();
    	}
    }
    public boolean exDir(){
    	Log.d(TAG, "exDir");
    	try{
    	File fold = new File(URLDecoder.decode(dir_s.trim(), "UTF-8"));
    	String files[] = fold.list();
    	if (files == null){
    		dir_s = dir_prev;
    		Toast.makeText(getApplication(), R.string.err_404, Toast.LENGTH_LONG).show();
    		return false;
    	}
//    	int fcount = files.length;
		Pattern pttrn = Pattern.compile(exts, Pattern.CASE_INSENSITIVE|Pattern.UNICODE_CASE);
		newidx_prev = newidx;
		newidx = 0;
    	for(int index = 0 ; index < files.length; index++){
    		File who = new File(fold, files[index]);
    		if (who.isDirectory()){
    			
    		} else {
    			Matcher mtchr = pttrn.matcher(files[index]);
    			if (mtchr.matches() == true){
    				newidx++;
    			}
    		}
    	}
    	if (newidx == 0){
    		dir_s = dir_prev;
//    		exDir();
    		will_load = false;
    		Toast.makeText(getApplication(), R.string.err_404, Toast.LENGTH_LONG).show();
    		return false;
    	}
    	index_of = -1;
    	htmls = new String[newidx];
    	for(int index = 0, htidx = 0 ; index < files.length; index++){
    		File who = new File(fold, files[index]);
    		if (who.isDirectory()){
    			
    		} else {
    			Matcher mtchr = pttrn.matcher(files[index]);
    			if (mtchr.matches() == true){
    				htmls[htidx] = files[index];
    				htidx++;
    			}
    			
    		}
    	}
    	ascHtmls();
    	if (sort.equals("desc")){
    		descHtmls();
    	}
    	return true;
//		String var_dump = "file://" + dir_s + "/" + htmls[0];
    	} catch(NullPointerException e) {
    		Log.e(TAG, e.getMessage());
    		return false;
    	} catch (UnsupportedEncodingException e) {
			Log.e(TAG, e.getMessage());
			return false;
		}

    }
    public void ascHtmls(){
    	Arrays.sort(htmls);
    	index_of = -1;
    	for (int index = 0; index < htmls.length; index++){
			Pattern pat_index = Pattern.compile("^((index)|(top))\\.x?html?$", Pattern.CASE_INSENSITIVE|Pattern.UNICODE_CASE);
			Matcher mat_index = pat_index.matcher(htmls[index]);
			if (mat_index.matches() == true) {
				index_of = index;
			}    		
    	}
    }
    public void descHtmls(){
    	List<String> list = Arrays.asList(htmls);
    	Collections.reverse(list);
    	index_of = -1;
    	for (int index = 0; index < htmls.length; index++){
			Pattern pat_index = Pattern.compile("^((index)|(top))\\.x?html?$", Pattern.CASE_INSENSITIVE|Pattern.UNICODE_CASE);
			Matcher mat_index = pat_index.matcher(htmls[index]);
			if (mat_index.matches() == true) {
				index_of = index;
			}    		
    	}
    }
    public static void loadFiles(boolean load, final Context c, final FragmentManager fm){
    	Log.d(TAG, "loadFiles");
    	if (htmls != null){
    	if (pnom > newidx){
    		pnom = newidx - 1;
    	}
    	if (load){
    		webview.loadUrl("file://" + dir_s + "/" + htmls[pnom]);
    	}
//		changeTitle();
    	button1.setOnClickListener(new OnClickListener(){
    		public void onClick(View v){
    			goPrev(c);
    		}
    	});
    	button1.setOnLongClickListener(new OnLongClickListener(){
    		public boolean onLongClick(View v){
    			if (index_of > -1){
    				pnom = index_of;
    				loadFiles(true, c, fm);
    				return true;
    			} else {
    				echoIndex(c, fm);
    				return true;
    			}
    		}
    	});
    	button4.setOnClickListener(new OnClickListener(){
    		public void onClick(View v){
    			goNext(c);
    		}
    	});
    	button4.setOnLongClickListener(new OnLongClickListener(){
    		public boolean onLongClick(View v){
    			if (webview.canGoForward()){
    				after_back_key = true;
    				webview.goForward();
    				return true;
    			} else {
    				return true;
    			}
    		}
    	});
    	}
    }
    public static void goPrev(Context c){
		if (pnom > 0){
			pnom = pnom - 1;
			webview.loadUrl("file://" + dir_s + "/" + htmls[pnom]);
//			changeTitle();
		}    	
    }
    public static void goNext(Context c){
		if (pnom < newidx-1){
			pnom = pnom + 1;
			webview.loadUrl("file://" + dir_s + "/" + htmls[pnom]);
//			changeTitle();    	
		}
    }
    public static void echoPos(Context c){
    	int pnom_s = pnom + 1;
    	int newidx_s = newidx;
    	Toast tst = Toast.makeText(c, pnom_s + "/" + newidx_s, Toast.LENGTH_SHORT);
    	tst.setGravity(Gravity.BOTTOM, 0, 0);
    	tst.show();
    }
    public void changeTitle(){
    	int pnom_s = pnom + 1;
    	int newidx_s = newidx;
    	String name = webview.getTitle();
    	if (name == null){
    		name = webview.getUrl();
    	}
//    	String title = pnom_s + "/" + newidx_s + " " + htmls[pnom];
    	String main = pnom_s + "/" + newidx_s;
    	String sub = name;
    	String title = main + " " + sub + " - " + getString(R.string.app_name);
    	if (Build.VERSION.SDK_INT >= 11){
    		forHoneycomb.setTitle(this, main, sub);
    	} else {
    		this.setTitle(title);
    	}
    	if (hide_title){
    		echoPos(getApplication());
    	}
    }
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data){
    	super.onActivityResult(requestCode, resultCode, data);
    	Log.d(TAG, "onActivityResult");
    	switch (requestCode){
    	case 1:
    		if (resultCode == RESULT_OK && data != null){
    			dir = data.getData();
    			dir_prev = dir_s;
    			dir_s = data.getDataString();
    			if (dir_s.startsWith("file://")){
    				dir_s = dir_s.substring(7);
    			}
        		Log.d(TAG, dir_s);
				try {
					boolean asis;
	        		File fl = new File(URLDecoder.decode(dir_s, "UTF-8"));
	        		Matcher typem = accept.matcher(dir_s);
	        		if (fl.isDirectory()){
	            		if (dir_s != ""){
	            			newidx = 0;
	            			asis = exDir();
	            		} else {
	            			asis = false;
	            		}
	            		if (asis){
	            			if (index_of > -1){
	            				pnom = index_of;
	            			} else {
	            				pnom = 0;
	            			}	            			
	            		}
	            		if (!asis && dir_prev != ""){
	            			dir_s = dir_prev;
	            			newidx = 0;
	            			asis = exDir();
	            		}
	            		if (newidx > 0){
	            			loadFiles(will_load, getApplication(), getSupportFragmentManager());
	            			will_load = true;
	            		}
	            	} else if (typem.matches()){
	                	String cdir = fl.getParent();
	                	String cfil = fl.getName();
	                	if (cdir == null){
	                		cdir = "/";
	                	}
	                	if (cdir.startsWith("file:")){
	        				cdir = cdir.substring(5);
	        			}
	                	dir_s = cdir;
	                	if (exDir()){
	                		pnom = curIndex(cfil);
	                		loadFiles(true, getApplication(), getSupportFragmentManager());
	                	} else {
	                		doDefault();
	                	}
	            	} else {
	            		dir_s = dir_prev;
	            		throwIntent(data.getDataString());
	            	}

				} catch (UnsupportedEncodingException e) {
					Log.e(TAG, e.getMessage());
				}
    		}
    		break;
    	case 2:
    		varView(1);
    		break;
    	}
    }
    public void throwIntent(String url){
		Intent intnt = new Intent("android.intent.action.VIEW");
		String ext = MimeTypeMap.getFileExtensionFromUrl(url);
		String mmtp = null;
		if (ext != null){
			mmtp = MimeTypeMap.getSingleton().getMimeTypeFromExtension(ext);
		}
		if (mmtp != null){
			intnt.setDataAndType(Uri.parse(url), mmtp);
		} else {
			intnt.setData(Uri.parse(url));
		}
		try{
			startActivity(intnt);
		} catch (ActivityNotFoundException e){
			Toast.makeText(getApplication(), R.string.err_500, Toast.LENGTH_LONG).show();
		}

    }
    public void varView(int mode){
    	SharedPreferences shrdprfs = PreferenceManager.getDefaultSharedPreferences(this);
//    	hide_buttons = shrdprfs.getBoolean("hide_buttons", false);
    	if (mode == 0){
    		if (Build.VERSION.SDK_INT >= 11 && hide_title){
    			hide_buttons = false;
    			showButtons();
    		} else if (hide_buttons){
    			hideButtons();
    		} else if(!hide_buttons) {
    			showButtons();
    		}
    		if (mode_find){
    			showFinder();
    		} else {
    			hideFinder();    		
    		}
    		if (full_screen){
    			getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
    		} else {
    			getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
    		}
    	}
        WebSettings wbsttngs = webview.getSettings();
        wbsttngs.setSaveFormData(false);
        wbsttngs.setSavePassword(false);
        wbsttngs.setLightTouchEnabled(true);
        wbsttngs.setSupportZoom(true);
        wbsttngs.setPluginsEnabled(true);
        wbsttngs.setBuiltInZoomControls(shrdprfs.getBoolean("show_zoom", true));
        wbsttngs.setDefaultFontSize(Integer.parseInt(shrdprfs.getString("font_size", "16")));
        wbsttngs.setJavaScriptEnabled(shrdprfs.getBoolean("en_script", false));
        wbsttngs.setBlockNetworkImage(shrdprfs.getBoolean("load_remote", false));
//        wbsttngs.setUseWideViewPort(shrdprfs.getBoolean("wide_view", true));
        volkey = Integer.parseInt(shrdprfs.getString("vol_func", "0"));
        del_cache = shrdprfs.getBoolean("del_cache", true);
        if (mode == 1){
            hide_title = shrdprfs.getBoolean("hide_title", false);
            if (hide_title != hide_title_default && Build.VERSION.SDK_INT >= 11){
            	if (hide_title){
            		forHoneycomb.hideActionBar(this);
            		hide_buttons = false;
            		showButtons();
    		    	toUpdateOptionsMenu();
            	}
            	else if (!hide_title) forHoneycomb.showActionBar(this);
             }
            if (hide_title != hide_title_default && shrdprfs.getBoolean("after_restart", false)){
            	Toast.makeText(getApplication(), R.string.info_restart, Toast.LENGTH_SHORT).show();
            	restartActivity();
             }
        }

    }
    public void setTitlebar(){
    	SharedPreferences shrdprfs = PreferenceManager.getDefaultSharedPreferences(this);
        hide_title = shrdprfs.getBoolean("hide_title", false);
        hide_title_default = hide_title;
        if (Build.VERSION.SDK_INT >= 11){
        	if (hide_title){
        		getWindow().requestFeature(Window.FEATURE_ACTION_BAR_OVERLAY);
        	}
    		forHoneycomb.setActionBarBackground(this, R.drawable.bg_actionbar);
        	forHoneycomb.setActionBar(this, hide_title);
        } else {
        	if (hide_title){
        		requestWindowFeature(Window.FEATURE_NO_TITLE);
        	}
        	Window wndw = getWindow();
//    		wndw.setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN); 
        	requestWindowFeature(Window.FEATURE_LEFT_ICON);
        	wndw.setFeatureDrawableResource(Window.FEATURE_LEFT_ICON, R.drawable.ic_launcher);
        }
    }
    public void restartActivity(){
    	Intent intent = getIntent();
    	intent.setClass(getApplication(), this.getClass());
    	finish();
    	this.startActivity(intent);
    }
    public void showButtons(){
		button1.setVisibility(View.VISIBLE);
		button2.setVisibility(View.VISIBLE);
		button3.setVisibility(View.VISIBLE);
		button4.setVisibility(View.VISIBLE);
		if (Build.VERSION.SDK_INT >= 11 && omenu != null){
			variMenu(omenu);
			toUpdateOptionsMenu();
		}
    }
    public void hideButtons(){
		button1.setVisibility(View.GONE);
		button2.setVisibility(View.GONE);
		button3.setVisibility(View.GONE);
		button4.setVisibility(View.GONE);
		if (Build.VERSION.SDK_INT >= 11 && omenu != null){
			variMenu(omenu);
			toUpdateOptionsMenu();
		}
    }
    public void showFinder(){
    	edittext1.setVisibility(View.VISIBLE);
//    	edittext1.setText(fsbj);
    	edittext1.requestFocus();
    	button5.setVisibility(View.VISIBLE);
    }
    public void hideFinder(){
    	edittext1.setVisibility(View.GONE);
//    	edittext1.selectAll();
    	button5.setVisibility(View.GONE);
    }
}