//
//  BEExportAccessoryViewController.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/02/28.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEExportAccessoryViewController.h"

#import "BEPreference.h"

@interface BEExportAccessoryViewController (BEPrivate)
- (void)conformSavePanel;
@end

@implementation BEExportAccessoryViewController
@synthesize type;
@synthesize panel;

- (id)init
{
	self = [super initWithNibName:@"BEExportAccessoryView" bundle:nil];
	self.type = [BEPreference preference].exportType;
	return self;
}
- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	[type release];
	[super dealloc];
}

- (void)setPanel:(NSSavePanel *)newPanel
{
	if(panel == newPanel) return;
	
	NSNotificationCenter *nc = [NSNotificationCenter defaultCenter];
	[nc removeObserver:self
				  name:NSWindowDidBecomeKeyNotification
				object:panel];
	panel = newPanel;
	[nc addObserver:self
		   selector:@selector(didBecomeKeyWindow:)
			   name:NSWindowDidBecomeKeyNotification
			 object:panel];
	
	[panel setAccessoryView:self.view];
	
	[self conformSavePanel];
}

- (void)setType:(NSNumber *)new
{
	if([new isEqual:type]) return;
	[type autorelease];
	type = [new retain];
	
	[BEPreference preference].exportType = type;
	
	[self conformSavePanel];
}

- (void)conformSavePanel
{
	NSInteger i = [type integerValue];
	if(i < 100) {
		[panel setAllowedFileTypes:[NSArray arrayWithObject:@"csv"]];
		[panel setAllowsOtherFileTypes:YES];
	} else {
		[panel setAllowedFileTypes:[NSArray arrayWithObject:@"txt"]];
		[panel setAllowsOtherFileTypes:YES];
	}
	[panel setPrompt:NSLocalizedString(@"Export", @"Export")];
	[panel setTitle:NSLocalizedString(@"Export", @"Export")];
	[panel setCanCreateDirectories:YES];
	[panel setCanSelectHiddenExtension:YES];
}
- (void)didBecomeKeyWindow:(id)notification
{
	[self conformSavePanel];
}

@end
