//
//  BEExporterAttribute.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/03/27.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEExporterAttribute.h"
#import "BEPreference.h"


@interface BEExporterAttribute()
@property ExporterType type;
@end

@implementation BEExporterAttribute
@synthesize type, isOpenAfterExport, site;

static NSArray *attributes = nil;

+ (NSArray *)attributes
{
	if(attributes) return attributes;
	
	NSMutableArray *array = [NSMutableArray array];
	
	ExporterType types[] = {
		typeBooklogExport,
		typeMediaMarkerExport,
		typeMediaMarkerImport,
		typeMonoColleExport,
		
		typeHatenaDairyType,
		
		NSUIntegerMax,
	};
	ExporterType aType;
	int i = 0;
	while((aType = types[i++]) != NSUIntegerMax) {
		//
		BEExporterAttribute *attr = [[[BEExporterAttribute alloc] init] autorelease];
		attr.type = aType;		
		if(!attr.site) {
			attr.site = [[BERegisterSite sites] objectAtIndex:0];
		}
		[array addObject:attr];
	}
	
	
	NSArray *stored = [BEPreference preference].attributes;
	if(!stored) {
		attributes = [[NSArray alloc] initWithArray:array];
		return attributes;
	}
	if([array isEqual:stored]) {
		attributes = [stored retain];
		return attributes;
	}
	NSMutableArray *newAttr = [stored mutableCopy];
	for(id obj in array) {
		if(![newAttr containsObject:obj]) {
			[newAttr addObject:obj];
		}
	}
	
	attributes = [[NSArray alloc] initWithArray:newAttr];
	return attributes;
}
	
+ (BEExporterAttribute *)attributeByType:(NSNumber *)typeValue
{
	for(BEExporterAttribute *attr in [self attributes]) {
		if(attr.type == [typeValue integerValue]) return attr;
	}
	return nil;
}
- (void)restoreAttributes
{
	NSArray *stored = [BEPreference preference].attributes;
	if(!stored) {
		attributes = [[BEExporterAttribute attributes] retain];
		return;
	}
	
	NSArray *origin = [BEExporterAttribute attributes];
	if([origin isEqual:stored]) {
		attributes = [stored retain];
		return;
	}
	
	NSMutableArray *newAttr = [stored mutableCopy];
	for(id obj in origin) {
		if(![newAttr containsObject:obj]) {
			[newAttr addObject:obj];
		}
	}
	attributes = [[NSArray alloc] initWithArray:newAttr];
	[newAttr release];
}

- (NSString *)name
{
	switch(type) {
		case typeBooklogExport:
			return NSLocalizedString(@"BooklogExport", @"BooklogExport");
		case typeMediaMarkerExport:
			return NSLocalizedString(@"MediaMarkerExport", @"MediaMarkerExport");
		case typeMediaMarkerImport:
			return NSLocalizedString(@"MediaMarkerImport", @"MediaMarkerImport");
		case typeMonoColleExport:
			return NSLocalizedString(@"MonoColleExport", @"MonoColleExport");
		case typeHatenaDairyType:
			return NSLocalizedString(@"HetenaDairy", @"HetenaDairy");
	}
	return @"";
}

#pragma mark Compare
- (NSUInteger)hash
{
	return type;
}
- (BOOL)isEqual:(BEExporterAttribute *)object
{
	if(![object isKindOfClass:[self class]]) return NO;
	return type == object->type;
}

#pragma mark NSCoding Protocol
- (id)initWithCoder:(NSCoder *)aDecoder
{
	self = [super init];
	self.type = [aDecoder decodeInt64ForKey:@"BEExporterType"];
	self.isOpenAfterExport = [aDecoder decodeBoolForKey:@"BEExpoterIsOpenAfterExport"];
	self.site = [aDecoder decodeObjectForKey:@"BEExporterSite"];
	return self;
}
- (void)encodeWithCoder:(NSCoder *)aCoder
{
	[aCoder encodeInt64:type forKey:@"BEExporterType"];
	[aCoder encodeBool:isOpenAfterExport forKey:@"BEExpoterIsOpenAfterExport"];
	[aCoder encodeObject:site forKey:@"BEExporterSite"];
}


- (id)description
{
	return [NSString stringWithFormat:
			@"Type->%d, open->%@, Site->%@",
			type, isOpenAfterExport ? @"YES":@"NO", site];
}
@end
