//
//  BERegisterSite.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/03/25.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BERegisterSite.h"


static NSString *RegisterSitePlist = @"RegisterSites";

@implementation BERegisterSite
@synthesize name, home, registerPage, needID, account;

static NSArray *sSites = nil;

+ (NSArray *)sites
{
	if(sSites) return sSites;
	
	NSBundle *mainBundle = [NSBundle mainBundle];
	NSString *path = [mainBundle pathForResource:RegisterSitePlist
										  ofType:@"plist"];
	if(!path) {
		[NSException raise:@"BENotFoundRegisterSitesPlist"
					format:@"RegisterSites.plist not found."];
	}
	NSURL *url = [NSURL fileURLWithPath:path];
	NSArray *sites = [NSArray arrayWithContentsOfURL:url];
	if(!sites) {
		[NSException raise:@"BECantLoadRigisterSitesPlist"
					format:@"RegisterSites.plist could not load."];
	}
	
	NSMutableArray *result = [NSMutableArray array];
	NSUserDefaults *ud = [NSUserDefaults standardUserDefaults];
	for(NSDictionary *site in sites) {
		BERegisterSite *obj = [[[self alloc] init] autorelease];
		obj.name = [site objectForKey:@"name"];
		obj.home = [site objectForKey:@"home"];
		obj.registerPage = [site objectForKey:@"register"];
		obj.needID = [site objectForKey:@"needID"];
		obj.account = [ud objectForKey:[NSString stringWithFormat:@"%@.%@",
										NSStringFromClass([self class]),
										obj.name]];
		[result addObject:obj];
	}
	sSites = [[NSArray alloc] initWithArray:result];
	
	return sSites;
}

- (void)dealloc
{
	[name release];
	[home release];
	[registerPage release];
	[account release];
	[super dealloc];
}

- (void)setAccount:(NSString *)newAccount
{
	if([account isEqualToString:newAccount]) return;
	id temp = account;
	account = [newAccount retain];
	[temp release];
	
	if(needID) {
		NSUserDefaults *ud = [NSUserDefaults standardUserDefaults];
		// if(account) {
		[ud setObject:account
			   forKey:[NSString stringWithFormat:@"%@.%@",
					   NSStringFromClass([self class]),
					   name]];
		//} else {
		//	[ud removeObjectForKey:[NSString stringWithFormat:@"%@.%@",
		//		NSStringFromClass([self class]),
		//		name]];
		//}
	}
}

- (NSURL *)homeURL
{
	return [NSURL URLWithString:home];
}
- (NSURL *)registerPageURL
{
	NSString *urlString = registerPage;
	if([needID boolValue]) {
		if(!account || [account length] == 0) return nil;
		
		urlString = [registerPage stringByReplacingOccurrencesOfString:@"{USER}"
															withString:account];
	}
	return [NSURL URLWithString:urlString];
}

#pragma mark Compare
- (NSUInteger)hash
{
	return [name hash];
}
- (BOOL)isEqual:(BERegisterSite *)object
{
	if(![object isKindOfClass:[self class]]) return NO;
	return [name isEqualToString:object.name];
}

#pragma mark NSCoding Protocol
- (id)initWithCoder:(NSCoder *)aDecoder
{
	self = [super init];
	self.name = [aDecoder decodeObjectForKey:@"name"];
	self.home = [aDecoder decodeObjectForKey:@"home"];
	self.registerPage = [aDecoder decodeObjectForKey:@"registerPage"];
	self.needID = [aDecoder decodeObjectForKey:@"needID"];
	self.account = [aDecoder decodeObjectForKey:@"account"];
	return self;
}
- (void)encodeWithCoder:(NSCoder *)aCoder
{
	[aCoder encodeObject:name forKey:@"name"];
	[aCoder encodeObject:home forKey:@"home"];
	[aCoder encodeObject:registerPage forKey:@"registerPage"];
	[aCoder encodeObject:needID forKey:@"needID"];
	[aCoder encodeObject:account forKey:@"account"];
}

- (id)description
{
	return [NSString stringWithFormat:
			@"Name->%@, Home->%@, Reg->%@, id->%@, ac->%@",
			name, home, registerPage, needID, account];
}

@end
