//
//  KMBSLogPopUp.h
//  BathyScaphe
//
//  Created by 堀 昌樹 on 12/04/24.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class KMDocument;

@protocol KMBSLogPopUpOwner;

@interface KMBSLogPopUp : NSObject
#if !__LP64__
{
	KMDocument *_doc;
	NSTextView *_documentView;
	id <KMBSLogPopUpOwner> _owner;
}
#endif

@property (assign) KMDocument *doc;
@property (assign) NSTextView *documentView;

@property (assign) id <KMBSLogPopUpOwner> owner;


- (BOOL)tryShowPopUpMatchAttributes:(NSUInteger)messageAtributesMask locationHint:(NSPoint)location_;
- (BOOL)tryShowPopUpIDForEevent:(NSEvent *)theEvent;
- (BOOL)tryShowPopUpReverseAnchor:(NSUInteger)targetIndex locationHint:(NSPoint)location_;
- (BOOL)tryShowPopUpWindowSubstringWithRange:(NSRange)subrange
							   inTextStorage:(NSTextStorage *)storage
								locationHint:(NSPoint)loc;
- (BOOL)tryShowPopUpWindowWithLink:(id)aLink
					  locationHint:(NSPoint)loc;

- (void)closePopUpWindowForObject:(id)obj;

@end

@protocol KMBSLogPopUpOwner <NSObject>
- (BOOL)isMessageLink:(id)aLink messageIndexes:(NSIndexSet **)indexesPtr;

- (NSUInteger)numberOfMessage;
@end
