%
% This is part of LFSbookko package.
%
% This is a CTIE change file for the original XML source of the LFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Foreword</title>
@y
  <title>はしがき</title>
@z

@x
<para>My journey to learn and better understand Linux began over a decade ago,
back in 1998. I had just installed my first Linux distribution and had
quickly become intrigued with the whole concept and philosophy behind
Linux.</para> 
@y
<para>
私が Linux について理解し学び始めたのは 1998 年頃からです。
Linux ディストリビューションのインストールを行ったのはその時が初めてです。
そして即座に Linux 全般の考え方や原理について興味を抱くようになりました。
</para> 
@z

@x
<para>There are always many ways to accomplish a single task. The same can be
said about Linux distributions. A great many have existed over the years.  Some
still exist, some have morphed into something else, yet others have been
relegated to our memories.  They all do things differently to suit the needs of
their target audience.  Because so many different ways to accomplish the same
end goal exist, I began to realize I no longer had to be limited by any one
implementation. Prior to discovering Linux, we simply put up with issues in
other Operating Systems as you had no choice. It was what it was, whether you
liked it or not. With Linux, the concept of choice began to emerge.  If you
didn't like something, you were free, even encouraged, to change it.</para>
@y
<para>
何かの作業を完成させるには多くの方法があるものです。
同じことは Linux ディストリビューションについても言えます。
この数年の間に数多くのディストリビューションが登場しました。
あるものは今も存在し、あるものは他のものへと形を変え、そしてあるものは記憶の彼方へ追いやられたりもしました。
それぞれが利用者の求めに応じて、さまざまに異なる形でシステムを実現してきたわけです。
最終ゴールが同じものなのに、それを実現する方法がたくさんあるものです。
したがって私は一つのディストリビューションにとらわれることが不要だと思い始めました。
Linux が登場する以前であれば、オペレーティングシステムに何か問題があったとしても、他に選択肢はなくそのオペレーティングシステムで満足する以外にありませんでした。
それはそういうものであって、好むと好まざるは関係がなかったのです。
それが Linux になって "選ぶ" という考え方が出てきたわけです。
何かが気に入らなかったら、いくらでも変えたら良いし、そうすることがむしろ当たり前なのです。
</para>
@z

@x
<para>I tried a number of distributions and could not decide on any one. They
were great systems in their own right. It wasn't a matter of right and
wrong anymore. It had become a matter of personal taste. With all that
choice available, it became apparent that there would not be a single
system that would be perfect for me. So I set out to create my own Linux
system that would fully conform to my personal preferences.</para>
@y
<para>
数多くのディストリビューションを試してみましたが、これという１つに決定できるものがありませんでした。
個々のディストリビューションは優れたもので、それぞれを見てみれば正しいものです。
ただこれは正しいとか間違っているとかの問題ではなく、個人的な趣味の問題へと変化しているのです。
こうしたさまざまな状況を通じて明らかになってきたのは、私にとって完璧なシステムは１つもないということです。
そこで私は自分自身の Linux を作り出して、自分の好みを満足させるものを目指したのです。
</para>
@z

@x
<para>To truly make it my own system, I resolved to compile everything from
source code instead of using pre-compiled binary packages. This
<quote>perfect</quote> Linux system would have the strengths of various
systems without their perceived weaknesses. At first, the idea was rather
daunting. I remained committed to the idea that such a system could be
built.</para>
@y
<para>
本当に自分自身のシステムを作り出すため、私はすべてをソースコードからコンパイルすることを目指し、コンパイル済のバイナリパッケージは使わないことにしました。
この<quote>完璧な</quote>Linux システムは、他のシステムが持つ弱点を克服し、逆にすべての強力さを合わせ持つものです。
当初は気の遠くなる思いがしていましたが、そのアイデアは今も持ち続けています。
</para>
@z

@x
<para>After sorting through issues such as circular dependencies and compile-time
errors, I finally built a custom-built Linux system. It was fully
operational and perfectly usable like any of the other Linux systems out
there at the time. But it was my own creation. It was very satisfying to
have put together such a system myself. The only thing better would have
been to create each piece of software myself. This was the next best
thing.</para>
@y
<para>
パッケージが相互に依存している状況やコンパイル時にエラーが発生するなどを順に整理していく中で、私はカスタムメイドの Linux を作り出したのです。
この Linux は今日ある他の Linux と比べても、十分な機能を有し十分に扱いやすいものとなっています。
これは私自身が作り出したものです。
いろいろなものを自分で組み立てていくのは楽しいものです。
後は個々のソフトウェアまでも自分で作り出せれば、もっと楽しいものになるのでしょうが、それは次の目標とします。
</para>
@z

@x
<para>As I shared my goals and experiences with other members of the Linux
community, it became apparent that there was a sustained interest in these
ideas. It quickly became plain that such custom-built Linux systems
serve not only to meet user specific requirements, but also serve as an
ideal learning opportunity for programmers and system administrators to
enhance their (existing) Linux skills. Out of this broadened interest, the
<emphasis>Linux From Scratch Project</emphasis> was born.</para>
@y
<para>
私の求める目標や作業経験を他の Linux コミュニティの方々とも共有する中で、私の Linux への挑戦は絶えることなく続いていくことを実感しています。
このようなカスタムメイドの Linux システムを作り出せば、独自の仕様や要求を満たすことができるのはもちろんですが、さらにはプログラマーやシステム管理者の Linux 知識を引き伸ばす絶好の機会となります。
壮大なこの意欲こそが <emphasis>Linux From Scratch プロジェクト</emphasis>誕生の理由なのです。 
</para>
@z

@x
<para>This Linux From Scratch book is the central core around that project. It
provides the background and instructions necessary for you to design and
build your own system. While this book provides a template that will result
in a correctly working system, you are free to alter the instructions to
suit yourself, which is, in part, an important part of this project. You
remain in control; we just lend a helping hand to get you started on your
own journey.</para>
@y
<para>
Linux From Scratch ブックは関連プロジェクトの中心に位置するものです。
皆さんご自身のシステムを構築するために必要となる基礎的な手順を提供します。
本書が示すのは正常動作するシステム作りのための雛形となる手順ですので、皆さんが望んでいる形を作り出すために手順を変えていくことは自由です。
それこそ、本プロジェクトの重要な特徴でもあります。
そうしたとしても手順を踏み外すものではありません。我々は皆さんが挑戦する旅を応援します。
</para>
@z

@x
<para>I sincerely hope you will have a great time working on your own Linux From
Scratch system and enjoy the numerous benefits of having a system that is
truly your own.</para>
@y
<para>
あなたの LFS システム作りが素晴らしいひとときとなりますように。
そしてあなた自身のシステムを持つ楽しみとなりますように。
</para>
@z
