%
% This is part of LFSbookko package.
%
% This is a CTIE change file for the original XML source of the LFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Prerequisites</title>
@y
  <title>必要な知識</title>
@z

@x
  <para>Building an LFS system is not a simple task. It requires a certain
  level of existing knowledge of Unix system administration in order to resolve
  problems and correctly execute the commands listed. In particular, as an
  absolute minimum, you should already have the ability to use the
  command line (shell) to copy or move files and directories, list directory
  and file contents, and change the current directory. It is also expected that
  you have a reasonable knowledge of using and installing Linux
  software.</para>
@y
  <para>
  LFS システムの構築作業は決して単純なものではありません。
  ある程度の Unix システム管理の知識が必要です。
  問題を解決したり、説明されているコマンドを正しく実行することが求められます。
  ファイルやディレクトリのコピー、それらの表示確認、カレントディレクトリの変更、といったことは最低でも知っていなければなりません。
  さらに Linux の各種ソフトウェアを使ったりインストールしたりする知識も必要です。
  </para>
@z

@x
  <para>Because the LFS book assumes <emphasis>at least</emphasis> this basic
  level of skill, the various LFS support forums are unlikely to be able to
  provide you with much assistance in these areas. You will find that your
  questions regarding such basic knowledge will likely go unanswered or you
  will simply be referred to the LFS essential pre-reading list.</para>
@y
  <para>
  LFS ブックでは、<emphasis>最低でも</emphasis> そのようなスキルがあることを前提としていますので、数多くの LFS サポートフォーラムは、ひょっとすると役に立たないかもしれません。
  フォーラムにおいて基本的な知識を尋ねたとしたら、誰も回答してくれないでしょう。
  そうするよりも LFS に取り掛かる前に以下のような情報をよく読んでください。
  </para>
@z

@x
  <para>Before building an LFS system, we recommend reading the following
  HOWTOs:</para>
@y
  <para>
  LFS システムの構築作業に入る前に、以下の<quote>ハウツー</quote>を読むことをお勧めします。
  </para>
@z

@x
      <para>Software-Building-HOWTO
@y
      <para>ソフトウェア構築のハウツー (Software-Building-HOWTO)
@z

@x
      <para>This is a comprehensive guide to building and installing
      <quote>generic</quote> Unix software packages under Linux. Although it
      was written some time ago, it still provides a good summary of the
      basic techniques needed to build and install software.</para>
@y
  <para>
  これは Linux 上において<quote>一般的な</quote> Unix ソフトウェアを構築してインストールする方法を総合的に説明しています。
  だいぶ前に書かれたものですが、ソフトウェアのビルドとインストールを行うために必要となる基本的な方法が程よくまとめられています。
  </para>
@z

@x
      <para>The Linux Users' Guide
@y
      <para>Linux ユーザーガイド (The Linux Users's Guide)
@z

@x
      <para>This guide covers the usage of assorted Linux software. This
      reference is also fairly old, but still valid.</para>
@y
  <para>
  このガイドには Linux ソフトウェアの利用方法が分類され説明されています。
  若干古いものですが内容に間違いはありません。
  </para>
@z

@x
      <para>The Essential Pre-Reading Hint
@y
      <para>基本的な事前ヒント情報 (The Essential Pre-Reading Hint)
@z

@x
      <para>This is an LFS Hint written specifically for users new to Linux.
      It includes a list of links to excellent sources of information on a
      wide range of topics. Anyone attempting to install LFS should have an
      understanding of many of the topics in this hint.</para>
@y
      <para>
      これは Linux 初心者に向けて書かれた LFS ヒントです。
      ここには非常に多くの有用なトピックへのリンクがあります。
      LFS を構築しようとするなら、これらのヒントに示されている内容は、出来るだけ多く理解しておくことが必要でしょう。
      </para>
@z
