/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package collection;

import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.stream.Stream;

/**
 *
 * @author mtomono
 */
public class ListOperations {
    static public <T> T last(List<T> target) {
        return target.get(target.size() - 1);
    }
    
    static public <T> ListIterator<T> findFore(ListIterator<T> iter, Predicate<T> pred) {
        while (iter.hasNext()) {
            T tested = iter.next();
            if (pred.test(tested)) {
                iter.previous();
                return iter;
            }
        }
        return iter;
    }

    static public <T> ListIterator<T> findBack(ListIterator<T> iter, Predicate<T> pred) {
        while (iter.hasPrevious()) {
            T tested = iter.previous();
            if (pred.test(tested)) {
                iter.next();
                return iter;
            }
        }
        return iter;
    }
    
    static public <T> void clearAround(ListIterator<T> iter, Predicate<T> pred) {
        while (iter.hasNext()) {
            if (pred.test(iter.next()))
                iter.remove();
        }
        while (iter.hasPrevious()) {
            if (pred.test(iter.previous()))
                iter.remove();
        }
    }

}
