/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package collection;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 *
 * @author mtomono
 */
public class RingBuffer<T> extends AbstractList<T> {
    List<T> body;
    int size;
    int index;
    
    public RingBuffer(List<T> init) {
        this.body = new ArrayList<>(init);
        this.size = init.size();
        this.index = 0;
    }
    
    public RingBuffer(int size) {
        this(Collections.nCopies(size, null));
    }
    
    int next() {
        return index = at(1);
    }
    
    int prev() {
        return index = at(size - 1);
    }
    
    int at(int i) {
        return (index + i)%size;
    }
    
    public T push(T t) {
        T retval = set(index, t);
        next();
        return retval;
    }
    
    public T pop(T t) {
        prev();
        return set(index, t);
    }
    
    public T set(int index, T t) {
        return body.set(index%size, t);
    }
    
    @Override
    public T get(int i) {
        return body.get(at(i));
    }
    
    @Override
    public int size() {
        return size;
    }
}
