/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package grammar;

import context.IContext;
import java.util.Optional;
import java.util.function.Predicate;

/**
 *
 * @author mtomono
 */
public class Grammars {
    public static <T> Grammar<T> s(Grammar<T>... g) {
        return new Seq<>(g);
    }
    
    public static <T> Grammar<T> n(Predicate<IContext<T>> g) {
        return new Nod<>(g);
    }
    
    public static <T> Grammar<T> e(T e) {
        return n(n->Optional.of(e).equals(n.get(0)));
    }
    
    public static <T> Grammar<T> r(Grammar<T> g) {
        return new Rep<>(g);
    }
    
    public static <T> Grammar<T> o(Grammar<T>... g) {
        return new Or<>(g);
    }
    
    public static <T> Action a(Action... a) {
        return new SeqAction(a);
    }
}
