/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package grammar.action;

import context.IContext;
import grammar.Grammar;

/**
 * an action which holds all the result while matching but 
 * removes all the result after match().
 * this suites when the grammar may represented as a object but 
 * the grammar inside may put some objects in ParseResult.
 * with this class, you can substitute all the result with an object.
 * this is the case of Grammar.Range.
 * @author mtomono
 */
public class OmitTree extends Branch {
    @Override
    public void match(IContext<?> context, int start, int end, Grammar origin) {
        context.stack().pop();
    }
    
    @Override
    public String toString() {
        return "@-";
    }
}
