/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import static org.testng.Assert.*;
import org.testng.annotations.Test;

/**
 *
 * @author mtomono
 */
public class EmptyRangeTest {
    Range<Integer> empty = new Empty<>();
    Range<Integer> comparison = new Between<>(-12, 2, new NaturalOrder<Integer>());
    
    public EmptyRangeTest() {
    }

    @Test
    public void testClone() {
        assertEquals(empty, empty.clone());
    }

    @Test
    public void testEquals() {
        assertEquals(empty, new Empty<>());
    }

    @Test
    public void testHashCode() {
        assertEquals(empty.hashCode(), new Empty<>().hashCode());
    }

    /*
     * EmptyFragmentは空集合だから
     */
    @Test
    public void testDoesContain_GenericType() {
        class y {
            boolean test(Range<Integer> obj, Integer arg) {
                return obj.contains(arg);
            }
        }
        assertEquals(false, new y().test(empty,  1));
        assertEquals(false, new y().test(empty,  0));
        assertEquals(false, new y().test(empty, -1));
    }

    /*
     * すべての集合は空集合を含むから
     */
    @Test
    public void testDoesContain_Fragment() {
        class x {
            boolean test(Range<Integer> obj, Range<Integer> arg) {
                return obj.contains(arg);
            }
        }
        assertEquals(true , new x().test(empty,      empty));
        assertEquals(true , new x().test(comparison, empty));
        assertEquals(false, new x().test(empty, comparison));
    }

    /*
     * 境界値を下限とする集合または境界値を下限とする集合には空集合が含まれるから
     */
    @Test
    public void testIsUpperThan_GenericType() {
        class y {
            boolean test(Range<Integer> obj, Integer arg) {
                return obj.isAbove(arg);
            }
        }
        assertEquals(true , new y().test(empty,  1));
        assertEquals(true , new y().test(empty,  0));
        assertEquals(true , new y().test(empty, -1));
    }

    /*
     * 境界値を下限とする集合または境界値を下限とする集合には空集合が含まれるから
     */
    @Test
    public void testIsUpperThan_Fragment() {
        class x {
            boolean test(Range<Integer> obj, Range<Integer> arg) {
                return obj.isUpperThan(arg);
            }
        }
        assertEquals(true , new x().test(empty,      empty));
        assertEquals(true , new x().test(comparison, empty));
        assertEquals(true , new x().test(empty, comparison));
    }

    /*
     * 境界値を下限とする集合または境界値を下限とする集合には空集合が含まれるから
     */
    @Test
    public void testIsLowerThan_GenericType() {
        class y {
            boolean test(Range<Integer> obj, Integer arg) {
                return obj.isBelow(arg);
            }
        }
        assertEquals(true , new y().test(empty,  1));
        assertEquals(true , new y().test(empty,  0));
        assertEquals(true , new y().test(empty, -1));
    }

    /*
     * 境界値を下限とする集合または境界値を下限とする集合には空集合が含まれるから
     */
    @Test
    public void testIsLowerThan_Fragment() {
        class x {
            boolean test(Range<Integer> obj, Range<Integer> arg) {
                return obj.isLowerThan(arg);
            }
        }
        assertEquals(true , new x().test(empty,      empty));
        assertEquals(true , new x().test(comparison, empty));
        assertEquals(true , new x().test(empty, comparison));
    }

    /*
     * overlapするとはintersectが空集合ではないということだから
     */
    @Test
    public void testDoesOverlap() {
        class x {
            boolean test(Range<Integer> obj, Range<Integer> arg) {
                return obj.overlaps(arg);
            }
        }
        assertEquals(false, new x().test(empty,      empty));
        assertEquals(false, new x().test(comparison, empty));
        assertEquals(false, new x().test(empty, comparison));
    }

    /*
     * 空集合には境界値がないから
     */
    @Test
    public void testDoesAdjoin() {
        class x {
            boolean test(Range<Integer> obj, Range<Integer> arg) {
                return obj.adjoins(arg);
            }
        }
        assertEquals(false, new x().test(empty,      empty));
        assertEquals(false, new x().test(comparison, empty));
        assertEquals(false, new x().test(empty, comparison));
    }

    /*
     * 空集合には境界値がないから
     */
    @Test
    public void testDoesAdjoinAtStart() {
        class x {
            boolean test(Range<Integer> obj, Range<Integer> arg) {
                return obj.adjoinsAtStartWith(arg);
            }
        }
        assertEquals(false, new x().test(empty,      empty));
        assertEquals(false, new x().test(comparison, empty));
        assertEquals(false, new x().test(empty, comparison));
    }

    /*
     * 空集合には境界値がないから
     */
    @Test
    public void testDoesAdjoinAtEnd() {
        class x {
            boolean test(Range<Integer> obj, Range<Integer> arg) {
                return obj.adjoinsAtEndWith(arg);
            }
        }
        assertEquals(false, new x().test(empty,      empty));
        assertEquals(false, new x().test(comparison, empty));
        assertEquals(false, new x().test(empty, comparison));
    }

    @Test
    public void testIntersect() {
        class x {
            Range<Integer> test(Range<Integer> obj, Range<Integer> arg) {
                return obj.intersect(arg);
            }
        }
        assertEquals(empty     , new x().test(empty,      empty));
        assertEquals(empty     , new x().test(comparison, empty));
        assertEquals(empty     , new x().test(empty, comparison));
    }

    @Test
    public void testCover() {
        class x {
            Range<Integer> test(Range<Integer> obj, Range<Integer> arg) {
                return obj.cover(arg);
            }
        }
        assertEquals(empty     , new x().test(empty,      empty));
        assertEquals(comparison, new x().test(comparison, empty));
        assertEquals(comparison, new x().test(empty, comparison));
    }

    /*
     * 境界値を下限とする集合または境界値を下限とする集合には空集合が含まれるから
     */
    @Test
    public void testGetUpper_GenericType() {
        class y {
            Range<Integer> test(Range<Integer> obj, Integer arg) {
                return obj.getUpper(arg);
            }
        }
        assertEquals(empty , new y().test(empty,  1));
        assertEquals(empty , new y().test(empty,  0));
        assertEquals(empty , new y().test(empty, -1));
    }

    /*
     * 境界値を下限とする集合または境界値を下限とする集合には空集合が含まれるから
     */
    @Test
    public void testGetUpper_Fragment() {
        class x {
            Range<Integer> test(Range<Integer> obj, Range<Integer> arg) {
                return arg.getUpperRoomIn(obj);
            }
        }
        assertEquals(empty     , new x().test(empty,      empty));
        assertEquals(comparison, new x().test(comparison, empty));
        assertEquals(empty     , new x().test(empty, comparison));
    }

    /*
     * 境界値を下限とする集合または境界値を下限とする集合には空集合が含まれるから
     */
    @Test
    public void testGetLower_GenericType() {
        class y {
            Range<Integer> test(Range<Integer> obj, Integer arg) {
                return obj.getLower(arg);
            }
        }
        assertEquals(empty , new y().test(empty,  1));
        assertEquals(empty , new y().test(empty,  0));
        assertEquals(empty , new y().test(empty, -1));
    }

    /*
     * 境界値を下限とする集合または境界値を下限とする集合には空集合が含まれるから
     */
    @Test
    public void testGetLower_Fragment() {
        class x {
            Range<Integer> test(Range<Integer> obj, Range<Integer> arg) {
                return arg.getLowerRoomIn(obj);
            }
        }
        assertEquals(empty     , new x().test(empty,      empty));
        assertEquals(comparison, new x().test(comparison, empty));
        assertEquals(empty     , new x().test(empty, comparison));
    }
}
