/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package parser;

import grammar.Or;
import grammar.Nod;
import grammar.Grammar;
import grammar.Seq;
import context.IContext;
import static org.testng.Assert.*;
import org.testng.annotations.Test;
import static grammar.Convenients.eq;
import static parser.Fixture.a;
import static parser.Fixture.o;
import static parser.Fixture.testList3;

/**
 *
 * @author mtomono
 */
public class MOr {
    
    public MOr() {
    }

    String test0 = "test0";
    String test1 = "test1";

    @Test
    public void or_success() {
        IContext<String> c = IContext.c(testList3, 2);
        assertTrue(ParseAndStay.matches(new Or<>(new Seq<>(new Nod<>(eq(test1)), new Nod<>(eq(test0))), new Seq<>(new Nod<>(eq(test0)), new Nod<>(eq(test1)))), c));
    }
    @Test
    public void or_success_get() {
        IContext<String> c = IContext.c(testList3, 2);
        Grammar<String> g = new Or<>(new Seq<>(new Nod<>(eq(test1)), new Nod<>(eq(test0))), 
                                     new Seq<>(new Nod<>(eq(test0)), new Nod<>(eq(test1))));
        assertEquals(new SimpleParser<>(g).parse(c).get(0), a(a(a(o("test0")), a(o("test1")))));
    }

    
    @Test
    public void or_success2_get() {
        IContext<String> c = IContext.c(testList3, 2);
        Grammar<String> g = new Or<>(new Seq<>(new Nod<>(eq(test0)), new Nod<>(eq(test1))), 
                                     new Seq<>(new Nod<>(eq(test1)), new Nod<>(eq(test0))));
        assertEquals(new SimpleParser<>(g).parse(c).get(0), a(a(a(o("test0")), a(o("test1")))));
    }

    @Test
    public void or_success2() {
        IContext<String> c = IContext.c(testList3, 2);
        assertTrue(ParseAndStay.matches(new Or<>(new Seq<>(new Nod<>(eq(test0)), new Nod<>(eq(test1))), new Seq<>(new Nod<>(eq(test1)), new Nod<>(eq(test0)))), c));
    }
    @Test
    public void or_fail() {
        IContext<String> c = IContext.c(testList3, 2);
        assertFalse(ParseAndStay.matches(new Or<>(new Seq<>(new Nod<>(eq(test1)), new Nod<>(eq(test0))), new Seq<>(new Nod<>(eq(test1)), new Nod<>(eq(test0)))), c));
    }
    @Test
    public void or_fail2() {
        IContext<String> c = IContext.c(testList3, 2);
        assertFalse(ParseAndStay.matches(new Or<>(new Nod<>(eq(test1)), new Nod<>(eq(test1))), c));
    }
    
}
