//
//  ECLayerPropertyPanelWindowController.m
//  Etokicho
//
//  Created by 二鏡 on 11/11/23.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import "ECLayerPropertyPanelWindowController.h"
#import "ECCompositionEditorPanelController.h"
#import "ECSceneComposition.h"

static id _si = nil;

@implementation ECLayerPropertyPanelWindowController

+ (id)sharedPanel
{
    if(_si == nil)
    {
        _si = [[self alloc] initWithWindowNibName: @"LayerPropertyPanel"];
        [_si window];
    }
    return _si;
}

- (void)awakeFromNib
{
    [self setWindowFrameAutosaveName: @"LayerPropertyPanelFrame"];
}

- (NSUndoManager *)windowWillReturnUndoManager:(NSWindow *)window
{
    return [[NSApp delegate] valueForKeyPath: @"composition.undo"];
}

- (void)_showPostEffectEditor:(id)obj
{
    id panel = [ECCompositionEditorPanelController sharedPostEffectEditor];
    ECSceneComposition *composition = [[NSApp delegate] valueForKey: @"composition"];
    id scene = composition.scene;
    ECLayerProxy *proxy = composition.selectedLayer;
    ECLayer <QCLayer> *layer = [proxy valueForKey: @"target"];
    NSUInteger index = [[scene layers] indexOfObject: layer];
    [panel loadScene: scene
          layerIndex: index];
    [panel setProtocol: QCCompositionProtocolImageFilter];
    [panel setAllowsSimulate: YES];
    
    if([panel startModal] == NSOKButton)
    {
        id filterItem = [panel filter];
        [proxy setValue: filterItem forKey: @"compositionItem"];
    }
}


// animation layer
- (void)_showCompositionEditor:(id)obj
{
    id panel = [ECCompositionEditorPanelController sharedPostEffectEditor];
    ECSceneComposition *composition = [[NSApp delegate] valueForKey: @"composition"];
    id scene = composition.scene;
    ECLayerProxy *proxy = composition.selectedLayer;
    
    NSUInteger index = composition.selection.firstIndex;
    [panel loadScene: scene
          layerIndex: index];
    [panel setProtocol: QCCompositionProtocolGraphicAnimation];
    [panel setAllowsSimulate: YES];    
    
    if([panel startModal] == NSOKButton)
    {
        id filterItem = [panel filter];
        [proxy setValue: filterItem forKey: @"compositionItem"];
    }    
}

- (IBAction)editPostEffect:(id)sender
{
    [self performSelector: @selector(_showPostEffectEditor:)
               withObject: nil
               afterDelay: 0.0];
}

- (IBAction)editCompositionLayer:(id)sender
{
    [self performSelector: @selector(_showCompositionEditor:)
               withObject: nil
               afterDelay: 0.0];
}

- (NSString*)animationButtonTip
{
    return NSLocalizedString(@"Valid only on animation layer.",@"");
}
@end
