//
//  ECProject.h
//  Etokicho
//
//  Created by 二鏡 on 11/11/13.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ECTimelineManager.h"

NSString *gProjectFileExtension;

@interface ECProject : NSObject
{
    // プロジェクトの固定情報
    // 初期化時に設定
    NSURL *loadURL;
    NSSize movieSize;
}
- (id)initWithMovieSize:(NSSize)aSize;
- (id)initWithContentsOfURL:(NSURL*)aURL
               intoTimeline:(ECTimelineManager*)timelineManager;

@property (readonly) NSSize movieSize;

- (NSURL*)loadURL;
- (ECScene*)emptyScene;
- (BOOL)writeToURL:(NSURL*)aURL
      fromTimeline:(ECTimelineManager*)timelineManager;
@end


@interface ECProject (Statics)
- (NSString*)sizeString;
- (NSString*)projectPath;
@end
