require_relative '../tree.rb'

module Protobuf end

class Protobuf::ASTDummy < TreeNode
  def initialize
    super
  end
end

class Protobuf::ASTReferenceName
  attr_reader :name

  def initialize(name)
    @name = name
  end

  def to_s
    @name
  end

  def +(other)
    Protobuf::ASTReferenceName.new(self.to_s + '.' + other)
  end
end

class Protobuf::ASTEnumConstant < TreeNode
  attr_reader :name, :value

  def initialize(name, value)
    @name = name
    @value = value
    super()
  end
end

class Protobuf::ASTEnum < TreeNode
  attr_reader :name

  def initialize(name, component_list)
    @name = name
    super(component_list)
  end

  def each_constant
    return to_enum(__method__) unless block_given?

    self.each_child { |component|
      yield component if component.is_a? Protobuf::ASTEnumConstant
    }
  end
end

class Protobuf::ASTField < TreeNode
  attr_reader :rule, :type, :name, :tag

  def initialize(rule, type, name, tag)
    @rule = rule
    @type = type
    @name = name
    @tag = tag
    super(nil)
  end

  def owner_message
    self
      .enum_for(:ancestral_each)
      .select{ |item| item.is_a? Protobuf::ASTMessage }
      .first
  end
end

class Protobuf::ASTMessage < TreeNode
  attr_reader :name

  def initialize(name, component_list)
    @name = name
    super(component_list)
  end

  def absolute_name
    self
      .enum_for(:ancestral_each)
      .reverse_each
      .select{ |item| item.is_a? Protobuf::ASTMessage }
      .map{ |item| item.name }
      .join('.')
  end

  def each_field
    return to_enum(__method__) unless block_given?

    self.each_child { |component|
      yield component if component.is_a? Protobuf::ASTField
    }
  end
end

class Protobuf::ASTRoot < TreeNode
  def initialize(component_list)
    super(component_list)
  end

  def each_message
    return to_enum(__method__) unless block_given?

    self.each { |descendant|
      yield descendant if descendant.is_a? Protobuf::ASTMessage
    }
  end
end
