require 'test/unit'
require_relative 'tree.rb'

class TreeTest < Test::Unit::TestCase
  def test_initialize_by_array
    assert_nothing_raised("TreeNode.new fail") {
      child = TreeNode.new
      array = Array.new
      array.push child

      parent = TreeNode.new array
    }
  end

  def test_append_child
    assert_nothing_raised("append_child fail") {
      parent = TreeNode.new
      child = TreeNode.new

      parent.append_child child
    }
  end

  def test_each_child_1
    node0 = TreeNode.new
    node1 = TreeNode.new
    node2 = TreeNode.new
    node3 = TreeNode.new
    node4 = TreeNode.new

    node0.append_child node1
    node1.append_child node2
    node1.append_child node3
    node1.append_child node4

    array = node0.to_a

    assert(array[0] == node0, "check node0") { }
    assert(array[1] == node1, "check node1") { }
    assert(array[2] == node2, "check node2") { }
    assert(array[3] == node3, "check node3") { }
    assert(array[4] == node4, "check node4") { }
  end

  def test_each_child_2
    node0 = TreeNode.new
    node1 = TreeNode.new
    node2 = TreeNode.new
    node3 = TreeNode.new
    node4 = TreeNode.new

    node0.append_child node1
    node1.append_child node2
    node2.append_child node3
    node2.append_child node4

    array = node0.to_a

    assert(array[0] == node0, "check node0") { }
    assert(array[1] == node1, "check node1") { }
    assert(array[2] == node2, "check node2") { }
    assert(array[3] == node3, "check node3") { }
    assert(array[4] == node4, "check node4") { }
  end

  def test_each_child_3
    node0 = TreeNode.new
    node1 = TreeNode.new
    node2 = TreeNode.new
    node3 = TreeNode.new   
    node4 = TreeNode.new [node0, node1, node2, node3]

    array = node4.to_a

    assert(array[0] == node4, "check node0") { }
    assert(array[1] == node0, "check node1") { }
    assert(array[2] == node1, "check node2") { }
    assert(array[3] == node2, "check node3") { }
    assert(array[4] == node3, "check node4") { }
  end

  def test_each_child_4
    node0 = TreeNode.new
    node1 = TreeNode.new
    node2 = TreeNode.new
    node3 = TreeNode.new
    node4 = TreeNode.new

    node0.append_child node1
    node1.append_child node2
    node0.append_child node3
    node0.append_child node4

    result = Array.new
    node0.each_child { |child|
      result.push child
    }

    assert(result.size == 3, "invalid number") { }
    assert(result.include?(node1), "check node1") { }
    assert(result.include?(node3), "check node3") { }
    assert(result.include?(node4), "check node4") { }
  end

  def test_ancestral_each
    node0 = TreeNode.new
    node1 = TreeNode.new
    node2 = TreeNode.new
    node3 = TreeNode.new
    node4 = TreeNode.new

    node0.append_child node1
    node1.append_child node2
    node0.append_child node3
    node0.append_child node4

    result = node2.enum_for(:ancestral_each).to_a

    assert(result.size == 3, "invalid number") { }
    assert(result[0] == node2, "check index 0") { }
    assert(result[1] == node1, "check index 1") { }
    assert(result[2] == node0, "check index 2") { }
  end

  def test_root
    node0 = TreeNode.new
    node1 = TreeNode.new
    node2 = TreeNode.new
    node3 = TreeNode.new
    node4 = TreeNode.new

    node0.append_child node1
    node1.append_child node2
    node0.append_child node3
    node0.append_child node4

    assert(node0.root == node0, "check node0's root") { }
    assert(node1.root == node0, "check node1's root") { }
    assert(node2.root == node0, "check node2's root") { }
    assert(node3.root == node0, "check node3's root") { }
    assert(node4.root == node0, "check node4's root") { }
  end

  def test_enumerator_return
    assert(TreeNode.new.each.is_a?(Enumerator), "each_child is not return Enumrator") { }
    assert(TreeNode.new.each_child.is_a?(Enumerator), "each_child is not return Enumrator") { }
    assert(TreeNode.new.ancestral_each.is_a?(Enumerator), "each_child is not return Enumrator") { }
  end
end
