package littlemaid.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class LayerHeldItem implements LayerRenderer {

	private final RenderLittleMaid maidIn;

	public LayerHeldItem(RenderLittleMaid maid) {
		this.maidIn = maid;
	}

	@Override
	public void doRenderLayer(EntityLivingBase entity, float distance, float intensity, float partialTicks, float livingTime, float headRotateYaw, float headRotatePitch, float scale) {
		ItemStack itemstack = entity.getHeldItem();

		if (itemstack != null)
		{
			// 現在の変換行列を保存（現状の設定を退避）
			GlStateManager.pushMatrix();

	        // 下に8ドット分ずらす
	        GlStateManager.translate(0.0F, 8.0F * scale, 0.0F);

			// 直前に描画した部品にくっつく形でアイテムが描画されるので持ち腕を再描画する
            ((ModelBiped)this.maidIn.getMainModel()).postRenderArm(scale);
			// オブジェクトの平行移動 x(+右), y(+下), z(+後)
            GlStateManager.translate(-0.0625F, 0.3F, 0.0625F);
            // オブジェクトの回転（たぶん） angle回転角, x, y, z回転軸ベクトル
//            GlStateManager.rotate(-20.0F, -1.0F, 0.0F, 0.0F);
            // オブジェクトの倍率
            float s1 = 0.8F;
            GlStateManager.scale(s1, s1, s1);

			Item item = itemstack.getItem();
			Minecraft minecraft = Minecraft.getMinecraft();

			// オリジナルが必要としてるから使うけど、ソース見たところ、そのうちrenderItemの3つ目の引数は消えそう。
			minecraft.getItemRenderer().renderItem(entity, itemstack, ItemCameraTransforms.TransformType.THIRD_PERSON);
			// 保存していた変換行列を復帰させる（退避していた設定を復旧）
			GlStateManager.popMatrix();
		}

	}

	@Override
	public boolean shouldCombineTextures() {
		return false;
	}

}
