package littlemaid.entity.ai;

import littlemaid.entity.EntityLittleMaid;
import net.minecraft.entity.ai.EntityAIBase;

public class EntityAILanding extends EntityAIBase {

	private EntityLittleMaid theEntity;

	private boolean isLanding;
	private double fallVelocity;

	public EntityAILanding(EntityLittleMaid entityIn) {
		this.theEntity = entityIn;
		this.isLanding = false;
		this.setMutexBits(0);
	}

	@Override
	public boolean shouldExecute() {

		if (this.theEntity.isInWater())
		{
			return false;
		}
		else if (this.theEntity.onGround)
		{
			return false;
		}
		else
		{
			return this.theEntity.fallDistance > 4.0F ? true : this.theEntity.isLanding();
		}
		// エンティティにもisSoftLandingとsetSoftLandingいるわ。　モデルの変更が必要だから。

	}

	@Override
	public void startExecuting() {
		this.theEntity.setLanding(true);
		this.fallVelocity = 0D;
	}

	@Override
	public boolean continueExecuting() {
		return !this.theEntity.isInWater() && !this.theEntity.onGround;
	}

	@Override
	public void updateTask() {
		if (this.theEntity.fallDistance > 2.0F)
		{
			this.fallVelocity = -0.02D;
			this.theEntity.fallDistance = 0.0F;
		}
		else
		{
			this.fallVelocity *= 1.1D;
		}
		this.theEntity.setVelocity(0.0D, this.fallVelocity, 0.0D);
	}

	@Override
	public void resetTask() {
		this.theEntity.setLanding(false);
	}

}
