package littlemaid.gui;

import littlemaid.LittleMaidCore;
import littlemaid.entity.EntityLittleMaid;
import littlemaid.inventory.ContainerLittleMaid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

/**
 * サーバー側でplayer.openGui()すると、getServerGuiElement->getClientGuiElementの順番で呼び出される。
 */
public class GuiHandlerLittleMaid implements IGuiHandler {

	public static final int GUI_ID_INVVENTORY	= 0;

	public GuiHandlerLittleMaid() {
	}

	/**
	 * @return Containerインスタンス
	 */
	@Override
	public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {

		LittleMaidCore.getLogger().info("LittleMaidGuiHandler_getServerGuiElement");
		EntityLittleMaid maid = (EntityLittleMaid)world.getEntityByID(x);

		Object oRet = null;
		switch(ID)
		{
			case GUI_ID_INVVENTORY:
				oRet = new ContainerLittleMaid(player, maid);
			break;
		}

		return oRet;
	}

	/**
	 * @return GuiScreenインスタンス
	 */
	@Override
	public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {

		LittleMaidCore.getLogger().info("LittleMaidGuiHandler_getClientGuiElement");
		EntityLittleMaid maid = (EntityLittleMaid)world.getEntityByID(x);

		Object oRet = null;
		switch(ID)
		{
			case GUI_ID_INVVENTORY:
				oRet = new GuiLittleMaidInventory(player, maid);
			break;
		}

		return oRet;
	}

}
