// -*- C++ -*-
/*!
 * @file OutPortPullConnector.cpp
 * @brief OutPortPull type connector class
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2009
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#include <rtm/OutPortPullConnector.h>
#include <rtm/OutPortProvider.h>

namespace RTC
{
  OutPortPullConnector::OutPortPullConnector(ConnectorInfo info,
                                             OutPortProvider* provider,
                                             ConnectorListeners& listeners,
                                             CdrBufferBase* buffer)
    : OutPortConnector(info),
      m_provider(provider),
      m_listeners(listeners),
      m_buffer(buffer)
  {
    // create buffer
    if (m_buffer == 0)
      {
        m_buffer = createBuffer(info);
      }

    if (m_provider == 0 || m_buffer == 0) { throw std::bad_alloc(); }

    m_buffer->init(info.properties.getNode("buffer"));
    m_provider->setBuffer(m_buffer);
    m_provider->setConnector(this);
    //    m_provider->init(m_profile /* , m_listeners */);
    m_provider->setListener(info, &m_listeners);

    onConnect();
  }

  OutPortPullConnector::~OutPortPullConnector()
  {
    onDisconnect();
    disconnect();
  }
  
  ConnectorBase::ReturnCode
  OutPortPullConnector::write(const cdrMemoryStream& data)
  {
    m_buffer->write(data);
    return PORT_OK;
  }
  
  ConnectorBase::ReturnCode OutPortPullConnector::disconnect()
  {
    // delete provider

    //    OutPortProviderFactory& factory(OutPortProviderFactory::instance());
    //    factory.deleteObject(m_buffer);
    
    return PORT_OK;
  }

  /*!
   * @if jp
   * @brief Buffer 
   *
   * Connector ݻƤ Buffer ֤
   *
   * @else
   * @brief Getting Buffer
   *
   * This operation returns this connector's buffer
   *
   * @endif
   */
  CdrBufferBase* OutPortPullConnector::getBuffer()
  {
    return m_buffer;
  }
  
  /*!
   * @if jp
   * @brief Buffer
   * @else
   * @brief create buffer
   * @endif
   */
  CdrBufferBase* OutPortPullConnector::createBuffer(ConnectorInfo& info)
  {
    std::string buf_type;
    buf_type = info.properties.getProperty("buffer_type",
                                              "ring_buffer");
    return CdrBufferFactory::instance().createObject(buf_type);
  }

  /*!
   * @if jp
   * @brief ³Ω˥ХåƤ
   * @else
   * @brief Invoke callback when connection is established
   * @endif
   */
  void OutPortPullConnector::onConnect()
  {
    m_listeners.connector_[ON_CONNECT].notify(m_profile);
  }

  /*!
   * @if jp
   * @brief ³ǻ˥ХåƤ
   * @else
   * @brief Invoke callback when connection is destroied
   * @endif
   */
  void OutPortPullConnector::onDisconnect()
  {
    m_listeners.connector_[ON_DISCONNECT].notify(m_profile);
  }
};

