package com.wiki.standalone.moxkiriya.dialog;

import java.net.MalformedURLException;
import java.util.LinkedHashMap;

import com.wiki.standalone.moxkiriya.ResourceManager;

import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class AlertDialogController extends DialogControllerBase {
	@FXML
	private ImageView ImageViewIcon;

	@FXML
	private Label labelMessage;
	
	@FXML
	private Label labelDetails;
	
	@FXML
	private Button buttonCancel;

	/**
	 * 終了種別
	 */
	private AlertDialog.CloseType closeType_; 

	/**
	 * Dialogに表示するicon, メッセージ, 詳細を設定する。
	 */
	static class DialogProperty {
		/**
		 * Constructor
		 * @param messageResourceKey
		 * @param detailResourceKey
		 * @param dialogType
		 */
		DialogProperty(String messageResourceKey, String detailResourceKey, AlertDialog.DialogType dialogType) {
			this(messageResourceKey, detailResourceKey, dialogType, AlertDialog.ButtoType.CANCEL_OK);
		};

		/**
		 * Constructor.
		 * @param messageResourceKey
		 * @param detailResourceKey
		 * @param dialogType
		 * @param buttonType
		 */
		DialogProperty(String messageResourceKey, String detailResourceKey, AlertDialog.DialogType dialogType, AlertDialog.ButtoType buttonType) {
			messageResourceKey_ = messageResourceKey;
			detailResourceKey_  = detailResourceKey;
			dialogType_         = dialogType;
			buttonType_         = buttonType;
		};

		String                 messageResourceKey_;
		String                 detailResourceKey_;
		AlertDialog.DialogType dialogType_;
		AlertDialog.ButtoType  buttonType_;
	};
	
	/**
	 * MessageType/DialogPropertyテーブル
	 */
	private final static LinkedHashMap<AlertDialog.MessageType, DialogProperty> dialogPropertyTable
		= new LinkedHashMap<AlertDialog.MessageType, DialogProperty>() {
			private static final long serialVersionUID = 1L;

		{
			put(AlertDialog.MessageType.ConfirmEditCancel,
				new DialogProperty("key.Dialog.Message.Cancel.Editing",
						"key.Dialog.Detail.Cancel.Editing",
						AlertDialog.DialogType.Confirm));
			put(AlertDialog.MessageType.AlertTitleEmpty,
					new DialogProperty("key.Dialog.Message.Empty.Title",
							"key.Dialog.Detail.Input.Title",
							AlertDialog.DialogType.Alert,
							AlertDialog.ButtoType.OK));
			put(AlertDialog.MessageType.SuccessImport,
					new DialogProperty("key.Dialog.Import.Result.Title",
							"key.Dialog.Detail.Import.Success",
							AlertDialog.DialogType.Info,
							AlertDialog.ButtoType.OK));
			put(AlertDialog.MessageType.FailureImport,
					new DialogProperty("key.Dialog.Import.Result.Title",
							"key.Dialog.Detail.Import.Failure",
							AlertDialog.DialogType.Error,
							AlertDialog.ButtoType.OK));
			put(AlertDialog.MessageType.SuccessExport,
					new DialogProperty("key.Dialog.Export.Result.Title",
							"key.Dialog.Detail.Export.Success",
							AlertDialog.DialogType.Info,
							AlertDialog.ButtoType.OK));
			put(AlertDialog.MessageType.FailureExport,
					new DialogProperty("key.Dialog.Export.Result.Title",
							"key.Dialog.Detail.Export.Failure",
							AlertDialog.DialogType.Error,
							AlertDialog.ButtoType.OK));
		}
	};

	/**
	 * MessageTypeを設定する。
	 * @param msgType
	 * @throws MalformedURLException 
	 */
	public void setMessageType(AlertDialog.MessageType msgType) throws MalformedURLException {
		DialogProperty dialogProperty = dialogPropertyTable.get(msgType);

		if(dialogProperty != null) {
			/*
			 * メッセージ、詳細情報を設定する。
			 */
			labelMessage.setText(resource_.getString(dialogProperty.messageResourceKey_));
			labelDetails.setText(resource_.getString(dialogProperty.detailResourceKey_));
	
			/*
			 * アイコンを設定する。
			 */
			Image  image = ResourceManager.IconTable.get(dialogProperty.dialogType_);
			ImageViewIcon.setImage(image);
			
			/*
			 * ボタンを設定する。
			 */
			if(dialogProperty.buttonType_ == AlertDialog.ButtoType.OK) {
				buttonCancel.setVisible(false);
			}
			else {
				buttonCancel.setVisible(true);
			}
		}
	}

	/**
	 * 終了種別を取得する。
	 * @param closeType
	 */
	public AlertDialog.CloseType getCloseType() {
		return closeType_;
	}

	@FXML
	public void onActionButtonOK(ActionEvent event) {
		closeType_ = AlertDialog.CloseType.OK;
		((Node)event.getSource()).getScene().getWindow().hide();
	}

	@FXML
	public void onActionButtonCancel(ActionEvent event) {
		closeType_ = AlertDialog.CloseType.Cancel;
		((Node)event.getSource()).getScene().getWindow().hide();
	}
}
