/**
 * Moxkiriya standalone Wiki.
 * ConfigSettingsDialog.
 * 
 * @author Ryuhei Terada
 * See the '<a href="{@docRoot}/copyright.html">Copyright</a>'
 */
package com.wiki.standalone.moxkiriya.dialog;

import java.util.Hashtable;

import javafx.stage.Modality;
import javafx.stage.Stage;

/**
 * ConfigSettingsDialog
 */
public class ConfigSettingsDialog extends DialogBase {
	/** target party name. */
	private String partyName_;

	/**
	 * Constructor.
	 */
	public ConfigSettingsDialog() {
		this(null);
	}

	/**
	 * Constructor.
	 * @param partyName
	 */
	public ConfigSettingsDialog(String partyName) {
		super();
		partyName_ = partyName;
	}
	
	@Override
	protected String getFXML() {
		return "ConfigSettingsDialog.fxml";
	}

	@Override
	protected DialogController getController() {
		ConfigSettingsDialogController controller = loader_.getController();
		controller.setWindow(scene_.getWindow());
		controller.setPartyName(partyName_);
		return controller;
	}

	@Override
	protected CloseType show() {
		Stage stage = new Stage();

		stage.initOwner(parentStage_);
		stage.initModality(Modality.APPLICATION_MODAL);
		stage.setScene(scene_);
		stage.setResizable(false);
		stage.showAndWait();

		return getCloseType();		
	}

	/**
	 * Settings table getter.
	 * @return Hashtable<String, String>
	 */
	public Hashtable<String, String> getSettingsTable() {
		return ((ConfigSettingsDialogController)controller_).getSettingsTable();
	}

	/**
	 * Default party checkbox value getter.
	 * @return boolean
	 */
	public boolean getDefaultPartyCheckValue() {
		return ((ConfigSettingsDialogController)controller_).getDefaultPartyCheckValue();
	}

	/**
	 * Party name getter.
	 * @return String
	 */
	public String getPartyName() {
		return ((ConfigSettingsDialogController)controller_).getPartyName();
	}

}