package com.wiki.standalone.moxkiriya.parser.inlineparser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.wiki.standalone.moxkiriya.WikiEngine;

public class WikiBoldInlineParser extends WikiInlineParserBase {
	/** WIKIトークン */
	public static final String WIKI_TOKEN    = "'''";

	/** WIKI記法の正規表現文字列　先頭頭パターン */
	public static final String PATTERN_START = "'''[^']";

	/** WIKI記法の正規表現文字列　末尾パターン */
	public static final String PATTERN_END = "[^']'''";

	/** WIKI記法の正規表現文字列　末尾パターン */
	public static final String PATTERN_ITALIC_END = WikiItalicInlineParser.PATTERN_END;

	/** 開始タグ */
	private static final String START_TAG = "<span id=\"bold\">\n";

	/** 終了タグ */
	private static final String END_TAG = "</span>\n";
	
	/**
	 * コンストラクタ
	 */
	public WikiBoldInlineParser(WikiEngine wikiEngine) {
		super(wikiEngine);
	}

	/**
	 * lineとWiki記法をマッチングする
	 * @param line
	 * @return マッチング結果
	 */
	public static boolean matches(String line) {
		boolean isMatch = false;
		
		Matcher startMatcher
			= Pattern.compile(WikiBoldInlineParser.PATTERN_START)
					.matcher(line);
		
		if(startMatcher.find() == true) {
			isMatch = true;
		}
		
		return isMatch;
	}

	@Override
	public void startElementProcess(StringBuffer buf) {
		buf.append(START_TAG);
	}

	@Override
	public void endElementProcess(StringBuffer buf) {
		buf.append(END_TAG);
	}

	@Override
	public String deleteWikiToken(String line) {
		String deleteTop = line.replaceFirst(WIKI_TOKEN, "");
		if(deleteTop.contains(WIKI_TOKEN) == true) {
			deleteTop = deleteTop.substring(0, deleteTop.lastIndexOf(WIKI_TOKEN));
		}
		return deleteTop;
	}

	@Override
	public String getStartPattern() {
		return PATTERN_START;
	}

	@Override
	public String getEndPattern() {
		return PATTERN_END;
	}
}
