unit Editor;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, ComCtrls, ExtCtrls, ToolWin, Menus, OleCtrls, Registry,
{$IF Defined(DELPRO) }
	SHDocVw,
	MSHTML,
{$ELSE}
	SHDocVw_TLB,
	MSHTML_TLB,
{$IFEND}
	ActiveX, {HTTPApp,} YofUtils, Trip, IniFiles, StrUtils,
	GikoSystem, GikoUtil, ImgList, Clipbrd, BoardGroup,
	IdAntiFreezeBase,	IdAntiFreeze, IdBaseComponent, IdComponent,
	IdTCPConnection, IdTCPClient, IdHTTP, ActnList, StdActns, IdIntercept,
	IdLogBase, IdLogDebug, IdException, DateUtils, MojuUtils, bmRegExp,
	GestureModel;

type
//	TSetLayeredWindowAttributes = function(wnd: HWND; crKey: DWORD; bAlpha: BYTE; dwFlag: DWORD): Boolean; stdcall;
	//ݖ߂l^Cv
	TGikoResultType = (grtOK, grtCookie, grtCheck, grtError);

	TEditorForm = class(TForm)
		MainMenu: TMainMenu;
		FileMenu: TMenuItem;
		PostMessage: TMenuItem;
		SaveMessage: TMenuItem;
		CloseMenu: TMenuItem;
		N01: TMenuItem;
		StatusBar: TStatusBar;
	EditorPage: TPageControl;
		EditorTab: TTabSheet;
		PreviewTab: TTabSheet;
		Browser: TWebBrowser;
		EditMenu: TMenuItem;
		UndoMenu: TMenuItem;
		CutMenu: TMenuItem;
		CopyMenu: TMenuItem;
		PasteMenu: TMenuItem;
		N02: TMenuItem;
		ToolBarImageList: TImageList;
		HotToobarImageList: TImageList;
		BodyEdit: TMemo;
		NameBasePanel: TPanel;
		NameLabel: TLabel;
		MailLabel: TLabel;
		NameComboBox: TComboBox;
		MailComboBox: TComboBox;
		ToolBar: TToolBar;
		SendToolButton: TToolButton;
		OutBoxToolButton: TToolButton;
		ToolButton5: TToolButton;
		UndoToolButton: TToolButton;
		CutToolButton: TToolButton;
		CopyToolButton: TToolButton;
		PasteToolButton: TToolButton;
		ToolButton3: TToolButton;
		TransToolButton: TToolButton;
		TopToolButton: TToolButton;
		Indy: TIdHTTP;
		IdAntiFreeze: TIdAntiFreeze;
		ToolButton1: TToolButton;
		ToolButton2: TToolButton;
		ActionList: TActionList;
		SendAction: TAction;
		SaveAction: TAction;
		CloseAction: TAction;
		UndoAction: TAction;
		CutAction: TAction;
		CopyAction: TAction;
		PasteAction: TAction;
		AbortAction: TAction;
		TopAction: TAction;
		Show1: TMenuItem;
		T1: TMenuItem;
		N1: TMenuItem;
		S1: TMenuItem;
		SageCheckBox: TCheckBox;
		IdLogDebug: TIdLogDebug;
		TransAction: TAction;
		A1: TMenuItem;
		KotehanCheckBox: TCheckBox;
		TitlePanel: TPanel;
		Label1: TLabel;
		TitleEdit: TEdit;
		SelectAllAction: TAction;
		N2: TMenuItem;
		SelectAll1: TMenuItem;
	Timer1: TTimer;
	QuotePasteAction: TAction;
	QuotePasteMenuItem: TMenuItem;
	C1: TMenuItem;
	SpaceToNBSPAction: TAction;
	AmpToCharRefAction: TAction;
	SpaceTabnbsp1: TMenuItem;
	amp1: TMenuItem;
	BoardInformationTab: TTabSheet;
				BoardtopTab: TTabSheet;
	TitlePictureBrowser: TWebBrowser;
	BoardTop: TMenuItem;
	BoardInformationMemo: TMemo;
	GetSETTINGTXTAction: TAction;
	N3: TMenuItem;
	SETTINGTXT2: TMenuItem;
	GetTitlePictureAction: TAction;
	OP1: TMenuItem;
    GetHeadTXTAction: TAction;
    HeadTXT1: TMenuItem;
    RocalRuleTab: TTabSheet;
    WebBrowser1: TWebBrowser;
    CalcCapacityAction: TAction;
    N4: TMenuItem;
    N5: TMenuItem;
    LocalRule: TMenuItem;
    LocalEdit: TMemo;
    N6: TMenuItem;
    LocalRuleBrowse: TMenuItem;
    ToolButton4: TToolButton;
    ToolButton6: TToolButton;
    SaveNameMailAction: TAction;
    ToolButton7: TToolButton;
    BeLogInOutEAction: TAction;

		procedure EditorPageChange(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure BrowserStatusTextChange(Sender: TObject;
			const Text: WideString);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure FormDestroy(Sender: TObject);
		procedure SendActionExecute(Sender: TObject);
		procedure SaveActionExecute(Sender: TObject);
		procedure AbortActionExecute(Sender: TObject);
		procedure CloseActionExecute(Sender: TObject);
		procedure UndoActionExecute(Sender: TObject);
		procedure CutActionExecute(Sender: TObject);
		procedure CopyActionExecute(Sender: TObject);
		procedure PasteActionExecute(Sender: TObject);
		procedure SendActionUpdate(Sender: TObject);
		procedure SaveActionUpdate(Sender: TObject);
		procedure CloseActionUpdate(Sender: TObject);
		procedure UndoActionUpdate(Sender: TObject);
		procedure CutActionUpdate(Sender: TObject);
		procedure CopyActionUpdate(Sender: TObject);
		procedure PasteActionUpdate(Sender: TObject);
		procedure TopActionExecute(Sender: TObject);
		procedure TopActionUpdate(Sender: TObject);
		procedure SageCheckBoxClick(Sender: TObject);
		procedure MailComboBoxChange(Sender: TObject);
		procedure TransActionExecute(Sender: TObject);
		procedure TransActionUpdate(Sender: TObject);
		procedure IdLogDebugReceive(ASender: TIdConnectionIntercept;
			AStream: TStream);
		procedure IdLogDebugSend(ASender: TIdConnectionIntercept;
			AStream: TStream);
		procedure SelectAllActionExecute(Sender: TObject);
	procedure StatusBarResize(Sender: TObject);
	procedure Timer1Timer(Sender: TObject);
	procedure FormActivate(Sender: TObject);
	procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure QuotePasteActionExecute(Sender: TObject);
	procedure SpaceToNBSPActionExecute(Sender: TObject);
	procedure AmpToCharRefActionExecute(Sender: TObject);
	procedure BoardTopClick(Sender: TObject);
	procedure GetSETTINGTXTActionExecute(Sender: TObject);
	procedure GetTitlePictureActionUpdate(Sender: TObject);
	procedure GetTitlePictureActionExecute(Sender: TObject);
    procedure GetHeadTXTActionExecute(Sender: TObject);
	procedure CalcCapacityActionExecute(Sender: TObject);
    procedure LocalRuleClick(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure LocalRuleBrowseClick(Sender: TObject);
    procedure SaveNameMailActionExecute(Sender: TObject);
    procedure BeLogInOutEActionExecute(Sender: TObject);
    procedure BeLogInOutEActionUpdate(Sender: TObject);
	private
		FThreadItem: TThreadItem;
		FBoard: TBoard;
		FNameComboEdit: THandle;
		FMailComboEdit: THandle;
		FAbort: Boolean;
		FWork: Boolean;
		FStatusCode: Integer;
		FDebugStrReceive: string;
		FDebugStrSend: string;
		FSambaTime: TDateTime;
		FHost: string;
		FNow: TDateTime;
		FGestures	: TGestureModel;
		procedure Preview;
		function RepHtml(s: string): string;
		function Check: Boolean;
		procedure SetNameList(sName, sMail: string);
//		procedure Send(SendType: TGikoSendType; SPID: string; PON: string; FirstWriting: Boolean);
//		procedure Send(SPID: string; PON: string; FirstWriting: Boolean);
		procedure Send(ACOOKIE: string; SPID: string; PON: string; FirstWriting: Boolean);

		function GetActiveControlHandle: THandle;
//		function GetSendData: string;
//		procedure GetSendData(Source: TStringStream);
		procedure GetSendData(Source: TStringStream);
		procedure SaveSendFile;
		procedure SetContent(Content: string; ABrowser: TWebBrowser);
		function GetResultType(ResponseText: string): TGikoResultType;
		procedure ReadSambaTime(const AHost: string);
		procedure WriteSambaTime(const AHost: string; ATime: TDateTime);
		function ReadSettingTime(const AHost: string): Integer;
		function CheckSambaTime(const AHost: string; ATime: TDateTime): Boolean;
				procedure SetSamba24(AURL: string);
		/// p̎擾
		function GetOEIndentChar : string;
		/// {̎擾
		function GetBody : string;
		//IdHttp̏
		procedure InitIdHTTP(http: TIdHTTP);
		procedure ShowBoardInformation(ABoard: TBoard; AMemo: TMemo);
		function GetTitlePictureURL(body: TStringList; ABoard: TBoard): string;
		procedure ShowTitlePicture();
                function GetFusianaName(body: TStringList; ABoard: TBoard): String;
		//! }EXWFX`[Jn
		procedure OnGestureStart(Sender: TObject);
		//! }EXWFX`[
		procedure OnGestureMove(Sender: TObject);
		//! }EXWFX`[I
		procedure OnGestureEnd(Sender: TObject);
                //HEAD.TXT\
                procedure ShowBoardHead(ABoard: TBoard; AMemo: TMemo);
                //LocalFusianaTrapAlart
				function LFusianaGet(s: String): Boolean;
		// Cookie̎擾
		procedure GetCookie(Rawtext: String; ABoard: TBoard);
	protected
		procedure CreateParams(var Params: TCreateParams); override;
	public
				FBBSID: String;
		procedure SetFont;
		procedure SetThreadItem(Item: TThreadItem);
		procedure SetBoard(Item: TBoard);
				property BBSID: string read FBBSID write FBBSID;

	end;

implementation

uses
	Giko, ItemDownload, Gesture, IdGlobal;
const
	CAPTION_NAME_NEW: string = 'MRir XăGfB^';
	CAPTION_NAME_RES: string = 'MRir XGfB^';

    // GfBbgEBhEEɂ炵ĊJړ
    WINDOWMOVE_H = 30;
    WINDOWMOVE_V = 30;

	//DAXض!(LM)
	READCGI_ERR		 	= '-ERR';
	READCGI_INCR		= '-INCR';
	READCGI_OK			= '+OK';
	READCGI_PARTIAL = '+PARTIAL';
	READCGI_ERR_FOUND_KAKO	= '-ERR ߋOqɂŔ';
	READCGI_ERR_NOT_HTML		= '-ERR html҂';
	READCGI_ERR_NOT_FOUND	 	= '-ERR ȔorXbhȂłB';
	READCGI_ERR_ABONE			 	= '-ERR ǂłځ[񂪂݂łB';
	READCGI_ERR_TIMEOUT		 	= '-ERR w莞Ԃ߂܂B';
	READCGI_ERR_CANTUSE		 	= '-ERR @܂';
	RES2CH_TRUE			 	= '<!-- 2ch_X:true -->';
	RES2CH_FALSE			= '<!-- 2ch_X:false -->';
	RES2CH_ERROR			= '<!-- 2ch_X:error -->';
	RES2CH_CHECK			= '<!-- 2ch_X:check -->';
	RES2CH_COOKIE		 	= '<!-- 2ch_X:cookie -->';


        BBS2CH_NAME:					 string	= 'Q˂';
	BBS2CH_LOG_FOLDER:		 string	= '2ch';
	EXTERNAL_LOG_FOLDER:		string	= 'exboard';

	FOLDER_INI_FILENAME:	 string	= 'Folder.ini';
	FOLDER_INDEX_FILENAME: string	= 'Folder.idx';
	SUBJECT_FILENAME:			string	= 'subject.txt';
	PATH_DELIM:						string	= '\';


type
	TSelection = record
		StartPos, EndPos: Integer;
	end;

{$R *.DFM}

{constructor TEditorForm.Create(AOwner: TComponent; Item: TBoard);
begin
	inherited Create(AOwner);
end;}

procedure TEditorForm.CreateParams(var Params: TCreateParams);
begin
	inherited;
	if FormStyle in [fsNormal, fsStayOnTop] then
		if BorderStyle in [bsSingle, bsSizeable] then begin
			Params.ExStyle := Params.ExStyle or WS_EX_APPWINDOW;
			Params.WndParent := 0;
		end;
end;

{procedure TEditorForm.CreateParams(var Params: TCreateParams);
begin
	inherited CreateParams(Params);
	Params.ExStyle := Params.ExStyle or WS_EX_APPWINDOW;
end;}

procedure TEditorForm.FormCreate(Sender: TObject);
var
	wp: TWindowPlacement;
		hUser32 : HINST;
        ini: TIniFile;
begin
	FWork := False;
	Browser.Navigate('about:blank');
	TitlePictureBrowser.Navigate('about:blank');
	FBoard := nil;
	FThreadItem := nil;

	//EBhËʒuݒ
	wp.length := sizeof(wp);
	wp.rcNormalPosition.Top := GikoSys.Setting.EditWindowTop;
	wp.rcNormalPosition.Left := GikoSys.Setting.EditWindowLeft;

	wp.rcNormalPosition.Bottom := GikoSys.Setting.EditWindowTop + GikoSys.Setting.EditWindowHeight;
	wp.rcNormalPosition.Right := GikoSys.Setting.EditWindowLeft + GikoSys.Setting.EditWindowWidth;
	wp.showCmd := SW_HIDE;
	SetWindowPlacement(Handle, @wp);

	if GikoSys.Setting.EditWindowMax then
		WindowState := wsMaximized;

	//EBhEʊOȂʓɈړ
	if (Left + Width) > Screen.Width then
//		Left := Screen.Width - Width;
		Left := 0;
	if (Top + Height) > Screen.Height then
//		Top := Screen.Height - Height;
		Top := 0;
	if Left < 0 then
		Left := 0;
	if Top < 0 then
		Top := 0;

    //݂̃EBhËʒuۑ
    GikoSys.Setting.EditWindowTop := Top  + WINDOWMOVE_V;   // ɊJEBhE
    GikoSys.Setting.EditWindowLeft := Left + WINDOWMOVE_H;  // @@@E΂߉ɂ炷
    //EBhE̕ƍΌɖ߂
	if GikoSys.Setting.EditWindowHeight < 144 then
		Height := 400;
	if GikoSys.Setting.EditWindowWidth < 144 then
		Width := 640;

	EditorPage.ActivePage := EditorTab;
	FNameComboEdit := GetWindow(NameComboBox.Handle, GW_CHILD);
	FMailComboEdit := GetWindow(MailComboBox.Handle, GW_CHILD);
	NameComboBox.Items.Assign(GikoSys.Setting.NameList);
	MailComboBox.Items.Assign(GikoSys.Setting.MailList);
	SetFont;
	hUser32 := 0;
	try
		try
			hUser32 := LoadLibrary('User32.dll');
			if hUser32 <> 0 then
				TransAction.Enabled := true
			else
				TransAction.Enabled := false;
		except
        	TransAction.Enabled := false;
		end;
	finally
		FreeLibrary(hUser32);
	end;

    // EBhẼXeC
	if GikoSys.Setting.EditWindowStay then begin    // XeC
		SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
		TopAction.Checked := true;
		TopToolButton.Down := true;
	end else begin                                  // XeCȂ
		SetWindowPos(Handle, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
		TopAction.Checked := false;
		TopToolButton.Down := false;
	end;

    // EBhE̔
	if(GikoSys.Setting.EditWindowTranslucent) and (TransAction.Enabled) then begin // igX[Zgj
        AlphaBlend := true;
        TransAction.Checked := true;
        TransToolButton.Down := true;
    end else begin                                      // s
        AlphaBlend := false;
        TransAction.Checked := false;
        TransToolButton.Down := false;
    end;
        // Ԃ̕ۑ
	GikoSys.Setting.EditWindowTranslucent := TransAction.Checked;

	SpaceToNBSPAction.Checked		:= GikoSys.Setting.SpaceToNBSP;
	AmpToCharRefAction.Checked	:= GikoSys.Setting.AmpToCharRef;

		ini := TIniFile.Create(GikoSys.Setting.GetFileName);

		try
			BoardtopTab.TabVisible := ini.Readbool('EditorForm', 'BoardTopTab', False);
			BoardTop.Checked := BoardtopTab.TabVisible;
                        RocalRuleTab.TabVisible := ini.ReadBool('EditorForm', 'LocalRuleTab', False);
                        LocalRule.Checked := RocalRuleTab.TabVisible;
		finally
			ini.Free;
		end;

	// }EXWFX`[̃CXg[
	if GikoSys.Setting.GestureEnabled then begin
		MouseGesture.UnHook;
		FGestures := TGestureModel.Create;
		FGestures.LoadGesture(
			GikoSys.Setting.GetGestureFileName, ActionList );
		MouseGesture.OnGestureStart := OnGestureStart;
		MouseGesture.OnGestureMove := OnGestureMove;
		MouseGesture.OnGestureEnd := OnGestureEnd;
		MouseGesture.SetHook( Handle );
	end;
	SaveNameMailAction.Checked := True;
end;

procedure TEditorForm.SetBoard(Item: TBoard);
begin
	FBoard := Item;
	Caption := CAPTION_NAME_NEW + ' - [' + Item.Title + ']';
	NameComboBox.Text := FBoard.KotehanName;
	MailComboBox.Text := FBoard.KotehanMail;
	SageCheckBox.Checked := AnsiPos('sage', MailComboBox.Text) <> 0;
	TitlePanel.Visible := True;
	SetSamba24(FBoard.URL);
	ShowBoardInformation(FBoard, BoardInformationMemo);
	ShowTitlePicture();
end;

procedure TEditorForm.SetThreadItem(Item: TThreadItem);
begin
	FThreadItem := Item;
	Caption := CAPTION_NAME_RES + ' - [' + FThreadItem.Title + ']';
	NameComboBox.Text := FThreadItem.ParentBoard.KotehanName;
	MailComboBox.Text := FThreadItem.ParentBoard.KotehanMail;
	SageCheckBox.Checked := AnsiPos('sage', MailComboBox.Text) <> 0;
	TitlePanel.Visible := False;
	SetSamba24(FThreadItem.ParentBoard.URL);
	ShowBoardInformation(FThreadItem.ParentBoard, BoardInformationMemo);
	ShowTitlePicture();
end;

function TEditorForm.GetBody : string;
var
	body, tmp		: string;
	p, tail			: PChar;
	len					: Integer;
const
	TAB_LENGTH	= 4;
begin

	body := BodyEdit.Text;
	if AmpToCharRefAction.Checked then
		// & ̒u͈ԍŏɂ邱
		body := CustomStringReplace( body, '&', '&amp;' );
	if SpaceToNBSPAction.Checked then begin
		p			:= PChar( body );
		tail	:= p + Length( body );
		len		:= 0;
		while p < tail do begin
			case p^ of
			#09:
				begin
					Inc( p );
					repeat
						Inc( len );
						tmp := tmp + '&nbsp;';
					until (len mod TAB_LENGTH) = 0;
				end;

			#10, #13:
				begin
					tmp := tmp + p^;	Inc( p );
					len	:= 0;
				end;

			' ':
				begin
					tmp	:= tmp + '&nbsp;';
					Inc( p );
					Inc( len );
				end;
				
			'&':
				// ̎QƂ 1 
				begin
					tmp := tmp + '&';
					Inc( p );
					Inc( len );
					while p < tail do begin
						if p^ in ['a'..'z', 'A'..'Z', '0'..'9', '#'] then begin
							tmp := tmp + p^;
						end else if p^ = ';' then begin
							tmp := tmp + p^;
							Inc( p );
							Break;
						end else begin
							Break;
						end;
						Inc( p );
					end;
				end;

			else
				if p^ in kYofKanji then begin
					tmp := tmp + p^;	Inc( p );
					tmp	:= tmp + p^;	Inc( p );
					len	:= len + 2;
				end else begin
					tmp := tmp + p^;	Inc( p );
					Inc( len );
				end;
			end;
		end;
		body := tmp;
	end;

	Result	:= body;

end;

procedure TEditorForm.SetFont;
begin
	BodyEdit.Font.Name := GikoSys.Setting.EditorFontName;
	BodyEdit.Font.Size := GikoSys.Setting.EditorFontSize;
	BodyEdit.Font.Color := GikoSys.Setting.EditorFontColor;
	BodyEdit.Color := GikoSys.Setting.EditorBackColor;
end;

procedure TEditorForm.Preview;
var
	Title: string;
	No: string;
	Mail: string;
	Namae: string;
	DateTime: string;
	Body: string;
	s: string;

				posTrip : Integer;
				tripOrigin : string;
begin
	if FThreadItem = nil then begin
		No := '1';
		Title := RepHtml(TitleEdit.Text);
	end else begin
		No := IntToStr(FThreadItem.Count + 1);
		Title := RepHtml(FThreadItem.Title);
	end;

	body := GetBody;
	Namae := RepHtml(NameComboBox.Text);
	Mail := RepHtml(MailComboBox.Text);
	Body := RepHtml(body);
	Body := StringReplace(Body, #13#10, '<br>', [rfReplaceAll]);
	DateTime := FormatDateTime('yyyy/mm/dd(aaa) hh:nn', now);

	if Trim(Namae) = '' then
		Namae := '';

	s := '<HTML><HEAD>' + #13#10
			+ '<META http-equiv="Content-Type" content="text/html; charset=Shift_JIS">' + #13#10
			+ '<TITLE>' + title + '</TITLE>' + #13#10
//			+ '<STYLE><!--BODY{font-size : 9pt;font-family : "lr oSVbN";}--></STYLE>' + #13#10
			+ '</HEAD>' + #13#10
			+ '<BODY text="#000000" bgcolor="#EFEFEF" link="#0000FF" alink="#FF0000" vlink="#660099">' + #13#10
			+ '<FONT COLOR="#FF0000">' + title + '</FONT>' + #13#10
			+ '<DL>' + #13#10;
				posTrip := AnsiPos( '#', Namae );
				if posTrip > 0 then
				begin
								tripOrigin := Copy( Namae, posTrip + 1, Length( Namae ) );
								Namae :=
												Copy( Namae, 1, posTrip - 1 ) + '</B> ' +
												get_2ch_trip( PChar( tripOrigin ) ) + '<B>';
				end;
	if Mail = '' then
		s := s + '<DT>' + No + ' F <FONT color="forestgreen"><B>' + Namae + '</B></FONT> F ' + DateTime+ '<BR><DD>' + Body + '<BR><BR><BR>' + #13#10
	else
		s := s + '<DT>' + No + ' F <A href="mailto:' + Mail + '"><B>' + Namae + '</B></A> [' + Mail + ']F ' + DateTime+ '<BR><DD>' + Body + '<BR><BR><BR>' + #13#10;
	s := s + '</BODY></HTML>';
	SetContent(s, Browser);
end;

function TEditorForm.RepHtml(s: string): string;
begin
//	s := StringReplace(s, '&', '&amp;', [rfReplaceAll]);
	s := StringReplace(s, '<', '&lt;', [rfReplaceAll]);
	s := StringReplace(s, '>', '&gt;', [rfReplaceAll]);
//	s := StringReplace(s, ' ', '&nbsp;', [rfReplaceAll]);	//dlύXɂ&nbsp;gps
	s := StringReplace(s, '"', '&quot;', [rfReplaceAll]);
	Result := s;
end;

procedure TEditorForm.EditorPageChange(Sender: TObject);
var
        tmpBoard: TBoard;
begin
	if FThreadItem = nil then
		tmpBoard := FBoard
	else
		tmpBoard := FThreadItem.ParentBoard;

	if tmpBoard = nil then Exit;

	if EditorPage.ActivePage = PreviewTab then begin
		Preview;
	end else if EditorPage.ActivePage = RocalRuleTab then begin
                if not FileExists(tmpBoard.GETHEADTXTFileName) then begin
                        LocalEdit.Text := '[J[擾';
                        Exit;
                end;
                ShowBoardHead(tmpBoard, LocalEdit);
        end else begin
		Browser.Navigate('about:blank');
	end;
end;

procedure TEditorForm.BrowserStatusTextChange(Sender: TObject;
	const Text: WideString);
begin
	if EditorPage.ActivePage = PreviewTab then begin
		StatusBar.Panels[0].Text := Text;
	end else begin
		StatusBar.Panels[0].Text := '';
	end;
end;

function TEditorForm.Check: Boolean;
var
	Msg: string;
	rc: Integer;
	Board: TBoard;
begin
	Result := True;
	if FThreadItem = nil then
		Board := FBoard
	else
		Board := FThreadItem.ParentBoard;

	if (not GikoSys.Setting.UseMachineTime) and
		 ((Board.LastGetTime = 0) or
			(Board.LastGetTime = ZERO_DATE)) then begin
		Msg := 'T[o̎Ȃ߁AMo܂'#13#10
				 + 'XbhXVi擾jA15b҂Ă瑗MĂ';
		MsgBox(Handle, Msg, 'G[', MB_OK or MB_ICONSTOP);
		Result := False;
	end else if BodyEdit.Text = '' then begin
		Msg := '{͂Ă܂B';
		MsgBox(Handle, Msg, 'G[', MB_OK or MB_ICONSTOP);
		Result := False;
	end else if (FBoard <> nil) and (Trim(TitleEdit.Text) = '') then begin
		Msg := '^Cg͂Ă܂B';
		MsgBox(Handle, Msg, 'G[', MB_OK or MB_ICONSTOP);
		Result := False;
	end else begin
		if (not GikoSys.Dolib.Connected) and (AnsiPos('', NameComboBox.Text) <> 0) then begin
			Msg := 'OCĂȂ̂Ł̋@\͗po܂B'#13#10
					 + '̂܂ܑMĂ낵łH';
			rc := MsgBox(Handle, Msg, 'mF', MB_YESNO or MB_ICONQUESTION);
			Result := (rc = IDYES);
		end;
	end;
end;

procedure TEditorForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	Action := caFree;
end;

procedure TEditorForm.FormDestroy(Sender: TObject);
var
	wp: TWindowPlacement;
begin
	//ő剻EEBhEʒuۑ
	wp.length := sizeof(wp);
	GetWindowPlacement(Handle, @wp);

	GikoSys.Setting.EditWindowTop := wp.rcNormalPosition.Top;
	GikoSys.Setting.EditWindowLeft := wp.rcNormalPosition.Left;
	GikoSys.Setting.EditWindowHeight := wp.rcNormalPosition.Bottom - wp.rcNormalPosition.Top;
	GikoSys.Setting.EditWindowWidth := wp.rcNormalPosition.Right - wp.rcNormalPosition.Left;
	GikoSys.Setting.EditWindowMax := WindowState = wsMaximized;
	//GikoSys.Setting.EditWindowStay := FormStyle = fsStayOnTop;      // XeCԂ̕ۑ
	GikoSys.Setting.EditWindowTranslucent := TransAction.Checked;   // Ԃ̕ۑ

	FGestures.Free;

end;

procedure TEditorForm.SetNameList(sName, sMail: string);
begin
	if SaveNameMailAction.Checked then begin
		if Trim(sName) <> '' then begin
			if GikoSys.Setting.NameList.IndexOf(sName) = -1 then
				GikoSys.Setting.NameList.Insert(0, sName);
		end;
		if Trim(sMail) <> '' then begin
			if GikoSys.Setting.MailList.IndexOf(sMail) = -1 then
				GikoSys.Setting.MailList.Insert(0, sMail);
		end;
	end;
end;

function TEditorForm.GetActiveControlHandle: THandle;
begin
	if EditorPage.ActivePage = EditorTab then begin
		if ActiveControl = NameComboBox then
			Result := FNameComboEdit
		else if ActiveControl = MailComboBox then
			Result := FMailComboEdit
		else if ActiveControl = BodyEdit then
			Result := BodyEdit.Handle
		else if ActiveControl = TitleEdit then
			Result := TitleEdit.Handle
		else
			Result := 0;
	end else if Editorpage.ActivePage = BoardInformationTab then begin
		if ActiveControl = BoardInformationMemo then
			Result := BoardInformationMemo.Handle
		else
			Result := 0;
	end else
		Result := 0;
end;

procedure TEditorForm.SetContent(Content: string; ABrowser: TWebBrowser);
var
	doc: Variant;
begin
	if ABrowser.Document <> nil then begin
		doc := Idispatch( olevariant(ABrowser.ControlInterface).Document) as IHTMLDocument2;
		doc.Clear;
		doc.open;
		doc.charset := 'Shift_JIS';
		doc.Write(Content);
		doc.Close;
	end;
end;
procedure TEditorForm.InitIdHTTP(http: TIdHTTP);
begin
	http.Request.Clear;
	http.ProxyParams.BasicAuthentication := False;
	if GikoSys.Setting.WriteProxy then begin
		http.ProxyParams.ProxyServer := GikoSys.Setting.WriteProxyAddress;
		http.ProxyParams.ProxyPort := GikoSys.Setting.WriteProxyPort;
		http.ProxyParams.ProxyUsername := GikoSys.Setting.WriteProxyUserID;
		http.ProxyParams.ProxyPassword := GikoSys.Setting.WriteProxyPassword;
		if GikoSys.Setting.ReadProxyUserID <> '' then
			http.ProxyParams.BasicAuthentication := True;
	end else begin
		http.ProxyParams.ProxyServer := '';
		http.ProxyParams.ProxyPort := 80;
		http.ProxyParams.ProxyUsername := '';
		http.ProxyParams.ProxyPassword := '';
	end;
	Indy.Request.UserAgent := GikoSys.GetUserAgent;
	Indy.Request.AcceptEncoding := '';
end;

procedure TEditorForm.Send(ACOOKIE: string; SPID: string; PON: string; FirstWriting: Boolean);
var
	TextStream: TStringStream;
	Source: TStringStream;
	ResponseText: string;
	URL: string;
	RefURL: string;
	State: TGikoDownloadState;
	ResultType: TGikoResultType;
	MsgResult: Integer;
	Cookie: string;
	Board: TBoard;
	sysMenu	: HMENU;
	//fusianasangbv by
	Namae : String;
	body : TStringList;
	Remote : String;
	ABoard : TBoard;
	tmpRawheader: string;
    {Protocol,Host, Path, Document, Port, Bookmark : String;}
begin
	FAbort := False;
	State := gdsError;
	Namae := RepHtml(NameComboBox.Text);
	if FThreadItem = nil then
		Board := FBoard
	else
		Board := FThreadItem.ParentBoard;


    tmpRawheader := '';
	InitIdHTTP(Indy);
	if FThreadItem = nil then begin
		URL := FBoard.GetSendURL;
		RefURL := GikoSys.UrlToServer(FBoard.URL) + 'test/bbs.cgi';
	end else begin
		URL := FThreadItem.GetSendURL;
		RefURL := FThreadItem.URL;
	end;
//	Indy.Request.UserAgent := GikoSys.GetUserAgent;
	Indy.Request.Referer := RefURL;
//	Indy.Request.AcceptEncoding := '';

	Cookie := '';
	if ACOOKIE <> '' then
       Cookie := ACOOKIE;
	if SPID <> '' then
		Cookie := Cookie + 'SPID=' + SPID + '; ';
	if PON <> '' then
		Cookie := Cookie + 'PON=' + PON + '; ';

	//zXg2chŁABeLoginĂBẼf[^𑗂
	//GikoSys.ParseURI( URL, Protocol,Host, Path, Document, Port, Bookmark );
	//if GikoSys.Is2chHost(Host) and GikoSys.Setting.BeLogin then
	if (Board.Is2ch) and (GikoSys.Setting.BeLogin) then
	    Cookie := Cookie + 'MDMD=' + GikoSys.Setting.BeCode + '; '
    			+ 'DMDM=' + GikoSys.Setting.BeUserID + '; ';
	Cookie := 'Cookie: ' + Cookie + 'NAME=' + NameComboBox.Text + '; MAIL=' + MailComboBox.Text;

	sysMenu := GetSystemMenu( Handle, false );
	EnableMenuItem( sysMenu, SC_CLOSE, MF_GRAYED );
{
  EnableMenuItem(SysMenu, SC_CLOSE, MF_BYCOMMAND or MF_ENABLED);
  DrawMenuBar(Handle);
}
	Indy.Request.CustomHeaders.Clear;
//	Indy.Request.CacheControl := 'no-cache';
	Indy.Request.CustomHeaders.Add('Pragma: no-cache');
	Indy.Request.AcceptLanguage := 'ja';
	Indy.Request.Accept := 'image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*';
	Indy.Request.ContentType := 'application/x-www-form-urlencoded';
	Indy.Request.CustomHeaders.Add(Cookie);
	TextStream := TStringStream.Create('');
	Source := TStringStream.Create('');
	try
		try
			FDebugStrReceive := '';
			FDebugStrSend := '';
			GetSendData(Source);
			Indy.Post(URL, Source, TextStream);
			ResponseText := TextStream.DataString;

			ResultType := GetResultType(ResponseText);

			//MsgResult
			MsgResult := IDNO;
			//tVAigbvx(LocalMode) by 
                        if GikoSys.Setting.LocalTrapAtt then begin
                                if LFusianaGet(Namae) then begin
				        MsgResult := MsgBox(
					        	Handle,
					        '[gzXg\@\gĂ܂' + #13#10 +
					        'ԈĂ̕@ŃzXg\ꂽƂĂAȐӔCȂ̂ō폜˗ɂ͉܂B' + #13#10#13#10 +
					        'ӔC𕉂Ƃď݂܂H',
					        '',
					        MB_YESNO or MB_ICONQUESTION);
				        if MsgResult = IDNO  then begin
					        Board.SPID := '';
					        Board.PON := '';
					        FWork := false;
					        EnableMenuItem(SysMenu, SC_CLOSE, MF_BYCOMMAND or MF_ENABLED);
					        DrawMenuBar(Handle);
					        Exit;
                                        end;
                                end;
			        if ((Namae = 'R') or (Namae = 'fusianasan')) then begin
				        MsgResult := MsgBox(
					        	Handle,
					        '[gzXg\@\gĂ܂' + #13#10 +
					        'ԈĂ̕@ŃzXg\ꂽƂĂAȐӔCȂ̂ō폜˗ɂ͉܂B' + #13#10#13#10 +
					        'ӔC𕉂Ƃď݂܂H',
					        '',
					        MB_YESNO or MB_ICONQUESTION);
				        if MsgResult = IDNO  then begin
					        Board.SPID := '';
					        Board.PON := '';
					        FWork := false;
					        EnableMenuItem(SysMenu, SC_CLOSE, MF_BYCOMMAND or MF_ENABLED);
					        DrawMenuBar(Handle);
					        Exit;
				        end;
			        end;
                        end;

                        if GikoSys.Setting.RemoteTrapAtt then begin
                        	if FThreadItem = nil then
		                        ABoard := FBoard
	                        else
		                        ABoard := FThreadItem.ParentBoard;

	                        if ABoard = nil then Exit;

                                if FileExists(ABoard.GetSETTINGTXTFileName)  then begin
                                        body := TStringList.Create;
                                        try
                                                body.LoadFromFile(ABoard.GetSETTINGTXTFileName);
                                                Remote := GetFusianaName(body, ABoard);
                                        finally
                                                body.Free;
                                        end;
                                end;

                                //Setting.txtȂ擾
                                //Iɕׂ肻ŕ|EEE
                                if not FileExists(ABoard.GetSETTINGTXTFileName) then begin
                                        //GetSETTINGTXTActionĂяoIndŷŁA
										//CookieۑȂĂ͂Ȃ
										tmpRawheader := Indy.Response.RawHeaders.Text;
										GetSETTINGTXTAction.Execute;
										body := TStringList.Create;
										try
                                                body.LoadFromFile(ABoard.GetSETTINGTXTFileName);
                                                Remote := GetFusianaName(body, ABoard);
                                        finally
                                                body.Free;
                                        end;
                                end;

                                if Remote = 'fusianasan' then begin
				        MsgResult := MsgBox(
					        	Handle,
					        '[gzXg\@\gĂ܂' + #13#10 +
					        'ԈĂ̕@ŃzXg\ꂽƂĂAȐӔCȂ̂ō폜˗ɂ͉܂B' + #13#10#13#10 +
					        'ӔC𕉂Ƃď݂܂H',
					        '',
					        MB_YESNO or MB_ICONQUESTION);
				        if MsgResult = IDNO  then begin
					        Board.SPID := '';
					        Board.PON := '';
					        FWork := false;
					        EnableMenuItem(SysMenu, SC_CLOSE, MF_BYCOMMAND or MF_ENABLED);
					        DrawMenuBar(Handle);
					        Exit;
				        end;
                                end;
                        end;

			if ResultType = grtOK then begin
                if GikoSys.Setting.UseSamba then
					WriteSambaTime(FHost, Now());
				State := gdsComplete;
			end else if ResultType = grtCookie then begin
				//[vh~
				if not FirstWriting then
					raise Exception.Create('');
				MsgResult := MsgBox(
					Handle,
					'Eeꂽe̓Rs[AۑApA]ړꍇ܂B' + #13#10 +
					'EeɊւĔӔC͑Sēe҂ɋA܂B' + #13#10#13#10 +
					'SӔC𕉂Ƃď݂܂H',
					'',
					MB_YESNO or MB_ICONQUESTION);
				if MsgResult = IDYES then begin
					if (GikoSys.Setting.RemoteTrapAtt) and (tmpRawheader <> '') then begin
						GetCookie(tmpRawheader, Board);
					end else begin
						GetCookie(Indy.Response.RawHeaders.Text, Board);
					end;
					if (Board.SPID = '') and (Board.PON = '') and (Board.Cookie = '') then
						raise Exception.Create('');
					//񂱂̃\bh
					Send(Board.Cookie, Board.SPID, Board.PON, False);
					Exit;
				end else begin
					Board.SPID := '';
					Board.PON := '';
					FWork := false;
					EnableMenuItem(SysMenu, SC_CLOSE, MF_BYCOMMAND or MF_ENABLED);
					DrawMenuBar(Handle);
					Exit;
				end;
			end else if ResultType = grtCheck then begin
				//
				//[vh~
				if not FirstWriting then
					raise Exception.Create('');

				MsgResult := MsgBox(
					Handle,
					'݂ɊւĂ͗lXȃO񂪋L^Ă܂B' + #13#10 +
					'eɊւĔӔC͑Sēe҂ɋA܂B' + #13#10 +
					'ǑɔAlɖf鏑݂͍TĉB' + #13#10 +
					'eꂽe̓Rs[EۑEpE]ړꍇ܂B' + #13#10 +
					#13#10 +
					'SӔC𕉂Ƃď݂܂H',
					'mF',
					MB_YESNO or MB_ICONQUESTION);

				if MsgResult = IDYES then begin
                    if (GikoSys.Setting.RemoteTrapAtt) and (tmpRawheader <> '') then begin
						GetCookie(tmpRawheader, Board);
					end else begin
						GetCookie(Indy.Response.RawHeaders.Text, Board);
                    end;
					if (Board.SPID = '') and (Board.PON = '') and (Board.Cookie = '') then
						raise Exception.Create('');
					Send(Board.Cookie, Board.SPID, Board.PON, False);
					Exit;
				end else begin
					EnableMenuItem(SysMenu, SC_CLOSE, MF_BYCOMMAND or MF_ENABLED);
					DrawMenuBar(Handle);
					Board.SPID := '';
					Board.PON := '';
					FWork := false;
					Exit;
				        end;
			        end else begin
                        if GikoSys.Setting.UseSamba then
                    		WriteSambaTime(FHost, Now());
				        State := gdsError;
				        raise Exception.Create('');
			        end;

		except
			on E: EIdConnectException do begin
				State := gdsError;
				ResponseText := '<html><body>'
											+ '<div>ڑs܂<br>'
											+ 'vLV̏Ԃ𒲂ׂĂ<br></div>'
											+ '<br><br><div>' + E.Message + '</div>'
											+ '</body></html>';
			end;
			on E: Exception do begin
				State := gdsError;

				FDebugStrReceive := AnsiReplaceText(FDebugStrReceive, '<', '&lt;');
				FDebugStrReceive := AnsiReplaceText(FDebugStrReceive, '>', '&gt;');
				FDebugStrSend := AnsiReplaceText(FDebugStrSend, '<', '&lt;');
				FDebugStrSend := AnsiReplaceText(FDebugStrSend, '>', '&gt;');

				ResponseText := '<html><body>' + TextStream.DataString;
				ResponseText := AnsiReplaceText(ResponseText, '</body>', '');
				ResponseText := AnsiReplaceText(ResponseText, '</html>', '');
				ResponseText := ResponseText + '<hr><div align="left"><pre>';
				ResponseText := ResponseText + '<b>MRiȑ</b>'#13#10;
				ResponseText := ResponseText + #13#10'M'#13#10;
				ResponseText := ResponseText + FDebugStrSend;
				ResponseText := ResponseText + #13#10'M'#13#10;
				ResponseText := ResponseText + FDebugStrReceive;
				ResponseText := ResponseText + '</pre></div></body></html>';
			end;
		end;
		FStatusCode := Indy.ResponseCode;
		if FAbort then
			State := gdsAbort;
	finally
		Source.Free;
		TextStream.Free;
		//sysMenu := GetSystemMenu( Handle, true );
		EnableMenuItem(SysMenu, SC_CLOSE, MF_BYCOMMAND or MF_ENABLED);
		DrawMenuBar(Handle);
	end;
	FWork := false;
    //MRirȂǂ̃XNvgp
    //ResponceCode302Foundŏ݊
    if FStatusCode = 302 then begin
        GikoForm.PlaySound('ResEnd');
        SaveSendFile;
		if FThreadItem = nil then
			GikoForm.AddMessageList(FBoard.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmNewSure)), nil, gmiOK)
		else
			GikoForm.AddMessageList(FThreadItem.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmNewRes)), nil, gmiOK);
        Close;
        Exit;
    end;
	if State = gdsComplete then begin
		GikoForm.PlaySound('ResEnd');
		SaveSendFile;
		if FThreadItem = nil then
			GikoForm.AddMessageList(FBoard.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmNewSure)), nil, gmiOK)
		else
			GikoForm.AddMessageList(FThreadItem.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmNewRes)), nil, gmiOK);
		Close;
	end else if State = gdsError then begin
		if FThreadItem = nil then
			GikoForm.AddMessageList(FBoard.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmNewSure)), nil, gmiOK)
		else
			GikoForm.AddMessageList(FThreadItem.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmNewRes)), nil, gmiOK);

		EditorPage.ActivePage := PreviewTab;
		SetContent(ResponseText, Browser);
	end else if State = gdsAbort then begin
        GikoForm.AddMessageList(FThreadItem.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmAbort)), nil, gmiSAD);
	end;
end;

function TEditorForm.GetResultType(ResponseText: string): TGikoResultType;
begin
	if AnsiPos('݂I܂', ResponseText) <> 0 then
		Result := grtOK
	else if (AnsiPos('NbL[Ȃ؂ł', ResponseText) > 0) or
					(AnsiPos('<title>NbL[mFI</title>', ResponseText) > 0)	or
					(AnsiPos('<title>NbL[mFI</title>', ResponseText) > 0)	or
					//(AnsiPos('NbL[mF', ResponseText) > 0) or
					(AnsiPos(RES2CH_COOKIE, ResponseText) > 0)	then
		Result := grtCookie
	else if (AnsiPos('<font size=+2 color=#FF0000>݃`FbNI </font>', ResponseText) > 0)	or
					(AnsiPos('<title> ݊mF܂ </title>', ResponseText) > 0)	or
					(AnsiPos('<title>emF</title>', ResponseText) > 0)	or
					(AnsiPos('<b>݊mF</b>', ResponseText) > 0)	or
					(AnsiPos('="../test/subbbs.cgi">', ResponseText) > 0)	or
					(AnsiPos(RES2CH_FALSE, ResponseText) > 0)	then
		Result := grtCheck
	else if (AnsiPos('Ee҂́Af^c҂ɑ΂āAҐli؍sgȂƂ܂B<br>', ResponseText) > 0) or
                                        (AnsiPos('i쌠@21Ȃ28ɋK肳錠܂ށj̑̌ɂA', ResponseText) > 0) then
                Result := grtCookie
        else
                Result := grtError;
end;


procedure TEditorForm.GetSendData(Source: TStringStream);
var
	SessionID: string;
	s: string;
	SendTime: Integer;
	Adjust: Integer;
	Board: TBoard;
	body		: string;
begin
	if FThreadItem = nil then
		Board := FBoard
	else
		Board := FThreadItem.ParentBoard;

	if GikoSys.Setting.UseMachineTime then begin
		if GikoSys.Setting.TimeAdjust then
			Adjust := Gikosys.Setting.TimeAdjustSec
		else
			Adjust := GikoSys.Setting.TimeAdjustSec * -1;
		SendTime := GikoSys.DateTimeToInt(Now) - (9 * 60 * 60) + Adjust
	end else begin
		if (Board.LastGetTime = 0) or (Board.LastGetTime = ZERO_DATE) then
			SendTime := GikoSys.DateTimeToInt(Now)
		else
			SendTime := GikoSys.DateTimeToInt(Board.LastGetTime);
	end;

	body := GetBody;

	SessionID := GikoSys.Dolib.SessionID;
	if SessionID <> '' then
		s := 'sid=' + HttpEncode(SessionID) + '&'
	else
		s := '';
	s := s + 'subject=&'
				 + 'FROM=' + HttpEncode(NameComboBox.Text) + '&'
				 + 'mail=' + HttpEncode(MailComboBox.Text) + '&'
				 + 'MESSAGE=' + HttpEncode(body) + '&'
				 + 'bbs=' + Board.BBSID + '&'
				 + 'time=' + IntToStr(SendTime) + '&';
	if FThreadItem = nil then begin
		s := s + 'subject=' + HttpEncode(TitleEdit.Text) + '&';
		s := s + 'submit=' + HttpEncode('SӔC𕉂Ƃď') + #13#10;
	end else begin
		s := s + 'key=' + ChangeFileExt(FThreadItem.FileName, '') + '&';
		s := s + 'submit=' + HttpEncode('') + #13#10;
	end;
	Source.WriteString(s);
end;

procedure TEditorForm.SaveSendFile;
var
	sDate: string;
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GikoSys.GetSentFileName);
	try
		sDate := IntToStr(GikoSys.DateTimeToInt(Now));

		ini.WriteString(sDate, 'Name', NameComboBox.Text);
		ini.WriteString(sDate, 'EMail', MailComboBox.Text);
		ini.WriteString(sDate, 'Body', HttpEncode(BodyEdit.Text));
		ini.WriteInteger(sDate, 'Status', FStatusCode);
		ini.WriteDateTime(sDate, 'Date', Now);
		if FThreadItem = nil then begin
			ini.WriteString(sDate, 'Title', TitleEdit.Text);
			ini.WriteString(sDate, 'BBS', FBoard.BBSID);
			ini.WriteInteger(sDate, 'NewThread', 1);
		end else begin
			ini.WriteString(sDate, 'Title', FThreadItem.Title);
			ini.WriteString(sDate, 'BBS', FThreadItem.ParentBoard.BBSID);
			ini.WriteString(sDate, 'Key', ChangeFileExt(FThreadItem.FileName, ''));
		end;

		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

procedure TEditorForm.SendActionExecute(Sender: TObject);
var
	Board: TBoard;
	rc: Integer;
        rc2: Integer;
	state : TGikoDownloadState;
	body		: string;
begin
	if FWork then
		Exit;
	try
		FWork := True;
		SendAction.Enabled := False;
		Application.ProcessMessages;
		if not Check then Exit;

		if FThreadItem = nil then
			Board := FBoard
		else
			Board := FThreadItem.ParentBoard;

		if FThreadItem = nil then begin
			rc := GikoUtil.MsgBox(Handle,
													'u' + Board.Title + 'vɐVXbhĂ܂'#13#10#13#10
													+ 'E̃[݂ł邱ƂmF܂H'#13#10
													+ 'Eɓ悤ȃXbhƂmF܂H'#13#10#13#10
													+ 'u͂vƑM܂',
													'mF',
													MB_ICONQUESTION or MB_YESNO);
			if rc <> ID_YES then
				Exit;
		end;

		SetNameList(NameComboBox.Text, MailComboBox.Text);
		if (KotehanCheckBox.Enabled) and (KotehanCheckBox.Checked) then begin
			Board.KotehanName := NameComboBox.Text;
			Board.KotehanMail := MailComboBox.Text;
		end;

		if Board.IsBoardPlugInAvailable then begin
			body := GetBody;

			if FThreadItem = nil then begin
				// X
				state := TGikoDownloadState( Board.BoardPlugIn.CreateThread(
					DWORD( Board ), TitleEdit.Text, NameComboBox.Text, MailComboBox.Text, body ) );

				if state = gdsComplete then begin
					GikoForm.PlaySound('ResEnd');
					SaveSendFile;
                    GikoForm.AddMessageList(FBoard.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmNewSure)), nil, gmiOK);
					FWork := False;
					Close;
				end else if State = gdsError then begin
                    GikoForm.AddMessageList(FBoard.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmSureError)), nil, gmiNG);
				end else if State = gdsAbort then begin
                    GikoForm.AddMessageList(FBoard.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmAbort)), nil, gmiNG);
				end;
			end else begin
				// X
				state := TGikoDownloadState( FThreadItem.ParentBoard.BoardPlugIn.WriteThread(
					DWORD( FThreadItem ), NameComboBox.Text, MailComboBox.Text, body ) );

				if state = gdsComplete then begin
					GikoForm.PlaySound('ResEnd');
					SaveSendFile;
                    GikoForm.AddMessageList(FThreadItem.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmNewRes)), nil, gmiOK);
                    FWork := False;
					Close;
				end else if State = gdsError then begin
                    GikoForm.AddMessageList(FThreadItem.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmResError)), nil, gmiOK);
				end else if State = gdsAbort then begin
                    GikoForm.AddMessageList(FThreadItem.Title + ' ' + GikoSys.Setting.GetMessage(Ord(gmAbort)), nil, gmiOK);
				end;
			end;
		end else begin
			if not Timer1.Enabled then begin
				if CompareDateTime(Board.Expires ,Now) <= 0 then begin
					Board.Cookie	:= '';
					Board.SPID      := '';
					Board.PON		:= '';
				end;
				Send(Board.Cookie, Board.SPID, Board.PON, True);
			end else begin
				if not CheckSambaTime(FHost, Now()) then begin
					rc := GikoUtil.MsgBox(Handle,
								'Samba24̋Kl̕bo߂Ă܂B'#13#10
								+ 'M𒆎~܂H' + #13#10
								+ '(uvƑM܂)', 'Samba24x',
								MB_YESNO or MB_ICONQUESTION);
					if rc = IDYES then begin
						FWork := false;
						Exit;
					end;
                                        if rc = IDNO then begin
                                                rc2 := GikoUtil.MsgBox(Handle,
                                                                       '{ɑM܂H',
                                                                       'Sumba24x',
                                                                       MB_YESNO or MB_ICONQUESTION);
                                                if rc2 = IDNO then begin
                                                        FWork := False;
                                                        Exit;
                                                end;
                                        end;
				end;
				if CompareDateTime(Board.Expires ,Now) <= 0 then begin
					Board.Cookie	:= '';
					Board.SPID      := '';
					Board.PON		:= '';
				end;
				Send(Board.Cookie, Board.SPID, Board.PON, True);
			end;
		end;
	finally
		FWork := False;
		if Timer1.Enabled then
			ReadSambaTime(FHost);
	end;
end;

procedure TEditorForm.SaveActionExecute(Sender: TObject);
begin
//
end;

procedure TEditorForm.CloseActionExecute(Sender: TObject);
begin
	Close;
end;

procedure TEditorForm.UndoActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, WM_UNDO, 0, 0);
end;

procedure TEditorForm.CutActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, WM_CUT, 0, 0);
end;

procedure TEditorForm.CopyActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, WM_COPY, 0, 0);
end;

procedure TEditorForm.PasteActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, WM_PASTE, 0, 0);
end;

procedure TEditorForm.SelectAllActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, EM_SETSEL, 0, GetWindowTextLength(GetActiveControlHandle));
end;

procedure TEditorForm.TopActionExecute(Sender: TObject);     // EBhEőO(Stay){^̏
begin
	if not (fsShowing in Self.FormState) then begin
		if TopAction.Checked then begin // XeCԂɐݒ
			SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
			GikoSys.Setting.EditWindowStay := true;
		end	else begin   // XeCԉ
			SetWindowPos(Handle, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
			GikoSys.Setting.EditWindowStay := false;
		end;
		// XeCԂ̕ۑ
		//GikoSys.Setting.EditWindowStay := FormStyle = fsStayOnTop;
	end;
end;

procedure TEditorForm.AbortActionExecute(Sender: TObject);
begin
	FAbort := True;
end;

procedure TEditorForm.SendActionUpdate(Sender: TObject);
begin
	SendAction.Enabled := not FWork;
end;

procedure TEditorForm.SaveActionUpdate(Sender: TObject);
begin
	SaveAction.Enabled := False;
end;

procedure TEditorForm.CloseActionUpdate(Sender: TObject);
begin
	CloseAction.Enabled := not FWork;
end;

procedure TEditorForm.UndoActionUpdate(Sender: TObject);
begin
	UndoAction.Enabled := (GetActiveControlHandle <> 0)
												and (SendMessage(GetActiveControlHandle, EM_CANUNDO, 0, 0) <> 0)
												and (not FWork);
end;

procedure TEditorForm.CutActionUpdate(Sender: TObject);
var
	Selection: TSelection;
	AHandle: THandle;
begin
	AHandle := GetActiveControlHandle;
	SendMessage(AHandle, EM_GETSEL, Longint(@Selection.StartPos), Longint(@Selection.EndPos));
	CutAction.Enabled := (AHandle <> 0)
										and ((Selection.EndPos - Selection.StartPos) <> 0)
										and (not FWork);
end;

procedure TEditorForm.CopyActionUpdate(Sender: TObject);
var
	Selection: TSelection;
	AHandle: THandle;
begin
	AHandle := GetActiveControlHandle;
	SendMessage(AHandle, EM_GETSEL, Longint(@Selection.StartPos), Longint(@Selection.EndPos));
	CopyAction.Enabled := (AHandle <> 0)
										and ((Selection.EndPos - Selection.StartPos) <> 0)
										and (not FWork);
end;

procedure TEditorForm.PasteActionUpdate(Sender: TObject);
begin
	PasteAction.Enabled := (GetActiveControlHandle <> 0)
											and (Clipboard.HasFormat(CF_TEXT))
											and (not FWork);
end;

procedure TEditorForm.TopActionUpdate(Sender: TObject);
begin
 	TopAction.Enabled := not FWork;
end;

procedure TEditorForm.SageCheckBoxClick(Sender: TObject);
begin
	if SageCheckBox.Checked then begin
		if AnsiPos('sage', MailComboBox.Text) = 0 then
			MailComboBox.Text := 'sage' + MailComboBox.Text;
	end else begin
		if AnsiPos('sage', MailComboBox.Text) <> 0 then
			MailComboBox.Text := StringReplace(MailComboBox.Text, 'sage', '', [rfReplaceAll]);
	end;
end;

procedure TEditorForm.MailComboBoxChange(Sender: TObject);
begin
	if AnsiPos('sage', MailComboBox.Text) = 0 then
		SageCheckBox.Checked := False
	else
		SageCheckBox.Checked := True;
end;

procedure TEditorForm.IdLogDebugReceive(ASender: TIdConnectionIntercept;
	AStream: TStream);
var
	StringStream: TStringStream;
begin
	StringStream := TStringStream.Create('');
	try
		StringStream.CopyFrom(AStream, AStream.Size);
		FDebugStrReceive := FDebugStrReceive + StringStream.DataString;
	finally
		StringStream.Free;
	end;
end;

procedure TEditorForm.IdLogDebugSend(ASender: TIdConnectionIntercept;
	AStream: TStream);
var
	StringStream: TStringStream;
begin
	StringStream := TStringStream.Create('');
	try
		StringStream.CopyFrom(AStream, AStream.Size);
		FDebugStrSend := FDebugStrSend + StringStream.DataString;
	finally
		StringStream.Free;
	end;
end;

procedure TEditorForm.TransActionExecute(Sender: TObject);
begin
	AlphaBlend := TransAction.Checked;
	// Ԃ̕ۑ
	GikoSys.Setting.EditWindowTranslucent := TransAction.Checked;
end;

procedure TEditorForm.TransActionUpdate(Sender: TObject);
begin
	TransAction.Enabled := not FWork;
end;
//StatusBarPanels[0]̕ρBcŒɂ
procedure TEditorForm.StatusBarResize(Sender: TObject);
begin
	StatusBar.Panels[0].Width := StatusBar.Width
									- StatusBar.Panels[1].Width - StatusBar.Panels[2].Width;

end;

procedure TEditorForm.Timer1Timer(Sender: TObject);
begin
	if FSambaTime = ZERO_DATE then
		StatusBar.Panels[1].Text := ''
	else begin
		FNow := IncMilliSecond(FNow, 500);
		StatusBar.Panels[1].Text := Format('%8.0fbo', [SecondSpan(FNow, FSambaTime)]);
	end;

end;
//Samba.inȉݎԂǂݍ
procedure TEditorForm.ReadSambaTime(const AHost: string);
var
	ini :TMemIniFile;
	tmp: string;
begin
	Timer1.Enabled := false; //oߕb\TimerOffɂiꂪON̂ƂSamba24΍Onj
	ini := TMemIniFile.Create(GikoSys.GetSambaFileName);
	try
		 //œǂݎāAϊ֐TDateTime
		 tmp := ini.ReadString('Send', AHost, DateTimeToStr(ZERO_DATE));
		 FSambaTime := ConvertDateTimeString(tmp);
	finally
		ini.Free;
	end;
	FNow := Now();   //ݎԂ擾iTimer\pŁACheckƂ͍ĂNow()Ăԁj
	Timer1.Enabled := true; //oߕb\TimerOnɂiꂪON̂ƂSamba24΍Onj
end;
//Samba.iniɍŏIݎԂ
procedure TEditorForm.WriteSambaTime(const AHost: string; ATime: TDateTime);
var
	ini :TMemIniFile;
begin
	ini := TMemIniFile.Create(GikoSys.GetSambaFileName);
	try
		ini.WriteDateTime('Send', AHost, ATime);
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;
//ŏIݎԂƌݎri^FKlȏ@UFKlj
function TEditorForm.CheckSambaTime(const AHost: string; ATime: TDateTime): Boolean;
var
	pastsec: double;
	SettingTime: Integer;
begin
	SettingTime := ReadSettingTime(AHost);
	ReadSambaTime(AHost);
	pastsec := SecondSpan(ATime, FSambaTime);
	if pastsec > SettingTime then
		Result := true
	else
		Result := false;
end;
//AHostiIjSamba̋Klǂݍ
function TEditorForm.ReadSettingTime(const AHost: string): Integer;
var
	ini :TMemIniFile;
begin
	ini := TMemIniFile.Create(GikoSys.GetSambaFileName);
	try
		Result := ini.ReadInteger('Setting', AHost, 0);
		//KlÔƂA͐ݒ肳ĂȂƂ́At@CɏB
		if Result = 0 then begin
			ini.WriteInteger('Setting', AHost, 0);
			ini.UpdateFile;
		end;
	finally
		ini.Free;
	end;
end;
//FormActiveɂȂŏIݎԂǂݍ
procedure TEditorForm.FormActivate(Sender: TObject);
begin
	if ( Timer1.Enabled ) and ( FThreadItem <> nil )then
		ReadSambaTime(FHost);
	if GikoSys.Setting.GestureEnabled then begin
		MouseGesture.UnHook;
		MouseGesture.OnGestureStart := OnGestureStart;
		MouseGesture.OnGestureMove := OnGestureMove;
		MouseGesture.OnGestureEnd := OnGestureEnd;
		MouseGesture.SetHook( Handle );
	end;
end;
//Samba24΍gǂ߂֐
//ReadSambaTime ĂяoTimerOnɂȂ
procedure TEditorForm.SetSamba24(AURL: string);
var
	Protocol, Host, Path, Document, Port, Bookmark : string;
begin
	//Samba24΍ȂȂI
	if not GikoSys.Setting.UseSamba then
		Exit;
	//HostURL'.2ch.''.bbspink.'܂܂ĂSamba24΍
	GikoSys.ParseURI( AURL, Protocol,Host, Path, Document, Port, Bookmark );
	if GikoSys.Is2chHost(Host) then begin
		Host := Copy(Host, 1, AnsiPos('.', Host) - 1);
		FHost := Host;   //FHost=I
		ReadSambaTime(FHost); //ȑȌݎԂǂݍ
		//StatusBarɂ̎I̋Kl\
		StatusBar.Panels[2].Text := 'Samba24Kl' + IntToStr(ReadSettingTime(FHost));
	end;
end;
procedure TEditorForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
	CanClose := not FWork;
end;

function TEditorForm.GetOEIndentChar : string;
var
	regKey			: TRegistry;
	Identities	: string;
	IndentChar	: DWORD;
const
	DEFAULT_CHAR	= '> ';
	OE_MAIL_PATH	= '\Software\Microsoft\Outlook Express\5.0\Mail';
	INDENT_CHAR		= 'Indent Char';
begin

	Result	:= DEFAULT_CHAR;
	regKey	:= TRegistry.Create;
	try
		try
			regKey.RootKey	:= HKEY_CURRENT_USER;
			if not regKey.OpenKey( 'Identities', False ) then
				Exit;
			Identities			:= regKey.ReadString( 'Default User ID' );
			if Identities = '' then
				Exit;
			if not regKey.OpenKey( Identities + OE_MAIL_PATH, False ) then
				Exit;
			IndentChar := regKey.ReadInteger( INDENT_CHAR );
			Result := Char( IndentChar ) + ' ';
		except
		end;
	finally
		regKey.Free;
	end;

end;

procedure TEditorForm.QuotePasteActionExecute(Sender: TObject);
var
	s			: TStringList;
	i			: Integer;
	quote	: string;
begin

	quote	:= GetOEIndentChar;
	s			:= TStringList.Create;
	try
		s.Text	:= Clipboard.AsText;

		for i := s.Count - 1 downto 0 do
			s[ i ]	:= quote + s[ i ];

		BodyEdit.SelText	:= s.Text;
	finally
		s.Free;
	end;

end;

procedure TEditorForm.SpaceToNBSPActionExecute(Sender: TObject);
begin
	GikoSys.Setting.SpaceToNBSP := SpaceToNBSPAction.Checked;
	if EditorPage.ActivePage = PreviewTab then
		Preview;
end;

procedure TEditorForm.AmpToCharRefActionExecute(Sender: TObject);
begin
	GikoSys.Setting.AmpToCharRef := AmpToCharRefAction.Checked;
	if EditorPage.ActivePage = PreviewTab then
		Preview;
end;

procedure TEditorForm.BoardTopClick(Sender: TObject);
var
	ini: TIniFile;
begin
	ini := TIniFile.Create(GikoSys.Setting.GetFileName);
	try
		BoardtopTab.TabVisible := BoardTop.Checked;
		ini.WriteBool('EditorForm', 'BoardTopTab', BoardtopTab.TabVisible);
	finally
		ini.Free;
	end;
end;


procedure TEditorForm.GetSETTINGTXTActionExecute(Sender: TObject);
var
	URL, RefURL: string;
	settingBody: TStringList;
	tmpBoard: TBoard;
begin
	InitIdHTTP(Indy);
	if FThreadItem = nil then
		tmpBoard := FBoard
	else
		tmpBoard := FThreadItem.ParentBoard;

	if tmpBoard = nil then Exit;

	RefURL	:= tmpBoard.URL;
	if RefURL[Length(RefURL)] <> '/' then
		URL	:= RefURL + '/' + 'SETTING.TXT'
	else
		URL	:= RefURL + 'SETTING.TXT';

	Indy.Request.LastModified := tmpBoard.SETTINGTXTTime;
	Indy.Request.Referer := RefURL;
	Screen.Cursor := crHourGlass;
	settingBody := TStringList.Create;
	try
		StatusBar.Panels[0].Text := 'SETTING.TXT_E[h';
		try
			settingBody.Text := Indy.Get(URL);
			if( Indy.ResponseCode = 200 ) then begin
				settingBody.SaveToFile(tmpBoard.GetSETTINGTXTFileName);
				tmpBoard.SETTINGTXTTime := Indy.Response.LastModified;
				tmpBoard.IsSETTINGTXT := true;
				tmpBoard.TitlePictureURL := GetTitlePictureURL(settingBody, tmpBoard);
				tmpBoard.Modified := true;
				StatusBar.Panels[0].Text := 'SETTING.TXT擾(' + IntToStr(Indy.ResponseCode) + ')';
			end;
		except
			on E: EIdException do begin
				if( AnsiPos('304', E.Message) > 0 ) then
					StatusBar.Panels[0].Text := 'SETTING.TXTXV(' + IntToStr(Indy.ResponseCode) + ')'
				else
					StatusBar.Panels[0].Text := 'SETTING.TXT擾G[(' + IntToStr(Indy.ResponseCode) + ')';
			end;
		end;
	finally
		settingBody.Free;
		Screen.Cursor := crDefault;
	end;
	ShowBoardInformation(tmpBoard, BoardInformationMemo);
end;

procedure TEditorForm.ShowBoardInformation(ABoard: TBoard; AMemo: TMemo);
var
	body: TStringList;
begin
	AMemo.Clear;
	AMemo.Lines.Add('[SETTING.TXT]');
	if ABoard.IsSETTINGTXT then begin
		if FileExists(ABoard.GetSETTINGTXTFileName)  then begin
			AMemo.Lines.Add(DateTimeToStr(ABoard.SETTINGTXTTime) + ' XV');
			body := TStringList.Create;
			try
				body.LoadFromFile(ABoard.GetSETTINGTXTFileName);
				AMemo.Lines.AddStrings(body);
			finally
				body.Free;
			end;
		end else begin
			ABoard.IsSETTINGTXT := false;
			ABoard.SETTINGTXTTime := ZERO_DATE;
			AMemo.Lines.Add('LocalɕۑꂽSETTING.TXT܂');
			AMemo.Lines.Add('j[Ď擾ĂB');
		end;
	end else begin
		AMemo.Lines.Add('SETTING.TXT擾Ă܂B');
		AMemo.Lines.Add('j[擾ĂB');
	end;
end;
function TEditorForm.GetTitlePictureURL(body: TStringList; ABoard: TBoard): string;
//BBS_TITLE_PICTURE=
//BBS_FIGUREHEAD=
var
	i: Integer;
	tmp: string;
begin
	Result := '';
	for i := 0 to body.Count - 1 do begin
		if (AnsiPos('BBS_TITLE_PICTURE=', body[i]) > 0) or
		   (AnsiPos('BBS_FIGUREHEAD=', body[i]) > 0) then begin
			tmp := body[i];
			Delete(tmp, 1, AnsiPos('=', tmp));
			if AnsiPos('../', tmp) > 0 then begin
				tmp := CustomStringReplace(tmp, '../', GikoSys.UrlToServer(ABoard.URL));
			end;
			Result := tmp;
			Exit;
		end;
	end;
end;

procedure TEditorForm.GetTitlePictureActionUpdate(Sender: TObject);
begin
	if FThreadItem = nil then
		GetTitlePictureAction.Enabled :=  FBoard.IsSETTINGTXT
	else
		GetTitlePictureAction.Enabled :=  FThreadItem.ParentBoard.IsSETTINGTXT;

end;

procedure TEditorForm.GetTitlePictureActionExecute(Sender: TObject);
var
	memStream: TMemoryStream;
	tmpBoard: TBoard;
begin
	InitIdHTTP(Indy);
	memStream := TMemoryStream.Create;
	try
		if FThreadItem = nil then
			tmpBoard := FBoard
		else
			tmpBoard := FThreadItem.ParentBoard;

		Indy.Request.Referer := tmpBoard.URL;
		if	tmpBoard.TitlePictureURL <> '' then begin
			StatusBar.Panels[0].Text := 'gbv摜_E[h';
			Screen.Cursor := crHourGlass;
			try
				Indy.Get(tmpBoard.TitlePictureURL, memStream);
				if Indy.ResponseCode = 200 then begin
					memStream.SaveToFile(tmpBoard.GetTitlePictureFileName);
					ShowTitlePicture();
					tmpBoard.Modified := true;
				end;
			except
			end;
		end;
	finally
		Screen.Cursor := crDefault;
		StatusBar.Panels[0].Text := 'gbv摜 (' + IntToStr(Indy.ResponseCode) + ')';
		memStream.Free;
	end;

end;
procedure TEditorForm.ShowTitlePicture();
var
	tmpBoard: TBoard;
	s: String;
begin
	if FThreadItem = nil then
		tmpBoard := FBoard
	else
		tmpBoard := FThreadItem.ParentBoard;

	if FileExists(tmpBoard.GetTitlePictureFileName) then begin
		TitlePictureBrowser.Navigate(tmpBoard.GetTitlePictureFileName);
	end else begin
		s := 'gbv摜擾łB<br>j[擾ĂB';
		SetContent(s, TitlePictureBrowser);
	end;
end;

function TEditorForm.GetFusianaName(body: TStringList; ABoard: TBoard): String;
var
	i: Integer;
	tmp: string;
begin
	for i := 0 to body.Count - 1 do begin
		if (AnsiPos('BBS_NONAME_NAME=', body[i]) > 0) then begin
			tmp := body[i];
			Delete(tmp, 1, AnsiPos('=', tmp));
			Result := tmp;
			Exit;
		end;
	end;
end;

procedure TEditorForm.GetHeadTXTActionExecute(Sender: TObject);
var
	URL, RefURL: string;
	settingBody: TStringList;
	tmpBoard: TBoard;
begin
	InitIdHTTP(Indy);
	if FThreadItem = nil then
		tmpBoard := FBoard
	else
		tmpBoard := FThreadItem.ParentBoard;

	if tmpBoard = nil then Exit;

	RefURL	:= tmpBoard.URL;
	if RefURL[Length(RefURL)] <> '/' then
		URL	:= RefURL + '/' + 'head.txt'
	else
		URL	:= RefURL + 'head.txt';

	if FileExists(tmpBoard.GETHEADTXTFileName) then
		Indy.Request.LastModified := tmpBoard.HEADTXTTime
	else
		Indy.Request.LastModified := ZERO_DATE;

	Indy.Request.Referer := RefURL;
	Screen.Cursor := crHourGlass;
	settingBody := TStringList.Create;
	try
		StatusBar.Panels[0].Text := '[J[(head.txt)_E[h';
		try
			settingBody.Text := Indy.Get(URL);
			if( Indy.ResponseCode = 200 ) then begin
				settingBody.Insert(0, '<HTML lang="ja"><HEAD>');
				settingBody.Insert(1, '<META http-equiv="Content-Type" content="text/html; charset=Shift_JIS">');
				settingBody.Insert(2, '<TITLE>' + tmpBoard.Title + '</TITLE>');
				settingBody.Insert(3, '<base href="' + RefURL + '"></HEAD><BODY>');
				settingBody.Add('</BODY></HTML>');
				settingBody.SaveToFile(tmpBoard.GETHEADTXTFileName);
				tmpBoard.HEADTXTTime := Indy.Response.LastModified;
				tmpBoard.IsHEADTXT := true;
				tmpBoard.Modified := true;
				StatusBar.Panels[0].Text := '[J[擾(' + IntToStr(Indy.ResponseCode) + ')';
			end;
		except
			on E: EIdException do begin
				if( AnsiPos('304', E.Message) > 0 ) then
					StatusBar.Panels[0].Text := '[J[XV(' + IntToStr(Indy.ResponseCode) + ')'
				else
					StatusBar.Panels[0].Text := '[J[擾G[(' + IntToStr(Indy.ResponseCode) + ')';
			end;
		end;
	finally
		settingBody.Free;
		Screen.Cursor := crDefault;
	end;
	if tmpBoard.IsHEADTXT then begin
                ShowBoardHead(tmpboard, LocalEdit);
	end;

end;

procedure TEditorForm.CalcCapacityActionExecute(Sender: TObject);
var
	Board: TBoard;
	body: String;
begin
	body := GetBody;
    //ǂAsĂۂǁA{悭ȂB
	if FThreadItem = nil then
		Board := FBoard
	else
		Board := FThreadItem.ParentBoard;

	if Board.BoardPlugIn <> nil then
		body := CustomStringReplace(body, #13#10, '<br>')
	else
		body := CustomStringReplace(body, #13#10, ' <br> ');
	StatusBar.Panels[0].Text := 'e:' + IntToStr(Length(body)) + ' byte';
end;

procedure TEditorForm.LocalRuleClick(Sender: TObject);
var
  ini: TIniFile;
begin
	ini := TIniFile.Create(GikoSys.Setting.GetFileName);
	try
		RocalRuleTab.TabVisible := LocalRule.Checked;
		ini.WriteBool('EditorForm', 'LocalRuleTab', RocalRuleTab.TabVisible);
	finally
		ini.Free;
	end;
end;

procedure TEditorForm.FormDeactivate(Sender: TObject);
begin
	if GikoSys.Setting.GestureEnabled then begin
		MouseGesture.UnHook;
		MouseGesture.SetHook( GikoForm.Handle );
	end;
end;

procedure TEditorForm.OnGestureStart(Sender: TObject);
begin
//
end;

procedure TEditorForm.OnGestureMove(Sender: TObject);
var
	s: string;
	Action: TAction;
	ActStr: string;
begin
	s := MouseGesture.GetGestureStr;
	ActStr := '';
	Action := FGestures.GetGestureAction(s);
	if Action <> nil then
		ActStr := 'i' + Action.Caption + 'j';
	s := 'WFX`[: ' + s + ActStr;
	StatusBar.Panels[0].Text := s;
end;

procedure TEditorForm.OnGestureEnd(Sender: TObject);
var
	s: string;
	Action: TAction;
begin
	s := MouseGesture.GetGestureStr;
	Action := FGestures.GetGestureAction(s);
	if Action <> nil then
		Action.Execute;
	StatusBar.Panels[0].Text := '';
end;

procedure TEditorForm.ShowBoardHead(ABoard: TBoard; AMemo: TMemo);
var
        wDoc, WTex, le: OLEVariant;
begin
		//Ql
		//http://www.campus.ne.jp/~ishigami/CREATION/TECHNIC/WEBAP-2.htm
		WebBrowser1.Navigate(ABoard.GETHEADTXTFileName,le,le,le,le);
		//^OxTXTɈڂȂBʂorz
		//̂悤ɂƓǂݍ݂IĂ邩A`FbN΂񂾂B
		//ł܂B肪Ƃ܂B
		while (WebBrowser1.ReadyState <> READYSTATE_COMPLETE) and
				(WebBrowser1.ReadyState <> READYSTATE_INTERACTIVE) do begin
			Application.ProcessMessages;
		end;
		wDoc := WebBrowser1.Document;
		wTex := wDoc.body.createTextRange;
		LocalEdit.Text := wTex.text;
end;

procedure TEditorForm.LocalRuleBrowseClick(Sender: TObject);
var
        URL: String;
        ABoard: TBoard;
begin
	if FThreadItem = nil then
		ABoard := FBoard
	else
		ABoard := FThreadItem.ParentBoard;

	if ABoard = nil then Exit;

        URL := ABoard.GETHEADTXTFileName;
        GikoSys.OpenBrowser(URL, gbtAuto);
end;

procedure TEditorForm.SaveNameMailActionExecute(Sender: TObject);
begin
	SaveNameMailAction.Checked := not SaveNameMailAction.Checked;
	KotehanCheckBox.Enabled := SaveNameMailAction.Checked;
end;

function TEditorForm.LFusianaGet(s: String): Boolean;
var
	i: Integer;
begin
        i := AnsiPos('fusianasan', s);
        if (i > 0) then Result := True else Result := False;
end;

procedure TEditorForm.BeLogInOutEActionExecute(Sender: TObject);
begin
	GikoSys.Setting.BeLogin := not GikoSys.Setting.BeLogin;
end;

procedure TEditorForm.BeLogInOutEActionUpdate(Sender: TObject);
begin
	if (GikoSys.Setting.BeUserID <> '') and (GikoSys.Setting.BeCode <> '') then begin
		if (GikoSys.Setting.BeLogin) then BeLogInOutEAction.Checked := true
		else BeLogInOutEAction.Checked := false;
		BeLogInOutEAction.Enabled := true
	end else
		BeLogInOutEAction.Enabled := false;

end;
// Cookie̎擾
procedure TEditorForm.GetCookie(Rawtext: String; ABoard: TBoard);
const
	COOKIE_MARK = 'Set-Cookie:';
	VAL_SPID	= 'SPID=';
	VAL_PON		= 'PON=';
	EXPIRES_MARK = 'expires=';
var
//	i: Integer;
	tmp : string;
	val : string;
begin
	ABoard.Cookie := '';
	while  (AnsiPos(COOKIE_MARK, Rawtext) > 0 ) do begin
		//i := 0;
		tmp := Copy(Rawtext, AnsiPos(COOKIE_MARK, Rawtext) + Length(COOKIE_MARK), Length(Rawtext));
		Delete(Rawtext, 1, AnsiPos('Set-Cookie', Rawtext)+ Length(COOKIE_MARK));
		//Cookie؂o
		val := Trim(GikoSys.GetTokenIndex(tmp, ';', 0));
		if( AnsiPos(VAL_SPID, val) > 0 ) then begin
			ABoard.SPID := Copy(val, AnsiPos(VAL_SPID, val) + Length(VAL_SPID), Length(val));
		end else if( AnsiPos(VAL_PON, val) > 0 ) then begin
			ABoard.PON := Copy(val, AnsiPos(VAL_PON, val) + Length(VAL_PON), Length(val));
		end else begin
			ABoard.Cookie := val + '; ';
		end;
		//expires؂o
		val := Trim(GikoSys.GetTokenIndex(tmp, ';', 1));
		if( AnsiPos(EXPIRES_MARK, val) > 0) then begin
			Delete(val, 1, AnsiPos(EXPIRES_MARK, val) + Length(EXPIRES_MARK) - 1);
			ABoard.Expires := GMTToLocalDateTime(val);
		end;
	end;
end;

end.
