unit MonaUtils;

{$IOCHECKS ON}

{----------------------------------------------------------
  MonaUtils

  --History--
  2002.12.10 GetDatSince쐬
  2001.03.07 ExtractUrlPath쐬
  2001.03.07 ExtractUrlName쐬
  2001.03.08 Max쐬
  2001.03.08 Min쐬
  2001.03 10 EMonaError, MonaError쐬
  2001.03.10 IncludeTrailingSlash쐬
  2001.03.10 ExcludeTrailingSlash쐬
  2001.03 10 IsUrlDelimiter쐬
  2001.03 10 FindFile쐬
  2001.03.10 LoadStringFromFile쐬
  2001.03.10 SaveStringToFile쐬
  2001.03.11 TMonaHtmlParser쐬
  2001.03.11 TMonaProfiler쐬
  2001.03.11 ShellOpen쐬
  2001.04.06 AddHRefTag쐬                                       < GikoNavi
  2001.04.27 TrimHRefTag쐬
  2001.04.27 DecodeHtmlEsc쐬
  2001.04.27 EncodeHtmlEsc쐬
  2001.04.27 ExtractHostName쐬
  2001.04.27 Get2chDate쐬                                       < GikoNavi
  2001.04.27 ChooseString쐬
  2001.04.27 ExtractQuotedStr쐬
  2001.04.27 ExtractUrlLastPath쐬
  2001.04.27 IsNumeric쐬                                        < GikoNavi
  2001.04.27 IsFloat쐬                                          < GikoNavi
  2001.04.27 Fmt2chToDateTime쐬                               < Monaplorer
  2001.04.27 AddHRefTagAbvf[g                        < GikoNavi a013
  2001.04.27 StrCount1쐬                                      < Monaplorer
  2001.04.27 BackAnsiPos쐬                                    < Monaplorer
  2001.10.30 TMonaProfilerUO
  2001.10.30 TMonaHtmlParser AttributesvpeBǉ          < Hotzonu
  2001.10.30 UrlToDosPath쐬                                      < Hotzonu
  2001.10.30 ChooseValue쐬                                       < Hotzonu
  2001.10.30 MargeUrl쐬                                          < Hotzonu
  2001.10.30 ExtractHrefUrl쐬                                    < Hotzonu
  2001.10.30 ZenToHan쐬                                          < Hotzonu
  2001.10.30 GetContentLength쐬                                  < Hotzonu
  2001.10.30 TrimTag쐬                                           < Hotzonu
  2001.10.30 AddTargetBlank쐬                                    < Hotzonu
  2001.11.09 ExtractDatNo쐬

  --Procedures--
  ExtractUrlPath .......... URLpX𒊏o
  ExtractUrlName .......... URLt@C𒊏o
  IncludeTrailingSlash .... t@C̖'/'ǉ
  ExcludeTrailingSlash .... t@C̖'/'菜
  IsUrlDelimiter .......... 񒆂̎wʒu / ǂ
  Max ..................... ӂ̈̂傫Ԃ
  Min ..................... ӂ̈̂Ԃ
  FindFile ................ wpX̃t@C TSearchRecԂ
  LoadStringFromFile ...... t@C當ǂݍ
  SaveStringToFile ........ t@Cɏo
  ShellOpen ............... wt@CShellExecute
  AddHRefTag .............. http://n܂镶 A^O
  TrimHRefTag ............. 񂩂<A HREF`> </A>^O
  DecodeHtmlEsc ........... 񒆂̓^O(&lt;Ƃ)ϊ
  EncodeHtmlEsc ........... 񒆂"<"Ȃǂ^Oɕϊ
  ExtractHostName ......... URLzXg𒊏o
  Get2chDate .............. tQ˂POSTptɕϊ
  ChooseString ............ Zp[^ŋ؂ꂽ񂩂
                            Ԗڂ̕o
  ExtractQuotedStr ........ ̑ÖpO
  ExtractUrlLastPath ...... URL̍Ō̃pX𒊏o
  IsNumeric ............... w蕶񂪐ǂ𔻒f
  IsFloat ................. w蕶񂪎ǂ𔻒f
  Fmt2chToDateTime ........ DATt@Cł̓tt^ɕϊ
  StrCount1 ............... S̒SubStr邩JEg(2oCgΉ)
  UrlToDosPath ............ URLDOS`̃pXɕϊ
  ChooseValue ............. URL ?param=value Paramw肷Value擾
  MargeUrl ................ URLƑURL}[W
  ExtractHrefUrl .......... A HREF^O̒URL𒊏o
  ZenToHan ................ Sp𔼊pɕϊ(Windowŝ)
  GetContentLength ........ w蕶̒Ԃ (#13܂܂Ȃ)
  TrimTag ................. w肳ꂽ񂩂^O
  AddTargetBlank .......... A HREF^O TARGET="_blank"}
  ExtractDatNo ............ DATt@C DAT̔ԍ擾

  --Classes--
  TMonaHtmlParser ......... HTMLp[T[NX
  TMonaProfiler ........... vt@C

  --Report--
  SaveStringToFile LinuxvbgtH[Œ[̕T|[g܂B
  ShellOpen, MonaProfilerLinuxvbgtH[T|[g܂B
----------------------------------------------------------}

interface

uses
  {$IFDEF LINUX}
    QForms,
  {$ENDIF}
  {$IFDEF MSWINDOWS}
    Windows, ShellApi, Forms,
  {$ENDIF}
  Classes, SysUtils, {HTTPApp,} YofUtils, DateUtils;

//
//  O
//
type
  EMonaError = class(Exception);

// EMonaErrorraise
procedure MonaError(msg: String); overload;
procedure MonaError(format: String; args: array of const); overload;

//
//  葱E֐
//
function  ExtractUrlPath(const FileName: string): string;
function  ExtractUrlName(const FileName: string): string;
function  Max(A, B: Integer): Integer; overload;
function  Max(A, B: Int64): Int64; overload;
function  Max(A, B: Single): Single; overload;
function  Max(A, B: Double): Double; overload;
function  Max(A, B: Extended): Extended; overload;
function  Min(A, B: Integer): Integer; overload;
function  Min(A, B: Int64): Int64; overload;
function  Min(A, B: Single): Single; overload;
function  Min(A, B: Double): Double; overload;
function  Min(A, B: Extended): Extended; overload;
function  IncludeTrailingSlash(const S: string): string;
function  ExcludeTrailingSlash(const S: string): string;
function  IsUrlDelimiter(const S: string; Index: Integer): Boolean;
function  FindFile(const FileName: String): TSearchRec;
function  LoadStringFromFile(const FileName: String): String;
procedure SaveStringToFile(const FileName, Str: String);
procedure ShellOpen(const FileName: String); // ƂɂJ
function  AddHRefTag(s: string): string;
function  TrimHRefTag(const S: string): string;
function  DecodeHtmlEsc(const s: string): string;
function  EncodeHtmlEsc(const s: string): string;
function  ExtractHostName(const Url: string): string;
function  Get2chDate(aDate: TDateTime): string;  {from GikoNavi / hiroyuki}
function  GetDatSince(aDatNo: string): string;
function  ChooseString(const Text, Separator: string; Index: integer): string;
function  ExtractQuotedStr(S: string; Quote: char): string;
function  ExtractUrlLastPath(Url: string): string;
function  IsNumeric(s: string): boolean; {GikoNavi}
function  Fmt2chToDateTime(Fmt2ch: String): TDateTime; {monaCommonFunc}
function  StrCount1(const Substr, S: string): Integer; {monaCommonFunc}
function  BackAnsiPos(const SubStr,S: String): Integer;{monaCommonFunc}
function  IsFloat(s: string): boolean;
function  UrlToDosPath(const Url: string): string;
function  ChooseValue(const Url, Key: string): string;
function  MargeUrl(const BaseUrl, NewUrl: string): string;
function  ExtractHrefUrl(const s: string): string;
function  ZenToHan(const s: string): string;
function  GetContentLength(S : string): integer;
function  TrimTag(const s: string): string;
function  AddTargetBlank(const Value: string): string;
function  ExtractDatNo(const DatFileName: string): string;
function  DateStrToDateTime(const DateStr: string): TDateTime;
//
procedure testMonaUtils;

//
//  NXER[h
//
type
  TMonaHtmlTokenType = (
    htNone,
    htTag,  // ^O̒
    htText  // ^O̊O
    );

  TMonaHtmlParser = class(TObject)
  protected
    p: PChar;
    FLine: String;
    FToken: String;
    FTokenType: TMonaHtmlTokenType;
    FAttributes: TStrings;
    procedure SetAttributes(const Value: TStrings); // Dax
    procedure makeAttributes(const Token: string);  // Dax
  public
    constructor Create(s: String);  virtual;
    destructor  Destory;  // Dax
    procedure Error; // ̓G[O𔭐
    procedure Assign(s: String);
    procedure GetToken(ATokenType: TMonaHtmlTokenType; AToken: String; IgnoreCase: Boolean = False); overload;
    function GetToken: TMonaHtmlTokenType; overload;
    function GetToken(ATokenType: TMonaHtmlTokenType): String; overload;
    property Token: String read FToken;
    property TokenType: TMonaHtmlTokenType read FTokenType;
    property Attributes: TStrings   read  FAttributes write SetAttributes;  // Dax
  end;

  TMonaProfiler = class(TObject)
  private
    FActive: Boolean;
    FStartCounter, FTotalCounter: Int64;
    function GetMicroSec: Integer;
    function GetMilliSec: Integer;
    function GetSec: Integer;
    procedure SetActive(const Value: Boolean);
  protected
    function GetCounter: Int64;
  public
    constructor Create;
    procedure Start;
    procedure Stop;
    procedure Clear;
    property Active: Boolean read FActive write SetActive;
    property MilliSec: Integer read GetMilliSec;
    property MicroSec: Integer read GetMicroSec;
    property Sec: Integer read GetSec;
  end;

////////////////////////////////////////////////////////////////////////////////
implementation
////////////////////////////////////////////////////////////////////////////////

uses
  MonaTest;

procedure MonaError(msg: String);
begin
  raise EMonaError.Create(msg);
end;

procedure MonaError(format: String; args: array of const);
begin
  MonaError(SysUtils.Format(format, args));
end;

function ExtractUrlPath(const FileName: string): string;
var
  I: Integer;
begin
  I := LastDelimiter('/:', FileName);
  Result := Copy(FileName, 1, I);
end;

procedure testExtractUrlPath;
  procedure mycheck(s, s2: String);
  begin
    Check(s, ExtractUrlPath(s2));
  end;
begin
  mycheck(
    'http://piza.2ch.net/tech/',
    'http://piza.2ch.net/tech/index2.html');

  mycheck(
    'http://piza.2ch.net/tech/',
    'http://piza.2ch.net/tech/index2.html#menu');

  mycheck(
    'http://',
    'http://www.yahoo.co.jp' );

  mycheck(
    '',
    'www.yahoo.co.jp' );
end;

function ExtractUrlName(const FileName: string): string;
var
  I: Integer;
begin
  I := LastDelimiter('/:', FileName);
  Result := Copy(FileName, I + 1, MaxInt);
end;

procedure testExtractUrlName;
  procedure mycheck(s, s2: String);
  begin
    Check(s, ExtractUrlName(s2));
  end;
begin
  mycheck(
    'index2.html',
    'http://piza.2ch.net/tech/index2.html');

  mycheck(
    'index2.html#menu',
    'http://piza.2ch.net/tech/index2.html#menu');

  mycheck(
    'www.yahoo.co.jp',
    'http://www.yahoo.co.jp' );

  mycheck(
    'www.yahoo.co.jp',
    'www.yahoo.co.jp' );
end;


function Max(A, B: Integer): Integer;
begin
  if B < A then Result := A else Result := B;
end;

function Max(A, B: Int64): Int64;
begin
  if B < A then Result := A else Result := B;
end;

function Max(A, B: Single): Single;
begin
  if B < A then Result := A else Result := B;
end;

function Max(A, B: Double): Double;
begin
  if B < A then Result := A else Result := B;
end;

function Max(A, B: Extended): Extended;
begin
  if B < A then Result := A else Result := B;
end;

function Min(A, B: Integer): Integer;
begin
  if A < B then Result := A else Result := B;
end;

function Min(A, B: Int64): Int64; overload;
begin
  if A < B then Result := A else Result := B;
end;

function Min(A, B: Single): Single; overload;
begin
  if A < B then Result := A else Result := B;
end;

function Min(A, B: Double): Double; overload;
begin
  if A < B then Result := A else Result := B;
end;

function Min(A, B: Extended): Extended; overload;
begin
  if A < B then Result := A else Result := B;
end;

procedure testMaxMin;
var
  LowInteger, HighInteger: Integer;
  LowInt64, HighInt64: Int64;
  LowSingle, HighSingle: Single;
  LowDouble, HighDouble: Double;
  LowExtended, HighExtended: Extended;
begin
  LowInteger := Low(Integer) ; HighInteger := High(Integer);
  LowInt64 := Low(Int64); HighInt64 := High(Int64);
  LowSingle := -PI; HighSingle := PI;
  LowDouble := -PI; HighDouble := PI;
  LowExtended := -PI; HighExtended := PI;
  Check(
    HighInteger,
    Max(LowInteger, HighInteger));
  Check(
    HighInt64,
    Max(LowInt64, HighInt64));
  Check(
    HighSingle,
    Max(LowSingle, HighSingle));
  Check(
    HighDouble,
    Max(LowDouble, HighDouble));
  Check(
    HighExtended,
    Max(LowExtended, HighExtended));
  Check(
    LowInteger,
    Min(LowInteger, HighInteger));
  Check(
    LowInt64,
    Min(LowInt64, HighInt64));
  Check(
    LowSingle,
    Min(LowSingle, HighSingle));
  Check(
    LowDouble,
    Min(LowDouble, HighDouble));
  Check(
    LowExtended,
    Min(LowExtended, HighExtended));
end;



//t@C̖'\'ǉ֐
function IncludeTrailingSlash(const S: string): string;
begin
  Result := S;
  if not IsUrlDelimiter(Result, Length(Result)) then
    Result := Result + '/';
end;

procedure testIncludeTrailingSlash;
  procedure mycheck(s, s2: string);
  begin
    Check(s, IncludeTrailingSlash(s2));
  end;
begin
    mycheck(
      'http://www.yahoo.co.jp/',
      'http://www.yahoo.co.jp' );
    mycheck(
      'http://www.yahoo.co.jp/',
      'http://www.yahoo.co.jp/' );
end;

//t@C̖'\'菜֐
function ExcludeTrailingSlash(const S: string): string;
begin
  Result := S;
  if IsUrlDelimiter(Result, Length(Result)) then
    SetLength(Result, Length(Result)-1);
end;

procedure testExcludeTrailingSlash;
  procedure mycheck(s, s2: String);
  begin
    Check(s, ExcludeTrailingSlash(s2));
  end;
begin
  mycheck(
    'http://www.yahoo.co.jp',
    'http://www.yahoo.co.jp/' );
  mycheck(
    'http://www.yahoo.co.jp',
    'http://www.yahoo.co.jp' );
end;

function IsUrlDelimiter(const S: string; Index: Integer): Boolean;
begin
  Result := (Index > 0) and (Index <= Length(S)) and (S[Index] = '/')
    and (ByteType(S, Index) = mbSingleByte);
end;

procedure testIsUrlDelimiter;
  procedure mycheck(b: Boolean; s: String; Index: Integer);
  begin
    Check(b, IsUrlDelimiter(s, Index));
  end;
begin
  mycheck(
    True,
    'http://www.yahoo.co.jp/index.htm', 6 );
  mycheck(
    False,
    'http://www.yahoo.co.jp/index.htm', 3 );
end;

//t@C當ǂݍ
function LoadStringFromFile(const FileName: String): String;
var
  size: Integer;
  F: File;
begin
  size := FindFile(FileName).Size;
  if size = 0 then
  begin
    Result := '';
    Exit;
  end;

  try
    SetLength(Result, size);
    AssignFile(F, FileName);
    Reset(F, size);
    BlockRead(F, PChar(Result)^, 1);
  finally
    CloseFile(F);
  end;
end;

procedure SaveStringToFile(const FileName, Str: String);
var
  path: String;
  F: File;
begin
  path := ExtractFileDir(FileName);
  if (path <> '') and not DirectoryExists(path) then
    {$IFDEF VER130}
    if ForceDirectories(path) then
      MonaError('fBNg%s܂B', [path]);
      {EG(LDM) tH_݂Ȃꍇ쐬}
    {$ELSE}
    try
      ForceDirectories(path);
    except
      MonaError('fBNg%s܂B', [path]);
    end;
    {$ENDIF}
  try
    AssignFile(F, FileName);
    Rewrite(F, Length(Str));
    if Length(Str) > 0 then
      BlockWrite(F, PChar(Str)^, 1);
  finally
    CloseFile(F);
  end;
end;

procedure testLoadSaveString;
  procedure mycheck(s: String);
  var s2: String;
  begin
    try
      SaveStringToFile('testString.txt', s);
      s2 := LoadStringFromFile('testString.txt');
      Check(s, s2, 'testLoadSaveString');
    except
      on E:Exception do Error(E);
    end;
  end;
begin
  mycheck('hello,world');
  {$IFDEF LINUX}
  {$ELSE}
  mycheck(''); //Kylix ł̓G[
               //vWFNg Project1  EInOutError NX̗O𐶐܂B
               //'͒llł͂܂'
  {$ENDIF}
  mycheck('test' + #13 + 'LoadString' + #10 + 'SaveString' + #13 + #10 + 'xxx');
end;

function FindFile(const FileName: String): TSearchRec;
begin
  if FindFirst(FileName, faAnyFile, Result) = 0 then
    FindClose(Result)
  else
    MonaError('%s̏̎擾Ɏs܂B', [FileName]);
end;

procedure testFindFile;
var
  sl: TStringList;
begin
  sl := TStringList.Create;
  try
    sl.Text := 'hello,world';
    sl.SaveToFile('fileinfo.txt');
    with FindFile('fileinfo.txt') do
    begin
      Check(Size, Length(sl.Text));
      Check(Name, 'fileinfo.txt');
    end;
  finally
    sl.Free;
  end;
end;

{ TMonaHtmlParser }
procedure TMonaHtmlParser.Error;
begin
  MonaError('HTML̉͂Ɏs܂:%s', [p]);
end;

constructor TMonaHtmlParser.Create(s: String);
begin
  FAttributes :=  TStringList.Create;
  Assign(s);
end;

procedure TMonaHtmlParser.Assign(s: String);
begin
  FLine := s;
  p := PChar(s);
end;

function TMonaHtmlParser.GetToken: TMonaHtmlTokenType;
begin
  FToken := '';
  while True do
    case p^ of
    #10, #13:
      Inc(p);
    else
      break;
    end;

  case p^ of
  #0:
    FTokenType := htNone;

  '<':
  begin
    FTokenType := htTag;
    while True do
    begin
      Inc(p);
      case p^ of
      #10, #13:
        ;
      #0, '<':
        Error;
      '>':
        begin
          makeAttributes(FToken); // add Dax 2001/10/30
		  		Break;
        end;
      else
        FToken := FToken + p^;
      end;
    end;
    Inc(p);
  end;

  else
    FTokenType := htText;
    while True do
    begin
      case p^ of
      #10, #13:
        ;
      #0, '<':
        Break;

      '>':
        Error;
      else
        FToken := FToken + p^;
      end;
      Inc(p);
    end;
  end;

  Result := FTokenType;
end;

function TMonaHtmlParser.GetToken(ATokenType: TMonaHtmlTokenType): String;
begin
  if GetToken <> ATokenType then
    Error;
  Result := Token;
end;

procedure TMonaHtmlParser.GetToken(ATokenType: TMonaHtmlTokenType;
  AToken: String; IgnoreCase: Boolean);
begin
  if IgnoreCase then
  begin
    if UpperCase(GetToken(ATokenType)) <> UpperCase(AToken) then
      Error;
  end else begin
    if GetToken(ATokenType) <> AToken then
      Error;
  end;
end;


destructor TMonaHtmlParser.Destory;
begin
  FAttributes.Free;
end;

procedure TMonaHtmlParser.makeAttributes(const Token: string);
var
  x, xend : PChar;
  Attr  : string;
  S : string;
begin
  //'<AAA BBB=CCC DDD=EEE>'
  x       :=  PChar(Token);
  xend    :=  PChar(Token) + Length(Token) + 1;
  S := '';
  while (x < xend)  do  begin
    if  (x^ = ' ') or (x^ = #0) then  begin
      if  (Attr <> '')  then  begin
        FAttributes.Values[Attr]  :=  S;
      end;
      Attr  :=  '';
      S     :=  '';
    end else
    if  (x^ = '=')  then  begin
      Attr  :=  S;
      S     :=  '';
    end else begin
      S :=  S + x^;
    end;
    inc(x);
  end;
end;

procedure TMonaHtmlParser.SetAttributes(const Value: TStrings);
begin
  FAttributes.Assign(Value);
end;

procedure testMonaHtmlParser;
var
  parser: TMonaHtmlParser;

begin
  parser := TMonaHtmlParser.Create( // TStrings.TextȂǂn
    '<!-- saved from url=(0032)http://www.2ch.net/bbstable.html -->' +
    '<html>' +#10+
      '<HEAD>' +#13+
        '<TITLE>BBS TABLE for 2ch</TITLE>' +
      '</HEAD>' +#13+
      '<Body>' +#13+#10+
        'y<B>ꍇ</B>z' +
        '<A href="http://piza.2ch.net/intro/index2.html">ȏЉ</A>' +
      '</Body>' +#10+#13+
    '</html>' +#10
  );
  with parser do
  try
    // sׂ͂ĖA啶͋ʁA
    // eLXgE^O̒g͉߂ɂ̂܂ܕԂB
    GetToken(htTag,  '!-- saved from url=(0032)http://www.2ch.net/bbstable.html --');
//    GetToken;(htTag,  'html');
    GetToken;
    Check(TokenType = htTag, 'GetToken = htTag');
    Check(Token, 'html');

//    GetToken(htTag,  'HEAD');
    Check(GetToken(htTag), 'HEAD');

    GetToken(htTag,  'TITLE');
    GetToken(htText, 'BBS TABLE for 2ch');
    GetToken(htTag,  '/title', True);
    GetToken(htTAG,  '/HEAD');
    GetToken(htTag,  'Body');
    GetToken(htText, 'y');
    GetToken(htTag,  'B');
    GetToken(htText, 'ꍇ');
    GetToken(htTag,  '/B');
    GetToken(htText, 'z');
    GetToken(htTag,  'A href="http://piza.2ch.net/intro/index2.html"');
    GetToken(htText, 'ȏЉ');
    GetToken(htTag,  '/A');
    GetToken(htTag,  '/Body');
    GetToken(htTag,  '/html');
    Check(GetToken = htNone); // ܂
  finally
    Free;
  end;
end;

{ TMonaProfiler }

// PerformanceCounterp
var TMonaProfiler_FFrequency: Int64;

procedure TMonaProfiler.Clear;
begin
  FTotalCounter := 0;
  if FActive then
    FStartCounter := GetCounter;
end;

constructor TMonaProfiler.Create;
begin
  Clear;
end;

function TMonaProfiler.GetCounter: Int64;
begin
  {$IFDEF LINUX}
    //
  {$ELSE}
    if not QueryPerformanceCounter(Result) then
      RaiseLastWin32Error;
  {$ENDIF}
end;

function TMonaProfiler.GetMicroSec: Integer;
var
  counter: Int64;
begin
  counter := FTotalCounter;
  if FActive then
    Inc(counter, GetCounter - FStartCounter);
  try
    Result := Round(counter / TMonaProfiler_FFrequency * 1000000);
  except
    Result  :=  0;
  end;
end;

function TMonaProfiler.GetMilliSec: Integer;
var
  counter: Int64;
begin
  counter := FTotalCounter;
  if FActive then
    Inc(counter, GetCounter - FStartCounter);
  try
    Result := Round(counter / TMonaProfiler_FFrequency * 1000);
  except
    Result  :=  0;
  end;
end;

function TMonaProfiler.GetSec: Integer;
var
  counter: Int64;
begin
  counter := FTotalCounter;
  if FActive then
    Inc(counter, GetCounter - FStartCounter);
  try
    Result := Round(counter / TMonaProfiler_FFrequency);
  except
    Result  :=  0;
  end;
end;

procedure TMonaProfiler.SetActive(const Value: Boolean);
begin
  FActive := Value;
  if FActive then
    Start
  else
    Stop;
end;

procedure TMonaProfiler.Start;
begin
  if FActive then
    Exit;
  FActive := True;
  FStartCounter := GetCounter;
end;

procedure TMonaProfiler.Stop;
begin
  if not FActive then
    Exit;
  Inc(FTotalCounter, GetCounter - FStartCounter);
  FActive := False;
end;

procedure testMonaProfiler;
var
  profiler: TMonaProfiler;
begin
  profiler := TMonaProfiler.Create;
  try
    profiler.Start; // Jn
    Sleep(500);
    profiler.Stop;
    Check(500, (profiler.MilliSec + 50) div 100 * 100);

    Sleep(500);

    profiler.Start; // ĊJ
    Sleep(1000);
    Check(1500, (profiler.MilliSec + 50) div 100 * 100); // ғłOK
    profiler.Stop;

    profiler.Clear;
    Check(0, profiler.MicroSec);
    profiler.Start; // Jn
    Sleep(500);
    profiler.Stop;
    Check(500*1000, (profiler.MicroSec + 50) div 1000 * 1000);
  finally
  end;
end;

procedure ShellOpen(const FileName: String); // ƂɂJ
begin
  {$IFDEF WINDOWS}
    if 32 >= ShellExecute(Application.Handle, 'open', PChar(FileName), nil, nil, sw_show) then
      RaiseLastWin32Error;
  {$ELSE}
    // ??Ȃ񂾂??
  {$ENDIF}
end;

(*
function AddHRefTag(s: string): string;
const
  NORMAL_CHAR: string = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789:/.%?&#=-_~+*;!^`\|@[]{}$,';
var
  url: string;
  i: Integer;
  idx: Integer;
begin
  Result := '';

  while True do begin
    idx := AnsiPos('http://', s);

    if idx = 0 then begin
      //N[B
      Result := Result + s;
      Break;
    end;

    Result := Result + Copy(s, 0, idx - 1);

    s := Copy(s, idx, length(s));

    for i := 0 to Length(s) do begin

      idx := AnsiPos(s[i + 1], NORMAL_CHAR);

      if (idx = 0) or (i = (Length(s))) then begin
        //URLȂIƂAȂȂB
        url := Copy(s, 0, i);

        Result := Result + '<a href="' + url + '" target="_blank">' + url + '</a>';
        s := Copy(s, i + 1, Length(s));
        Break;
      end;
    end;
  end;
end;
*)
function AddHRefTag(s: string): string;
const
  NORMAL_CHAR: string = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789:/.%?&#=-_~+*;!^`\|@[]{}$,';
var
  url: string;
  i, x: Integer;
  idx, idx1, idx2, idx3, idx4: Integer;
  prefix: string;
  s1: string;
begin
  Result := '';

  while True do begin
    idx1 := AnsiPos('http://', s);
    idx2 := AnsiPos('ttp://', s);
    idx3 := AnsiPos('www.', s);

    if  (idx1 > 1) then  begin
      for x :=  idx1  downto  1 do  begin
        if  (s[x] = '>')  then  begin
          Break;
        end else
        if  (s[x] = '<')  then  begin
          idx1  :=  0;
          idx2  :=  0;
          idx3  :=  0;
          Break;
        end;
      end;
    end;
    if  (idx1 > 4) then  begin
      s1  :=  AnsiLowerCase(Copy(s, idx1 - 4, 4));
      if  (s1 <> '<br>')  and
          (s[idx1 - 1] = '>') then
      begin
        idx1  :=  0;
        idx2  :=  0;
        idx3  :=  0;
      end;
    end;
    if  ((idx3 < idx2) and (idx3 > 0)) or ((idx3 > 0) and (idx2 = 0)) then  begin
      // www
      idx  :=  idx3;
      prefix:=  'http://';
    end else
    if  (idx2 < idx1) or ((idx2 > 0) and (idx1 = 0)) then  begin
      // ttp
      idx  :=  idx2;
      prefix:=  'h';
    end else begin
      idx  :=  idx1;
      prefix:=  '';
    end;

    if (idx1 = 0) and (idx2 = 0) and (idx3 = 0) then begin
      //N[B
      Result := Result + s;
      Break;
    end;

    Result := Result + Copy(s, 0, idx - 1);
    s := Copy(s, idx, length(s));
    for i := 0 to Length(s) - 1 do begin
      idx4 := AnsiPos(s[i + 1], NORMAL_CHAR);
      if (idx4 = 0) then  begin
        url := Copy(s, 0, i);
        Result := Result + '<a href="' + prefix + url + '" target="_blank">' + url + '</a>';
        s := Copy(s, i + 1, Length(s));
        Break;
      end else
      if (i = (Length(s) - 1)) then begin
        //URLȂIƂAȂȂB
        url := Copy(s, 0, i + 1);
        Result := Result + '<a href="' + prefix + url + '" target="_blank">' + url + '</a>';
        s := Copy(s, i + 2, Length(s));
        Break;
      end;
    end;
  end;
end;

procedure testAddHRefTag;
  procedure mycheck(s, s2: String);
  begin
    Check(s, AddHRefTag(s2));
  end;
begin
  mycheck(
    '<a href="http://piza.2ch.net/tech/" target="_blank">http://piza.2ch.net/tech/</a>',
    'http://piza.2ch.net/tech/');
  mycheck(
    'ڍׂ̓RR<a href="http://piza.2ch.net/tech/" target="_blank">http://piza.2ch.net/tech/</a>',
    'ڍׂ̓RRhttp://piza.2ch.net/tech/');
  mycheck(
    '<a href="http://piza.2ch.net/tech/" target="_blank">http://piza.2ch.net/tech/</a>',
    'http://piza.2ch.net/tech/');
  mycheck(
    '<a href="http://piza.2ch.net/tech/index2.html#menu" target="_blank">http://piza.2ch.net/tech/index2.html#menu</a>',
    'http://piza.2ch.net/tech/index2.html#menu');
  mycheck(
    '<a href="http://www.yahoo.com" target="_blank">http://www.yahoo.com</a><a href="http://www.goo.ne.jp" target="_blank">http://www.goo.ne.jp</a>',
    'http://www.yahoo.comhttp://www.goo.ne.jp');
  mycheck(
    'https://piza.2ch.net/tech/index2.html#menu',
    'https://piza.2ch.net/tech/index2.html#menu');
  mycheck(
    '<a href="http://piza.2ch.net/tech/index2.html#menu0" target="_blank">http://piza.2ch.net/tech/index2.html#menu0</a>',
    'http://piza.2ch.net/tech/index2.html#menu0');
  mycheck(
    'httpŎn܂',
    'httpŎn܂');
  mycheck(
    '',
    '');
  mycheck(
    '<a href="http://www.2ch.net/tech/" target="_blank">www.2ch.net/tech/</a>',
    'www.2ch.net/tech/');
  mycheck(
    'wwwƂ',
    'wwwƂ');
  mycheck(
    'www ',
    'www ');
end;

//
//  񒆂 <A HREF="xxx"> </A>^O菜܂
//
function TrimHRefTag(const S: string): string;
var
  x, y : integer;
  BodyText : string;
begin
  BodyText  :=  StringReplace(S,'</A>', '', [rfReplaceAll,rfIgnoreCase]);
  while True do  begin
    x :=  Pos('<a ',AnsiLowerCase(BodyText));
    if (AnsiPos('>',AnsiLowerCase(BodyText)) = 0) then  begin
      Break;
    end;
    y :=  x;
    if  (x > 0) then  begin
      while true  do  begin
        if  (BodyText[y] = '>') and (ByteType(BodyText, y) = mbSingleByte)  then
        begin
          BodyText  :=  Copy(BodyText,1, x-1) +
                        Copy(BodyText,y + 1, Length(BodyText));
          break;
        end else begin
          inc(y);
          if  (y > Length(BodyText)) then  Break;
        end;
      end;
    end else begin
      Break;
    end;
  end;
  Result  :=  BodyText;
end;

procedure testTrimHRefTag;
  procedure mycheck(s{҂錋}, s2{֐ɓne}: String);
  begin
    Check(s, TrimHRefTag(s2));
  end;
begin
  mycheck(
    'http://piza.2ch.net/tech/',
    '<a href="http://piza.2ch.net/tech/" target="_blank">http://piza.2ch.net/tech/</a>');
  mycheck(
    'ڍׂ̓RRhttp://piza.2ch.net/tech/',
    'ڍׂ̓RR<a href="http://piza.2ch.net/tech/" target="_blank">http://piza.2ch.net/tech/</a>');
  mycheck(
    'http://piza.2ch.net/tech/',
    '<a href="http://piza.2ch.net/tech/" target="_blank">http://piza.2ch.net/tech/</a>');
  mycheck(
    'http://piza.2ch.net/tech/index2.html#menu',
    '<a href="http://piza.2ch.net/tech/index2.html#menu" target="_blank">http://piza.2ch.net/tech/index2.html#menu</a>');
  mycheck(
    'http://www.yahoo.comhttp://www.goo.ne.jp',
    '<a href="http://www.yahoo.com" target="_blank">http://www.yahoo.com</a><a href="http://www.goo.ne.jp" target="_blank">http://www.goo.ne.jp</a>');
  mycheck(
    'https://piza.2ch.net/tech/index2.html#menu',
    'https://piza.2ch.net/tech/index2.html#menu');
  mycheck(
    'httpŎn܂',
    'httpŎn܂');
  mycheck(
    '',
    '');
end;

function DecodeHtmlEsc(const s: string): string;
var
  DispText : string;
begin
  DispText  :=  StringReplace(S, '<br>', #13#10, [rfIgnoreCase, rfReplaceAll]);
  DispText  :=  StringReplace(DispText, '&lt;', '<', [rfIgnoreCase, rfReplaceAll]);
  DispText  :=  StringReplace(DispText, '&gt;', '>', [rfIgnoreCase, rfReplaceAll]);
  DispText  :=  StringReplace(DispText, '&quot;', '"', [rfIgnoreCase, rfReplaceAll]);
  DispText  :=  StringReplace(DispText, '&amp;', '&', [rfIgnoreCase, rfReplaceAll]);
  DispText  :=  StringReplace(DispText, '&nbsp;', ' ', [rfIgnoreCase, rfReplaceAll]);
  Result    :=  DispText;
end;

procedure testDecodeHtmlEsc;
  procedure mycheck(s{҂錋}, s2{֐ɓne}: String);
  begin
    Check(s, DecodeHtmlEsc(s2));
  end;
begin
  mycheck(
    '<HTML&XML>',
    '&lt;HTML&amp;XML&gt;');
  mycheck(
    'BR' + #13#10  + 'BR' + #13#10#13#10,
    'BR<BR>BR<BR><BR>');
  mycheck(
    '<">',
    '&LT;&quot;&GT;');
  mycheck(
    '  ',
    '&nbsp;&nbsp;');
  mycheck(
    '',
    '');
end;

function EncodeHtmlEsc(const s: string): string;
var
  DispText : string;
begin
  DispText  :=  StringReplace(S, '&', '&amp;', [rfReplaceAll]);
  DispText  :=  StringReplace(DispText, '<', '&lt;', [rfReplaceAll]);
  DispText  :=  StringReplace(DispText, '>', '&gt;', [rfReplaceAll]);
  DispText  :=  StringReplace(DispText, '"', '&quot;', [rfReplaceAll]);
  DispText  :=  StringReplace(DispText, #13#10, '<br>', [rfReplaceAll]);
  Result    :=  DispText;
end;

procedure testEncodeHtmlEsc;
  procedure mycheck(s{҂錋}, s2{֐ɓne}: String);
  begin
    Check(s, EncodeHtmlEsc(s2));
  end;
begin
  mycheck(
    '&lt;HTML&amp;XML&gt;',
    '<HTML&XML>');
  mycheck(
    'BR<br>BR<br><br>',
    'BR' + #13#10  + 'BR' + #13#10#13#10);
  mycheck(
    '&lt;&quot;&gt;',
    '<">');
  mycheck(
    '',
    '');
end;

function ExtractHostName(const Url: string): string;
const
  PRE = 'http://';
var
  n : integer;
begin
  if  (AnsiPos(PRE, Url) = 1) then  begin
    n :=  Pos('/', Copy(Url,Length(PRE)+1,Length(Url))) - 1;
    if  (n < 0) then  n :=  Length(Url) - Length(PRE);
    Result :=  Copy(Url, Length(PRE) + 1, n);
  end else begin
    Result  :=  '';
  end;
end;

procedure testExtractHostName;
  procedure mycheck(s{҂錋}, s2{֐ɓne}: String);
  begin
    Check(s, ExtractHostName(s2));
  end;
begin
  mycheck(
    'www.2ch.net',
    'http://www.2ch.net/');

  mycheck(
    'piza.2ch.net',
    'http://piza.2ch.net/tech/index2.html');

  mycheck(
    'piza.2ch.net',
    'http://piza.2ch.net/tech/index2.html#menu');

  mycheck(
    'www.yahoo.co.jp',
    'http://www.yahoo.co.jp' );

  mycheck(
    '',
    'www.yahoo.co.jp' );
  mycheck(
    '',
    '');
end;

function Get2chDate(aDate: TDateTime): string;
var
  d1: TDateTime;
  d2: TDateTime;
begin
  d1 := EncodeDate(1970, 1, 1);
  d2 := aDate - EncodeTime(9, 0, 0, 0);
  Result := FloatToStr(Trunc((d2 - d1) * 24 * 60 * 60));
end;

function GetDatSince(aDatNo: string): string;
var
  s:  string;
  v:  double;
  ad: TDateTime;
  d1: TDateTime;
begin
  if  (AnsiPos('_', aDatNo) > 0)  then  begin
    s :=  Copy(aDatNo, 1, AnsiPos('_', aDatNo) - 1);  //ΑΉ
  end else begin
    s :=  aDatNo;
  end;
  if  (TryStrToFloat(s, v)) then  begin
    v   :=  StrToFloat(s);
    ad  :=  v / 60 / 60 / 24;
    d1  :=  EncodeDate(1970, 1, 1);
    ad  :=  (ad + EncodeTime(9,0,0,0))  + d1;
    Result  :=  FormatDateTime('yyyy/mm/dd h:m:s', ad);
  end else begin
    Result  :=  '';
  end;
end;

procedure testGet2chDate;
  procedure mycheck(s{҂錋}: string; s2{֐ɓne}: TDateTime);
  begin
    Check(s, Get2chDate(s2));
  end;
begin
  mycheck(
    '986094000',
    StrToDateTime('2001/04/01 12:00:00'));

  mycheck(
    '1078023600',
    StrToDateTime('2004/02/29 12:00:00'));
end;

function ChooseString(const Text, Separator: string; Index: integer): string;
var
  S : string;
  i, p : integer;
begin
  S :=  Text;
  for i :=  0 to  Index - 1 do  begin
    if  (AnsiPos(Separator, S) = 0) then  S :=  ''
    else  S :=  Copy(S, AnsiPos(Separator, S) + Length(Separator), Length(S));
  end;
  p :=  AnsiPos(Separator, S);
  if  (p > 0) then  Result  :=  Copy(S, 1, p - 1) else Result :=  S;
end;

procedure testChooseString;
  procedure mycheck(s{҂錋}, s2, s3{֐ɓne}: String;
                    n: integer);
  begin
    Check(s, ChooseString(s2, s3, n));
  end;
begin
  mycheck(
    'a',
    'a/b/c/', '/', 0);

  mycheck(
    'b',
    'a/b/c/', '/', 1);

  mycheck(
    'c',
    'a/b/c/', '/', 2);

  mycheck(
    '',
    'a/b/c/', '/', 3);

  mycheck(
    '',
    'a/b/c', '/', 3);

  mycheck(
    'arakabu',
    'http://www.2ch.com/arakabu/', '/', 3);

  mycheck(
    'ɂȂ',
    '̖؂Ȃ̖ؖ؂ɂȂ', '', 3);

  mycheck(
    'C++Builder',
    'BorlandDelphiBorlandC++BuilderBorlandKylix', 'Borland', 2);

  mycheck(
    '',
    '', '/', 0);
end;

function ExtractQuotedStr(S: string; Quote: char): string;
begin
  if  (Length(S) > 1) then  begin
    if  (S[1] = Quote) and (Copy(S, Length(S), 1) = Quote)  then  begin
      Result  :=  Copy(S, 2, Length(S) - 2);
    end else begin
      Result  :=  S;
    end;
  end else begin
    Result  :=  S;
  end;
end;

procedure testExtractQuotedStr;
  procedure mycheck(s{҂錋}, s2{֐ɓne}: String; s3: char);
  begin
    Check(s, ExtractQuotedStr(s2, s3));
  end;
begin
  mycheck('ABC',    '"ABC"',  '"');
  mycheck('ABC ',   '"ABC "', '"');
  mycheck('ABC',    'ABC',    '"');
  mycheck('"ABC"',  '"ABC"',  '''');
  mycheck('""',     '""""',   '"');
  mycheck('A',      'A',      '"');
  mycheck('',       '',       '"');
end;

function ExtractUrlLastPath(Url: string): string;
var
  I: Integer;
begin
  if  (Length(Url) > 0) then  begin
    if  (Url[Length(Url)] <> '/')  then Url :=  ExtractURLPath(Url);
    Url :=  Copy(Url,1,Length(Url) - 1);
    I := LastDelimiter('/:', Url);
    Result := Copy(Url, I + 1, Length(Url) - I);
  end else begin
    Result  :=  '';
  end;
end;

procedure testExtractURLLastPath;
  procedure mycheck(s{҂錋}, s2{֐ɓne}: String);
  begin
    Check(s, ExtractURLLastPath(s2));
  end;
begin
  mycheck('www.2ch.net',  'http://www.2ch.net/');
  mycheck('tech',         'http://piza.2ch.net/tech/index2.html');
  mycheck('tech',         'http://piza.2ch.net/tech/index2.html#menu');
  mycheck('',             'http://www.yahoo.co.jp' );
  mycheck('',             'www.yahoo.co.jp' );
  mycheck('','');
end;

function IsNumeric(s: string): boolean;
begin
  try
  	StrToInt(s);
  	Result := true;
  except
    on EConvertError do
    	Result := false;
  end;

end;

procedure testIsNumeric;
  procedure mycheck(r{҂錋}: boolean; s2{֐ɓne}: String);
  begin
    Check(r, IsNumeric(s2));
  end;
begin
  mycheck(True, '12345');
  mycheck(True, '-12345');
  mycheck(False,'123.45');
  mycheck(False,'12345F' );
  mycheck(True,  '+50');
  mycheck(False,'PQRST');
  mycheck(False,'');
end;

function IsFloat(s: string): boolean;
var
  v: Extended;
begin
  Result := TextToFloat(PChar(s), v, fvExtended);
end;

procedure testIsFloat;
  procedure mycheck(r{҂錋}: boolean; s2{֐ɓne}: String);
  begin
    Check(r, IsFloat(s2));
  end;
begin
  mycheck(True, '12345.0');
  mycheck(True, '-12345.0');
  mycheck(True,'123.45');
  mycheck(True, '12345');
  mycheck(False,'12345F' );
  mycheck(True,  '+50');
  mycheck(False,'PQRST');
  mycheck(False,'');
end;


function Fmt2chToDateTime(Fmt2ch: String): TDateTime;
var
  Year, Month, Day: word;
  Hour, Min, Sec, MSec: word;
begin
  try
    Fmt2ch  :=  Trim(Fmt2ch); //dax
    Year    := StrToInt(Copy(Fmt2ch, 1, 4));
    Month   := StrToInt(Copy(Fmt2ch, 6, 2));
    Day     := StrToInt(Copy(Fmt2ch, 9, 2));

    Hour    := StrToInt(Copy(Fmt2ch,16, 2));
    Min     := StrToInt(Copy(Fmt2ch,19, 2));
    Sec := 0;
    MSec:= 0;

    Result := EncodeDate(Year, Month, Day)
                + EncodeTime(Hour, Min, Sec, MSec);
  except
    raise EConvertError.Create('tϊ˂(߄D)٧');
  end;
end;

procedure testFmt2chToDateTime;
  procedure mycheck(d{҂錋}: TDateTime; s2{֐ɓne}: String);
  begin
    Check(d, Fmt2chToDateTime(s2));
  end;
begin
  mycheck(StrToDateTime('2001/02/18 15:23:00'),
          '2001/02/18() 15:23');

  mycheck(StrToDateTime('2001/02/18 15:23:00'),
          '2001/02/18() 15:23 ID=???');

  //̓G[
  {
  mycheck(StrToDateTime('0'),
          'ځ[');
  }
end;

//S̒SubStr邩JEg(2oCgΉ)
{Ƃ̕폜ČƂȂ̂
 ""Ƃ񂩂""̌𑪒肷3Ԃ}
function StrCount1(const Substr, S: string): Integer;
var
  Str: String;
begin
  Result := 0;
  if (Substr = '') or (S = '') then exit;

  Str := S;
  try
    while AnsiPos( Substr, Str) <> 0 do
    begin
      Inc(Result);
      delete(Str, AnsiPos( Substr, Str), Length(Substr));
    end;
  except
    Result := -1;
  end;
end;

procedure testStrCount1;
  procedure mycheck(r{҂錋}: integer; s2, s3{֐ɓne}: String);
  begin
    Check(r, StrCount1(s3, s2));
  end;
begin
  mycheck(3, '', '');
  mycheck(3, 'BorlandDelphiBorlandC++BuilderBorlandKylix', 'Borland');
  mycheck(2, 'BorlandDelphiBorlandC++BuilderBorlandKylix', '+');
  mycheck(4, 'http://www.2ch.net/hogehoge/test', '/');
  mycheck(0, 'http://www.2ch.net/hogehoge/test', '+');
  mycheck(0, '+', '+++++');
  mycheck(0, '', '+');
end;

//̌
{""""ƃoCg7Ԃ}
function BackAnsiPos(const SubStr,S: String): Integer;
var
  SearchStr: String;
  BackPosIndex: Integer;
  MbcsFlag: TMbcsByteType;
begin
  Result := 0;
  MbcsFlag := mbSingleByte; {ɈӖ̂Ȃ}
  if AnsiPos(subStr,S)=0 then exit;

  SearchStr := S;
  while AnsiPos(subStr,SearchStr)<>0 do
  begin
    BackPosIndex := AnsiPos(subStr,SearchStr);
    MbcsFlag := ByteType(SearchStr, BackPosIndex);
    case MbcsFlag of

      mbSingleByte:  { p }
        Delete(SearchStr,1,BackPosIndex);

      mbLeadByte:    { Sp̂PoCg }
        Delete(SearchStr,1,BackPosIndex  +1  );

      mbTrailByte:   { Sp̂QoCg }
        Delete(SearchStr,1,BackPosIndex);
    else
      raise Exception.Create('G[');
    end;
  end; //while

  case MbcsFlag of
    mbSingleByte:
      Result := length(S)-Length(SearchStr);

    mbLeadByte:
      Result := length(S)-Length(SearchStr) - 1;

    mbTrailByte:
      Result := length(S)-Length(SearchStr);
  else
    raise Exception.Create('G[');
  end;
end;

procedure testBackAnsiPos;
  procedure mycheck(r{҂錋}: integer; s2, s3{֐ɓne}: String);
  begin
    Check(r, BackAnsiPos(s3, s2));
  end;
begin
  mycheck(9, '', '');
  mycheck(31,'BorlandDelphiBorlandC++BuilderBorlandKylix', 'Borland');
  mycheck(28,'http://www.2ch.net/hogehoge/test', '/');
  mycheck(0, 'http://www.2ch.net/hogehoge/test', '+');
  mycheck(0, '+', '+++++');
  mycheck(0, '', '+');
end;

//URLDOSpXɕύX
function  UrlToDosPath(const Url: string): string;
const
  PATH_TERMINATE = '\';
var
  S : string;
  n, m : integer;
begin
  if  (AnsiPos('http://', Url) = 1) then  begin
    s :=  Copy(Url, 8, Length(Url));
  end else begin
    s :=  Url;
  end;
  n :=  AnsiPos(':', s);
  if  (n > 0) then  begin
    m :=  AnsiPos('/', s);
    s :=  'http://' +
          Copy(s, 1, n - 1) +
          Copy(s, m, Length(Url));
  end;

  S :=  AnsiLowerCase(
          MonaUtils.ExcludeTrailingSlash(
            MonaUtils.ExtractUrlPath(S)));
  if  (S = '')  then  begin
    Result  :=  Url;
    Exit;
  end;
  if  (Copy(S,1,7) = 'http://') then  begin
    S :=  Copy(S,8,Length(S) - 7);
  end;

  S :=  StringReplace(S, '/', PATH_TERMINATE, [rfReplaceAll]);

  if  (Copy(S,Length(S) - 3, 4) = PATH_TERMINATE + 'dat') then  begin
    S :=  Copy(S,1,Length(S) - 4);      
  end;
  Result  :=    S + PATH_TERMINATE + MonaUtils.ExtractUrlName(Url);
end;

procedure testUrlToDosPath;
  procedure mycheck(r{҂錋}: string; s1{֐ɓne}: String);
  begin
    Check(r, UrlToDosPath(s1));
  end;
begin
  mycheck('www.2ch.net\',               'http://www.2ch.net/');
  mycheck('www.2ch.net\test\read.cgi',  'http://www.2ch.net/test/read.cgi');
  mycheck('www.2ch.net\test\',          'www.2ch.net/test/');
  mycheck('www.2ch.net\test',           'www.2ch.net/test');
  mycheck('ABCDEFG',                    'ABCDEFG');
  mycheck('\abcdefg\',                  '/abcdefg/');
  mycheck('www.2ch.net\abc\def',        'http://www.2ch.net/abc\def');
end;

//?param=value paramw肷 valueԂ
function ChooseValue(const Url, Key: string): string;
var
  List  : TStringList;
  S : PChar;
begin
  GetMem(S, Length(Url) + 1);
  StrCopy(S, PChar(Url));
  List  :=  TStringList.Create;
  {$IFDEF VER120}
    ExtractHttpFields(['?','&'], [], S, List);
  {$ELSE}
    ExtractHttpFields(['?','&'], [], S, List, False);
  {$ENDIF}
  Result  :=  List.Values[Key];
  List.Free;
  FreeMem(S);
end;

procedure testChooseValue;
  procedure mycheck(r{҂錋}: string; s1, s2{֐ɓne}: String);
  begin
    Check(r, ChooseValue(s1, s2));
  end;
begin
  mycheck('tech',
          'http://www.2ch.net/test/read.cgi?bbs=tech&key=12345678&st=10',
          'bbs');
  mycheck('12345678',
          'http://www.2ch.net/test/read.cgi?bbs=tech&key=12345678&st=10',
          'key');
  mycheck('10',
          'http://www.2ch.net/test/read.cgi?bbs=tech&key=12345678&st=10',
          'st');
  mycheck('',
          'http://www.2ch.net/test/read.cgi?bbs=tech&key=12345678&st=10',
          'to');
  mycheck('',
          'http://www.2ch.net/test/read.cgi',
          'bbs');
  mycheck('10',
          'http://www.2ch.net/test/read.cgi?bbs=tech&key=12345678&st=10&st=20',
          'st');
end;

//URL̃}[W
function MargeUrl(const BaseUrl, NewUrl: string): string;
var
  s,r,b : string;
  l : TStringList;
  i, count : integer;
begin
  if  (NewUrl = '') then  begin
    Result  :=  BaseUrl;
    Exit;
  end else
  if  (NewUrl[1]  = '/')  then  begin
    Result  :=  'http://' + ExtractHostName(BaseUrl) + NewUrl;
    Exit;
  end;
  count :=  0;
  s :=  NewUrl;
  while true  do  begin
    if  (Copy(s,1,3) = '../')  then  begin
      s :=  Copy(s, 4, Length(s) - 3);
      inc(count);
    end else
    if  (Copy(s,1,2) = './')  then  begin
      s :=  Copy(s, 3, Length(s) - 2);
    end else begin
      Break;
    end;
  end;
  r := '';
  b := ExtractUrlPath(BaseUrl);
  b := Copy(b,7,Length(b));
  l :=  TStringList.Create;
  ExtractHTTPFields(['/'],[],PChar(b), l);
  for i :=  0 to  l.Count - count - 1 do  begin
    r :=  r + '/'+ l[i];
  end;
  Result  :=  'http:/' + r + '/' + s;
end;

procedure testMargeUrl;
  procedure mycheck(r{҂錋}: string; s1, s2{֐ɓne}: String);
  begin
    Check(r, MargeUrl(s1, s2));
  end;
begin
  mycheck('http://www.2ch.net/dat',
          'http://www.2ch.net/test/',
          '../dat');
  mycheck('http://www.2ch.net/dat',
          'http://www.2ch.net/test/data',
          '../dat');
  mycheck('http://www.2ch.net/test/dat',
          'http://www.2ch.net/test/data',
          './dat');
  mycheck('http://www.2ch.net/test/dat/',
          'http://www.2ch.net/test/data',
          './dat/');
  mycheck('http://www.2ch.net/',
          'http://www.2ch.net/test/',
          '../');
  mycheck('http://www.2ch.net/',
          'http://www.2ch.net/test/',
          '/');
  mycheck('http://www.2ch.net/test/a/',
          'http://www.2ch.net/test/',
          'a/');
end;

//A HREF^O̒URL𒊏o
function ExtractHrefUrl(const s: string): string;
var
  r : string;
  n : integer;
begin
  n :=  AnsiPos('href', AnsiLowerCase(s));
  r :=  Copy(s, n, Length(s));
  n :=  AnsiPos('>', r);
  if  (n > 0) then  r :=  Copy(r, 1, n - 1);
  n :=  AnsiPos(' ', r);
  if  (n > 0) then  r :=  Copy(r, 1, n - 1);
  n :=  AnsiPos('=', r);
  r :=  Copy(r, n + 1, Length(r));
  n :=  AnsiPos('"', r);
  if  (n > 0) then  r :=  Copy(r, 2, Length(r)  - 2);
  Result  :=  r;
end;

procedure testExtractHrefUrl;
  procedure mycheck(r{҂錋}: string; s1{֐ɓne}: String);
  begin
    Check(r, ExtractHrefUrl(s1));
  end;
begin
  mycheck('http://www.2ch.net/dat/',
          '<A HREF="http://www.2ch.net/dat/">');
  mycheck('http://www.2ch.net/dat/',
          '<a href=http://www.2ch.net/dat/>');
  mycheck('http://www.2ch.net/dat/',
          '<a target=_blank href=http://www.2ch.net/dat/>');
  mycheck('http://www.2ch.net/dat/',
          '<a target=_blank href=http://www.2ch.net/dat/><a href=http://www.2ch.net/test/>');
end;

function ZenToHan(const s: string): string;
var
  Chr : array [0..255]  of  char;
begin
  {$IFDEF LINUX}
  //**LINUX**
  {$ENDIF}
  {$IFDEF MSWINDOWS}
  Windows.LCMapString(
     GetUserDefaultLCID(),
     LCMAP_HALFWIDTH,
     PChar(s),
     Length(s) + 1,
     chr,
     Sizeof(chr)
     );
  Result :=  Chr;
  {$ENDIF}
end;

procedure testZenToHan;
  procedure mycheck(r{҂錋}: string; s1{֐ɓne}: String);
  begin
    Check(r, ZenToHan(s1));
  end;
begin
  mycheck('',      'ACEGI');
  mycheck('', 'ACEGI');
  mycheck('ABC',        '`ab');
  mycheck('',       '');
  mycheck('ABC',    '`ab');
end;

function GetContentLength(S : string): integer;
var
  p : PChar;
  p_end : PChar;
  n : integer;
begin
  p :=  PChar(s);
  p_end :=  PChar(s) + Length(s);
  n :=  0;
  while p < p_end do begin
    if p^ = #13 then begin
      //
    end else begin
      inc(n);
    end;
    Inc(p);
  end;
  Result  :=  n;
end;

procedure testGetContentLength;
  procedure mycheck(r{҂錋}: integer; s1{֐ɓne}: String);
  begin
    Check(r, GetContentLength(s1));
  end;
begin
  mycheck(1,      'A');
  mycheck(0,      '');
  mycheck(14,     '<HTML>' + #13#10 + '</HTML>');
  mycheck(14,     '<HTML>' + #10 + '</HTML>');
  mycheck(15,     '<HTML>' + #13#10 + #9 + '</HTML>');
  mycheck(20,     '<HTML>' + #13#10 + 'Hello' + #0 + '</HTML>');  //#0JEg
end;

function TrimTag(const s: string): string;
var
  r : string;
  b : boolean;
  i : integer;
begin
  r :=  '';
  b :=  False;
  for i :=  1 to  Length(s) do  begin
    if  (ByteType(s, i) = mbSingleByte) then  begin
      if  (s[i] = '<') then  begin
        b :=  True;
      end else
      if  (s[i] = '>') and (b) then  begin
        b :=  False;
      end else
      if  (not b) then  begin
        r :=  r + s[i];
      end;
    end else begin
      if  (not b) then  begin
        r :=  r + s[i];
      end;
    end;
  end;
  Result  :=  Trim(r);
end;

procedure testTrimTag;
  procedure mycheck(r{҂錋}: string; s1{֐ɓne}: String);
  begin
    Check(r, TrimTag(s1));
  end;
begin
  mycheck('ACEGI',   '<ABC>ACEGI</ABC>');
  mycheck('ACEGI',   '<Ă悵>ACEGI</I}Gi[>');
  mycheck('',         '<<<a>>><<</a>>>');
  mycheck('ACEGI',   'ACEGI');
  mycheck('',             '<A HREF="ACEGI">');
  mycheck('ABC',          '<A HREF="ACEGI">ABC</A>');
end;

function AddTargetBlank(const Value: string): string;
var
  Org, s, r : string;
  x, y, z, t : string;
  p, i : integer;
begin
  r   :=  '';
  Org :=  Value;
  while true  do  begin
    p :=  AnsiPos('<a', AnsiLowerCase(Org));
    if  (p > 0) then  begin
      //擪<A ܂ł --> r
      s :=  Copy(Org, 1, p - 1);
      r :=  r + s;
      //<A  > ܂ł --> s

      // s = "<A xxxx xxxxxx>"
      //t :=  Copy(Org, p, Length(org));
      s :=  Copy(Org, p, Length(org));
      i :=  AnsiPos('>', s);
      t :=  Copy(s, i + 1, Length(s));
      s :=  Copy(S, 1, i);

      if  (AnsiPos('href', AnsiLowerCase(s)) > 0) then  begin
        //TARGET=
        p :=  AnsiPos('TARGET=', AnsiUpperCase(s));
        if  (p > 0) then  begin
          x :=  Copy(s, 1, p - 1);  //TARGET܂
          y :=  Copy(s, p, Length(s));  //TARGETȍ~
          i :=  AnsiPos(' ', y);
          if  (i > 0) then  begin
            y :=  Copy(y, 1, i - 1);
          end;
          i :=  AnsiPos('>', y);
          if  (i > 0) then  begin
            y :=  Copy(y, 1, i - 1);
          end;
          //TARGET ̂ --> y
          z :=  Copy(s, Length(x) + Length(y) + 1, Length(s)); //TARGET
          //
          s :=  x + 'TARGET="_blank"' + z;
          r :=  r + s;
          //org :=  Copy(org, AnsiPos('>', Org) + 1, Length(org));
          Org := t;
        end else begin
          //<A xxxxxxx>
          s :=  Copy(s, 1, Length(S) - 1) + ' TARGET="_blank">';
          r :=  r + s;
          //org :=  Copy(org, AnsiPos('>', Org) + 1, Length(org));
          Org := t;
        end;


      end else begin
        r :=  r + s;
        org :=  t; //Copy(org, Length(t) + 1, Length(org));
      end;

    end else begin;
      r :=  r + Org;
      Break;
    end;
  end;
  Result  :=  r;
end;

{
function AddTargetBlank(const Value: string): string;
var
  org , s, r, w, x, y, z : string;
  frx, tox, i : integer;
  b : boolean;
begin
  org :=  Value;
  r   :=  '';
  while true  do  begin
    //frx :=  AnsiPos('<A HREF=', AnsiUpperCase(org));
    frx :=  AnsiPos('<A ', AnsiUpperCase(org));
    if  (frx > 0) then  begin
      r :=  r + Copy(org, 1, frx);
      org :=  Copy(org, frx + 1, Length(org));
      tox :=  AnsiPos('>', AnsiUpperCase(org));
      if  (tox > 0) then  begin
        s   :=  Copy(org, 1, tox - 1);
        if  (AnsiPos('TARGET=', AnsiUpperCase(org)) = 0)  then  begin
          s :=  s + ' TARGET="_blank"';
          r :=  r + s;
          org :=  Copy(org, tox, Length(org));
        end else begin
          //
          //  x = '<A HREF=xxxxxxxx |TARGET
          //x :=  Copy(S, 1, AnsiPos('TARGET=', S) - 1);
          //y :=  Copy(S, AnsiPos('TARGET=', S), Length(S));
          //z :=  Copy(y, AnsiPos(' ', y) + 1, Length(y));
          b := False;
          x :=  Copy(org, 1, AnsiPos('TARGET=', org) - 1);
          w :=  Trim(Copy(org, Length(x) + 1, Length(org)));
          i :=  AnsiPos(' ', w);
          if  (i > 0) then  begin
            y :=  Copy(w, 1, i - 1);
          end else begin
            y :=  w;
            b :=  True;
          end;
          i :=  AnsiPos('>', y);
          if  (i > 0) then  begin
            y :=  Copy(y, 1, i - 1);
          end;
          z :=  Copy(org, Length(x) + Length(y) + 1, Length(org));

          if  (Length(x) > 0) then  begin
            if  (Copy(x, Length(x), 1) <> ' ')  then  begin
              x :=  x + ' ';
            end;
          end;
          if  (b) then begin
            s :=  x + 'TARGET="_blank"' + z;
          end else begin
            s :=  x + 'TARGET="_blank"';// + z;
          end;

          //x :=  x + ' TARGET="_blank"';
          //s :=  s + ' TARGET="_blank"';
          r :=  r + s;
          org :=  Copy(org, Length(s), Length(org));
          if  (Length(org) > 0) then  begin
            if  (org[1] = '"')  then  begin
              org :=  Copy(org, 2, Length(org));
            end;
          end;
        end;
      end else begin
        r :=  r + org;
        Break;
      end;
    end else begin
      r :=  r + org;
      Break;
    end;
  end;
  Result  :=  r;
end;
}
procedure testAddTargetBlank;
  procedure mycheck(r{҂錋}: string; s1{֐ɓne}: String);
  begin
    Check(r, AddTargetBlank(s1));
  end;
begin
  mycheck('̂PPOOO𒴂̂łQɈڍsƂƂŁB<BR><BR><BR>P͂łB<BR><BR><a href=http://www.megabbs.com/cgi-bin/readres.cgi TARGET="_blank"></a><BR>',
          '̂PPOOO𒴂̂łQɈڍsƂƂŁB<BR><BR><BR>P͂łB<BR><BR><a href=http://www.megabbs.com/cgi-bin/readres.cgi></a><BR>');
  mycheck('<A HREF="http://www.2ch.net" TARGET="_blank">2ch</A>',
          '<A HREF="http://www.2ch.net" TARGET="_blank">2ch</A>');
  mycheck('AAA<A HREF="http://www.2ch.net" TARGET="_blank">2ch</A>',
          'AAA<A HREF="http://www.2ch.net">2ch</A>');
  mycheck('<A HREF="http://www.2ch.net" TARGET="_blank">2ch</A>',
          '<A HREF="http://www.2ch.net">2ch</A>');
  mycheck('<a href="http://www.2ch.net" TARGET="_blank">2ch</A>',
          '<a href="http://www.2ch.net">2ch</A>');
  mycheck('<a href=http://www.2ch.net TARGET="_blank">2ch</A>',
          '<a href=http://www.2ch.net>2ch</A>');
  mycheck('<A HREF="http://www.2ch.net" TARGET="_blank">2ch</A>',
          '<A HREF="http://www.2ch.net" TARGET="parent">2ch</A>');
  mycheck('<A TARGET="_blank" HREF="http://www.2ch.net">2ch</A>',
          '<A TARGET="_blank" HREF="http://www.2ch.net">2ch</A>');
  mycheck('<A TARGET="_blank" HREF=http://www.2ch.net>2ch</A>',
          '<A TARGET=_top HREF=http://www.2ch.net>2ch</A>');
  mycheck('<A NAME="AA">2ch</A>',
          '<A NAME="AA">2ch</A>');
  mycheck('<A>2ch</A>',
          '<A>2ch</A>');
  mycheck('2ch',
          '2ch');
end;

function  ExtractDatNo(const DatFileName: string): string;
var
  s, ext : string;
begin
  if  (AnsiPos('http:', DatFileName) = 1) then  begin
    s   :=  ExtractUrlName(DatFileName);
  end else begin
    s   :=  ExtractFileName(DatFileName);
  end;
  ext :=  ExtractFileExt(s);
  if  (ext <> '') then  begin
    s :=  Copy(s, 1, Length(s) - Length(ext));
  end;
  Result  :=  s;
end;

procedure testExtractDatNo;
  procedure mycheck(r{҂錋}: string; s1{֐ɓne}: String);
  begin
    Check(r, ExtractDatNo(s1));
  end;
begin
  mycheck('123456789',
          '123456789.dat');
  mycheck('123456789',
          '123456789');
  mycheck('123456789',
          'http://www.2ch.net/tech/dat/123456789.dat');
  mycheck('123456789',
          'C:\monazilla\monaplorer\dat\123456789.dat');
  mycheck('123456789_1',
          '123456789_1.dat');
  mycheck('123456789_1',
          '123456789_1');
  mycheck('123456789_1',
          'http://www.2ch.net/tech/dat/123456789_1.dat');
  mycheck('123456789_1',
          'C:\monazilla\monaplorer\dat\123456789_1.dat');
end;

//Tue, 17 Dec 2002 12:18:07 GMT  TDateTime
function  DateStrToDateTime(const DateStr: string): TDateTime;
  function  StrMonthToMonth(const s: string): integer;
  const
    m: array[1..12] of string = ('Jan','Feb','Mar','Apr','May','Jun', 'Jul','Aug','Sep','Oct','Nov','Dec');
  var
    i: integer;
  begin
    Result  :=  -1;
    for i :=  Low(m)  to  High(m) do  begin
      if  (SameText(s, m[i]))  then  begin
        Result  :=  i;
        Break;
      end;
    end;
  end;
var
  wDay, wMonth, wYear: word;
  wHour, wMinute, wSecond: word;
  sTime: string;
  d: TDateTime;
begin
  wDay    :=  StrToIntDef(ChooseString(DateStr, ' ', 1), 0);
  wMonth  :=  StrMonthToMonth(ChooseString(DateStr, ' ', 2));
  wYear   :=  StrToIntDef(ChooseString(DateStr, ' ', 3), 0);
  sTime   :=  ChooseString(DateStr, ' ', 4);
  wHour   :=  StrToIntDef(ChooseString(sTime, ':', 0), 0);
  wMinute :=  StrToIntDef(ChooseString(sTime, ':', 1), 0);
  wSecond :=  StrToIntDef(ChooseString(sTime, ':', 2), 0);
  d :=  EncodeDateTime(wYear, wMonth, wDay, wHour, wMinute, wSecond, 0);
  Result  :=  d;
end;

procedure testDateStrToDateTime;
  procedure mycheck(r{҂錋}: TDateTime; s1{֐ɓne}: String);
  begin
    Check(r, DateStrToDateTime(s1));
  end;
begin
  mycheck(StrToDateTime('2002/12/17 12:18:07'),
                        'Tue, 17 Dec 2002 12:18:07 GMT');
  mycheck(StrToDateTime('2003/1/10 23:15:10'),
                        'Fri, 10 Jan 2003 23:15:10 GMT');
  mycheck(StrToDateTime('2004/2/29 00:00:00'),
                        'Fri, 29 Feb 2004 00:00:00 GMT');
  mycheck(StrToDateTime('2001/11/11 11:22:33'),
                        'Fri, 11 Nov 2001 11:22:33 JST');
end;


procedure testMonaUtils;
begin
  ClearTestResult;
  try
    //testMonaHtmlParser;
    //testMonaProfiler;
    //testExtractUrlPath;
    //testExtractUrlName;
    //testMaxMin;
    //testIncludeTrailingSlash;
    //testExcludeTrailingSlash;
    //testIsUrlDelimiter;
    //testLoadSaveString;
    //testFindFile;
    //testAddHRefTag;
    //testTrimHRefTag;
    //testDecodeHtmlEsc;
    //testEncodeHtmlEsc;
    //testExtractHostName;
    //testGet2chDate;
    //testChooseString;
    //testExtractQuotedStr;
    //testExtractUrlLastPath;
    //testIsNumeric;
    //testFmt2chToDateTime;
    //testStrCount1;
    //testBackAnsiPos;
    //testIsFloat;
    //testUrlToDosPath;
    //testChooseValue;
    //testMargeUrl;
    //testExtractHrefUrl;
    //testZenToHan;
    //testGetContentLength;
    //testTrimTag;
    //testAddTargetBlank;
    //testExtractDatNo;
    //testAddTargetBlank;
    testDateStrToDateTime;
  except
    on E:ETestFailure do
      ;
    on E:Exception do
      Inc(TestResult.Error);
  end;
end;

initialization
	if not QueryPerformanceFrequency(TMonaProfiler_FFrequency) then
		RaiseLastWin32Error;

end.
